/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EventPolicyCollection;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.LimitDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.PublicationStatus;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ResponsibleDef;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.TagCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public final class ProcessHeaderDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -3444386496942904336L;
    private static final String DEFUALTVENDOR = "Copyright Kingdee BOS 2004";
    private static final String DEFUALTICON = "workflow.gif";
    private static final String DEFUALTCOUNTRYKEY = "zh_CN";
    private static final String DEFUALTCODEPAGE = "936";
    private PublicationStatus publicationStatus;
    private String packageName;
    private static final String BIZ_PACKAGE = KpdlResourceUtils.PROCESS_BIZPACKAGE.getName();
    private static final String DESCRIPTION = KpdlResourceUtils.PROCESSHEADER_DESCRIPTION.getName();
    private static final String VENDOR = KpdlResourceUtils.PROCESSHEADER_VENDOR.getName();
    private String kdplVersion;
    private String version;
    private int priority;
    private Date created;
    private LimitDef limit;
    private Date validFrom;
    private Date validTo;
    private String author;
    private String codePage;
    private String countryKey;
    private ResponsibleCollection responsibles;
    private EventPolicyCollection eventPolicies;
    private ScheduleDef scheduale;
    private String icon;
    private boolean enableClientStart;
    private boolean isCheckPostActivitiesPerson;
    private boolean isSetPostActivitiesPerson;
    private String interfaceName;
    private static final String PROCESSTOPIC = KpdlResourceUtils.PROCESSHEADER_PROCESSTOPIC.getName();
    private TagCollection tags;

    public String getAuthor() {
        return this.author;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public String getCountryKey() {
        return this.countryKey;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription(Locale locale) {
        if (this.getDescriptionResource() == null) {
            return null;
        }
        return this.getDescriptionResource().getValue(locale);
    }

    public String getDescription() {
        return this.getDescription(this.container.getLocale());
    }

    public Resource getDescriptionResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(DESCRIPTION + this.container.getID());
    }

    public Resource getBizPackageResource() {
        return this.resources.get(BIZ_PACKAGE + this.container.getID());
    }

    public String getBizPackage() {
        return this.getBizPackage(this.container.getLocale());
    }

    public String getBizPackage(Locale locale) {
        if (this.getBizPackageResource() == null) {
            return null;
        }
        return this.getBizPackageResource().getValue(locale);
    }

    public void setBizPackage(String destBizPackage) throws WfException {
        this.setBizPackage(this.locale, destBizPackage);
    }

    public void setBizPackage(Locale locale, String destBizPackage) throws WfException {
        if (this.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (this.getBizPackageResource() == null) {
            this.setBizPackage(new Resource(BIZ_PACKAGE, this.container.getID(), locale, destBizPackage));
        } else {
            this.getBizPackageResource().setValue(locale, destBizPackage);
        }
    }

    public void setBizPackage(Resource destBizPackage) throws WfException {
        if (this.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(BIZ_PACKAGE + this.container.getID(), destBizPackage);
    }

    public String getKdplVersion() {
        return this.kdplVersion;
    }

    public LimitDef getLimit() {
        return this.limit;
    }

    public int getPriority() {
        return this.priority;
    }

    public PublicationStatus getPublicationStatus() {
        return this.publicationStatus;
    }

    public ResponsibleCollection getResponsibles() {
        return this.responsibles;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public String getVendor() {
        return this.getVendor(this.container.getLocale());
    }

    public String getVendor(Locale locale) {
        if (this.getVendorResource() == null) {
            return null;
        }
        return this.getVendorResource().getValue(locale);
    }

    public Resource getVendorResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(VENDOR + this.container.getID());
    }

    public String getVersion() {
        return this.version;
    }

    public EventPolicyCollection getEventPolicies() {
        return this.eventPolicies;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setEventPolicies(EventPolicyCollection collection) {
        this.eventPolicies = collection;
    }

    public ResponsibleDef getResponsibleDef(String responsibleDefID) throws WfException {
        if (responsibleDefID == null || responsibleDefID.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.responsibles.get(responsibleDefID);
    }

    public ResponsibleDef putResponsibleDef(ResponsibleDef destResponsibleDef) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destResponsibleDef == null) {
            throw new IllegalArgumentException();
        }
        return this.responsibles.set(destResponsibleDef.getID(), destResponsibleDef);
    }

    public void setDescription(String destDescription) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setDescription(this.container.getLocale(), destDescription);
    }

    public void setDescription(Locale locale, String destDesc) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destDesc == null) {
            throw new IllegalArgumentException();
        }
        if (this.getDescriptionResource() == null) {
            this.setDescription(new Resource(DESCRIPTION, this.container.getID(), locale, destDesc));
        } else {
            this.getDescriptionResource().setValue(locale, destDesc);
        }
    }

    public void setDescription(Resource destDesc) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(DESCRIPTION + this.container.getID(), destDesc);
    }

    public void setVendor(String string) throws WfException {
        this.setVendor(this.container.getLocale(), string);
    }

    public void setVendor(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.getVendorResource() == null) {
            this.setVendor(new Resource(VENDOR, this.container.getID(), locale, string));
        } else {
            this.getVendorResource().setValue(locale, string);
        }
    }

    public void setVendor(Resource destVendor) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(VENDOR + this.container.getID(), destVendor);
    }

    public void setKdplVersion(String string) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.kdplVersion = string;
    }

    public void setCountryKey(String destCountryKey) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destCountryKey == null || destCountryKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.countryKey = destCountryKey;
    }

    public void setAuthor(String author) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (author == null || author.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.author = author;
    }

    public void setCodePage(String destCodePage) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destCodePage == null || destCodePage.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.codePage = destCodePage;
    }

    public void setCreated(Date date) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (this.created == null) {
            throw new IllegalArgumentException();
        }
        this.created = date;
    }

    public void setLimit(LimitDef destLimit) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destLimit == null) {
            throw new IllegalArgumentException();
        }
        this.limit = destLimit;
    }

    public void setPriority(int i) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.priority = i;
    }

    public void setPublicationStatus(PublicationStatus status) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.publicationStatus = status;
    }

    public void setResponsibles(ResponsibleCollection destResponsibles) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destResponsibles == null) {
            throw new IllegalArgumentException();
        }
        this.responsibles = destResponsibles;
    }

    public void setValidFrom(Date date) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.validFrom = date;
    }

    public void setValidTo(Date date) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.validTo = date;
    }

    public void setVersion(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.version = string;
    }

    public ScheduleDef getScheduale() {
        return this.scheduale;
    }

    public void setScheduale(ScheduleDef def) {
        this.scheduale = def;
    }

    public ProcessHeaderDef(ProcessDef process) {
        block7: {
            this.setContainer(process);
            this.packageName = "";
            if (this.container != null) {
                try {
                    if (this.getDescriptionResource() == null) {
                        this.setDescription(new Resource(DESCRIPTION, this.container.getID()));
                    }
                    if (this.getProcessTopicResource() == null) {
                        this.setProcessTopic(new Resource(PROCESSTOPIC, this.container.getID()));
                    }
                    if (this.getVendorResource() == null) {
                        this.setVendor(new Resource(VENDOR, this.container.getID(), DEFUALTVENDOR));
                    }
                    if (this.getBizPackageResource() == null) {
                        this.resources.set(BIZ_PACKAGE, new Resource(BIZ_PACKAGE, this.container.getID(), ""));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"ProcessHeader.construct error", (Throwable)((Object)e));
                }
            }
        }
        this.kdplVersion = "V6.1.0";
        this.version = "V6.1.0";
        this.priority = 0;
        this.created = new Date();
        this.limit = new LimitDef();
        this.validFrom = new Date(0L);
        this.validTo = new Date();
        this.author = "Kingdee BOS";
        this.codePage = DEFUALTCODEPAGE;
        this.countryKey = DEFUALTCOUNTRYKEY;
        this.responsibles = new ResponsibleCollection();
        this.publicationStatus = PublicationStatus.UNDER_REVISION;
        this.icon = DEFUALTICON;
        this.enableClientStart = true;
        this.isCheckPostActivitiesPerson = false;
        this.isSetPostActivitiesPerson = false;
        this.eventPolicies = new EventPolicyCollection(this.container);
        this.tags = new TagCollection(this.container);
    }

    public ProcessHeaderDef(Element destProcessHeaderElement) throws WfKpdlParseException {
        this.parse(destProcessHeaderElement);
    }

    public ProcessHeaderDef(ProcessDef process, Element destProcessHeaderElement) throws WfKpdlParseException {
        this(process);
        this.parse(destProcessHeaderElement);
    }

    @Override
    public Element toElement() {
        Element processHeaderElement = new Element("ProcessHeader", DefinitionConstants.NS_INSTANCE_KPDL);
        processHeaderElement.setAttribute("PublicationStatus", this.publicationStatus.getName());
        processHeaderElement.setAttribute("Package", this.packageName);
        Element descriptionElement = new Element("Description", DefinitionConstants.NS_INSTANCE_KPDL);
        descriptionElement.setText(DESCRIPTION);
        processHeaderElement.addContent((Content)descriptionElement);
        Element topicElement = new Element("ProcessTopic", DefinitionConstants.NS_INSTANCE_KPDL);
        topicElement.setText(PROCESSTOPIC);
        processHeaderElement.addContent((Content)topicElement);
        Element bizPackageElement = new Element("BizPackage", DefinitionConstants.NS_INSTANCE_KPDL);
        bizPackageElement.setText(BIZ_PACKAGE);
        processHeaderElement.addContent((Content)bizPackageElement);
        Element vendorElement = new Element("Vendor", DefinitionConstants.NS_INSTANCE_KPDL);
        vendorElement.setText(VENDOR);
        processHeaderElement.addContent((Content)vendorElement);
        Element KPDLVersionElement = new Element("KPDLVersion", DefinitionConstants.NS_INSTANCE_KPDL);
        KPDLVersionElement.setText(this.kdplVersion);
        processHeaderElement.addContent((Content)KPDLVersionElement);
        Element versionElement = new Element("Version", DefinitionConstants.NS_INSTANCE_KPDL);
        versionElement.setText(this.version);
        processHeaderElement.addContent((Content)versionElement);
        Element priorityElement = new Element("Priority", DefinitionConstants.NS_INSTANCE_KPDL);
        priorityElement.setText(String.valueOf(this.priority));
        processHeaderElement.addContent((Content)priorityElement);
        if (this.created != null) {
            Element createdElement = new Element("Created", DefinitionConstants.NS_INSTANCE_KPDL);
            createdElement.setText(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").format(this.created));
            processHeaderElement.addContent((Content)createdElement);
        }
        if (this.limit != null) {
            processHeaderElement.addContent((Content)this.limit.toElement());
        }
        if (this.validFrom != null) {
            Element validFromElement = new Element("ValidFrom", DefinitionConstants.NS_INSTANCE_KPDL);
            validFromElement.setText(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").format(this.validFrom));
            processHeaderElement.addContent((Content)validFromElement);
        }
        if (this.validTo != null) {
            Element validToElement = new Element("ValidTo", DefinitionConstants.NS_INSTANCE_KPDL);
            validToElement.setText(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").format(this.validTo));
            processHeaderElement.addContent((Content)validToElement);
        }
        Element authorElement = new Element("Author", DefinitionConstants.NS_INSTANCE_KPDL);
        authorElement.setText(this.author);
        processHeaderElement.addContent((Content)authorElement);
        Element codepageElement = new Element("Codepage", DefinitionConstants.NS_INSTANCE_KPDL);
        codepageElement.setText(this.codePage);
        processHeaderElement.addContent((Content)codepageElement);
        Element countrykeyElement = new Element("Countrykey", DefinitionConstants.NS_INSTANCE_KPDL);
        countrykeyElement.setText(this.countryKey);
        processHeaderElement.addContent((Content)countrykeyElement);
        Element iconElement = new Element("Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        iconElement.setText(this.icon);
        processHeaderElement.addContent((Content)iconElement);
        if (this.responsibles != null && this.responsibles.size() > 0) {
            processHeaderElement.addContent((Content)this.responsibles.toElement());
        }
        if (this.scheduale != null) {
            processHeaderElement.addContent((Content)this.scheduale.toElement());
        }
        if (this.eventPolicies != null && this.eventPolicies.size() > 0) {
            processHeaderElement.addContent((Content)this.eventPolicies.toElement());
        } else {
            processHeaderElement.addContent((Content)new Element("EventPolicies", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        if (this.resources != null) {
            processHeaderElement.addContent((Content)this.resources.toElement());
        }
        Element enableClientStartElement = new Element("EnableClientStart", DefinitionConstants.NS_INSTANCE_KPDL);
        enableClientStartElement.setText(String.valueOf(this.enableClientStart));
        processHeaderElement.addContent((Content)enableClientStartElement);
        Element enableNextPersonElement = new Element("IsCheckPostActivitiesPerson", DefinitionConstants.NS_INSTANCE_KPDL);
        enableNextPersonElement.setText(String.valueOf(this.isCheckPostActivitiesPerson));
        processHeaderElement.addContent((Content)enableNextPersonElement);
        Element enableSetNextPersonElement = new Element("IsSetPostActivitiesPerson", DefinitionConstants.NS_INSTANCE_KPDL);
        enableSetNextPersonElement.setText(String.valueOf(this.isSetPostActivitiesPerson));
        processHeaderElement.addContent((Content)enableSetNextPersonElement);
        Element eleInterfaceName = new Element("InterfaceName", DefinitionConstants.NS_INSTANCE_KPDL);
        eleInterfaceName.setText(this.interfaceName);
        processHeaderElement.addContent((Content)eleInterfaceName);
        if (this.tags != null && this.tags.size() > 0) {
            processHeaderElement.addContent((Content)this.tags.toElement());
        }
        return processHeaderElement;
    }

    @Override
    public String getID() {
        return this.container.getID();
    }

    @Override
    public void setContainer(AbstractKpdlElement element) {
        super.setContainer(element);
        this.container = (ProcessDef)element;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    @Override
    public String bosType() {
        return null;
    }

    public boolean isEnableClientStart() {
        return this.enableClientStart;
    }

    public void setEnableClientStart(boolean b) {
        this.enableClientStart = b;
    }

    @Override
    protected IKpdlElement innerParse(Element destProcessHeaderElement) throws WfKpdlParseException {
        Element tagsElement;
        Element enableClientStartElement;
        Element resourceElement;
        Element schedualeElement;
        Element eventPoliciesElement;
        if (destProcessHeaderElement == null) {
            throw new IllegalArgumentException();
        }
        String publicationStatusStr = destProcessHeaderElement.getAttributeValue("PublicationStatus");
        this.publicationStatus = PublicationStatus.getEnum(publicationStatusStr);
        this.packageName = XmlUtil.readStringAttr(destProcessHeaderElement, "Package");
        this.kdplVersion = XmlUtil.readString(destProcessHeaderElement, "KPDLVersion", DefinitionConstants.NS_INSTANCE_KPDL);
        this.version = XmlUtil.readString(destProcessHeaderElement, "Version", DefinitionConstants.NS_INSTANCE_KPDL);
        this.priority = XmlUtil.readInt(destProcessHeaderElement, "Priority", DefinitionConstants.NS_INSTANCE_KPDL);
        try {
            this.created = XmlUtil.readTimeStamp(destProcessHeaderElement, "Created", DefinitionConstants.NS_INSTANCE_KPDL);
        }
        catch (ParseException ex) {
            throw new WfKpdlParseException("", ex);
        }
        Element limitElement = destProcessHeaderElement.getChild("Limit", DefinitionConstants.NS_INSTANCE_KPDL);
        if (limitElement != null) {
            this.limit = new LimitDef(limitElement);
        }
        try {
            this.validFrom = XmlUtil.readTimeStamp(destProcessHeaderElement, "ValidFrom", DefinitionConstants.NS_INSTANCE_KPDL);
        }
        catch (ParseException ex) {
            throw new WfKpdlParseException("", ex);
        }
        try {
            this.validTo = XmlUtil.readTimeStamp(destProcessHeaderElement, "ValidTo", DefinitionConstants.NS_INSTANCE_KPDL);
        }
        catch (ParseException ex) {
            throw new WfKpdlParseException("", ex);
        }
        this.author = XmlUtil.readString(destProcessHeaderElement, "Author", DefinitionConstants.NS_INSTANCE_KPDL);
        this.codePage = XmlUtil.readString(destProcessHeaderElement, "Codepage", DefinitionConstants.NS_INSTANCE_KPDL);
        this.countryKey = XmlUtil.readString(destProcessHeaderElement, "Countrykey", DefinitionConstants.NS_INSTANCE_KPDL);
        this.icon = XmlUtil.readString(destProcessHeaderElement, "Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        Element responsibleListElement = destProcessHeaderElement.getChild("Responsibles", DefinitionConstants.NS_INSTANCE_KPDL);
        if (responsibleListElement != null) {
            this.responsibles = new ResponsibleCollection(responsibleListElement);
        }
        if ((eventPoliciesElement = destProcessHeaderElement.getChild("EventPolicies", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.eventPolicies = new EventPolicyCollection(this.container, eventPoliciesElement);
        }
        if ((schedualeElement = destProcessHeaderElement.getChild("Scheduale", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.scheduale = new ScheduleDef(this.container, schedualeElement);
        }
        if ((resourceElement = destProcessHeaderElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(resourceElement);
        }
        this.enableClientStart = (enableClientStartElement = destProcessHeaderElement.getChild("EnableClientStart", DefinitionConstants.NS_INSTANCE_KPDL)) != null && enableClientStartElement.getText() != null ? Boolean.valueOf(enableClientStartElement.getText()) : true;
        Element enableNextPersonElement = destProcessHeaderElement.getChild("IsCheckPostActivitiesPerson", DefinitionConstants.NS_INSTANCE_KPDL);
        this.isCheckPostActivitiesPerson = enableNextPersonElement != null && enableNextPersonElement.getText() != null ? Boolean.valueOf(enableNextPersonElement.getText()) : false;
        Element enableSetNextPersonElement = destProcessHeaderElement.getChild("IsSetPostActivitiesPerson", DefinitionConstants.NS_INSTANCE_KPDL);
        this.isSetPostActivitiesPerson = enableSetNextPersonElement != null && enableSetNextPersonElement.getText() != null ? Boolean.valueOf(enableSetNextPersonElement.getText()) : false;
        Element eleInterfaceName = destProcessHeaderElement.getChild("InterfaceName", DefinitionConstants.NS_INSTANCE_KPDL);
        if (eleInterfaceName != null && eleInterfaceName.getText() != null) {
            this.interfaceName = eleInterfaceName.getText();
        }
        if ((tagsElement = destProcessHeaderElement.getChild("Tags", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.tags = new TagCollection(this.container, tagsElement);
        }
        return this;
    }

    public Resource getProcessTopicResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(PROCESSTOPIC + this.container.getID());
    }

    public String getProcessTopic(Locale locale) {
        if (this.getProcessTopicResource() == null) {
            return null;
        }
        return this.getProcessTopicResource().getValue(locale);
    }

    public String getProcessTopic() {
        return this.getProcessTopic(this.container.getLocale());
    }

    public void setProcessTopic(String topic) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setProcessTopic(this.container.getLocale(), topic);
    }

    public void setProcessTopic(Locale locale, String topic) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (topic == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProcessTopicResource() == null) {
            this.setProcessTopic(new Resource(PROCESSTOPIC, this.container.getID(), locale, topic));
        } else {
            this.getProcessTopicResource().setValue(locale, topic);
        }
    }

    public void setProcessTopic(Resource destTopic) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(PROCESSTOPIC + this.container.getID(), destTopic);
    }

    public boolean isCheckPostActivitiesPerson() {
        return this.isCheckPostActivitiesPerson;
    }

    public void setCheckPostActivitiesPerson(boolean isCheckPostActivitiesPerson) {
        this.isCheckPostActivitiesPerson = isCheckPostActivitiesPerson;
    }

    public boolean isSetPostActivitiesPerson() {
        return this.isSetPostActivitiesPerson;
    }

    public void setSetPostActivitiesPerson(boolean isSetPostActivitiesPerson) {
        this.isSetPostActivitiesPerson = isSetPostActivitiesPerson;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public TagCollection getTags() {
        return this.tags;
    }

    public void setTags(TagCollection tags) {
        this.tags = tags;
    }
}

