/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.CorrelationPropertyAliasDef;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ScriptType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import org.jdom2.Element;

public class PropertyQueryDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -858698750717344588L;
    private static final String BOS_TYPE = "CPQRYDEF";
    private String id;
    private String expr;
    private ScriptType scriptType;

    public PropertyQueryDef(CorrelationPropertyAliasDef propertyAliasDef) {
        this.id = Uuid.create() + BOS_TYPE;
        this.container = propertyAliasDef;
    }

    public PropertyQueryDef(CorrelationPropertyAliasDef propertyAliasDef, Element destElement) throws WfKpdlParseException {
        this.container = propertyAliasDef;
        this.parse(destElement);
    }

    @Override
    protected IKpdlElement innerParse(Element destElement) throws WfKpdlParseException {
        this.id = XmlUtil.readStringAttr(destElement, "Id");
        this.expr = XmlUtil.readStringAttr(destElement, "Expr");
        String strScriptType = XmlUtil.readStringAttr(destElement, "ScriptType");
        this.scriptType = ScriptType.getEnum(strScriptType);
        return this;
    }

    @Override
    public Element toElement() {
        Element propertyElement = new Element("PropertyQuery", DefinitionConstants.NS_INSTANCE_KPDL);
        propertyElement.setAttribute("Id", this.id);
        propertyElement.setAttribute("Expr", this.expr);
        propertyElement.setAttribute("ScriptType", this.scriptType.getName());
        return propertyElement;
    }

    @Override
    public String bosType() {
        return BOS_TYPE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }
}

