/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.util.enums.Enum;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;

public class SchemaType
extends Enum
implements DataType {
    private static final long serialVersionUID = -4058304024101534744L;
    public static final SchemaType STRING = new SchemaType("string", "xsd", "http://www.w3.org/2001/XMLSchema", "string");
    public static final SchemaType INT = new SchemaType("int", "xsd", "http://www.w3.org/2001/XMLSchema", "int");
    private String prefix;
    private String namespace;
    private String localPart;

    public SchemaType(String name, String prefix, String namespace, String localPart) {
        super(name);
        this.prefix = prefix;
        this.namespace = namespace;
        this.localPart = localPart;
    }

    public static SchemaType getSchemaType(String name) {
        return (SchemaType)SchemaType.getEnum(SchemaType.class, (String)name);
    }

    public String getNamspace() {
        return this.namespace;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static SchemaType getSchemaType(QName qname) {
        Iterator iterator = SchemaType.iterator();
        while (iterator.hasNext()) {
            SchemaType type = (SchemaType)iterator.next();
            if (!type.getNamspace().equalsIgnoreCase(qname.getNamespaceURI()) || !type.getLocalPart().equalsIgnoreCase(qname.getLocalPart())) continue;
            return type;
        }
        throw new UnsupportedOperationException();
    }

    public BasicType toBasicType() {
        if (STRING.getName().equals(this.getName())) {
            return BasicType.STRING;
        }
        if (INT.getName().equals(this.getName())) {
            return BasicType.INTEGER;
        }
        throw new UnsupportedOperationException();
    }

    public static Map getEnumMap() {
        return SchemaType.getEnumMap(SchemaType.class);
    }

    public static List getEnumList() {
        return SchemaType.getEnumList(SchemaType.class);
    }

    public static Iterator iterator() {
        return SchemaType.iterator(SchemaType.class);
    }

    @Override
    public Element toElement() {
        Element elementDataType = new Element("DataType", DefinitionConstants.NS_INSTANCE_KPDL);
        Element elementSchemaType = new Element("SchemaType", DefinitionConstants.NS_INSTANCE_KPDL);
        elementSchemaType.setAttribute("Type", this.prefix + ":" + this.localPart);
        elementDataType.addContent((Content)elementSchemaType);
        return elementDataType;
    }
}

