/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.ToolType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom2.Element;

public class ScriptActivityDef
extends ToolActivityDef {
    private static final long serialVersionUID = 8676971850672373774L;

    @Override
    public String getIconResource(String state) {
        if (state.equals("closed.completed")) {
            return "imgWf_script_complete";
        }
        if (state.equals("closed.terminated")) {
            return "imgWf_script_terminate";
        }
        if (state.equals("closed.aborted")) {
            return "imgWf_script_abort";
        }
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            return "imgWf_script_suspend";
        }
        return this.getIconResource();
    }

    @Override
    public String getIconResource() {
        return "imgWf_script";
    }

    public ScriptActivityDef(ProcessDef container) {
        super(container);
        try {
            this.setName("ScriptActivity");
        }
        catch (WfException e) {
            log.error((Object)e.getMessage());
        }
    }

    public ScriptActivityDef(ProcessDef container, Element destToolActivityDefElement) throws WfKpdlParseException {
        super(container, destToolActivityDefElement);
    }

    @Override
    public void setRedoApplication(ApplicationDef destRedoApplication) throws WfException {
        if (!ApplicationType.SCRIPT.equals((Object)destRedoApplication.getType())) {
            throw new WfException("ApplicationType not script");
        }
        super.setRedoApplication(destRedoApplication);
    }

    @Override
    public void setRelatedApplication(ApplicationDef destRelatedApplication) throws WfException {
        if (!ApplicationType.SCRIPT.equals((Object)destRelatedApplication.getType())) {
            throw new WfException("ApplicationType not script");
        }
        super.setRelatedApplication(destRelatedApplication);
    }

    @Override
    protected void setToolType(ToolType type) {
        this.toolType = ToolType.APPLICATION;
    }

    @Override
    public Element toElement() {
        Element ecElement = super.toElement();
        if (ecElement != null) {
            ecElement.setName("ScriptTool");
        }
        return ecElement;
    }

    public ScriptActivityDef deepClone(ScriptActivityDef info) {
        info = (ScriptActivityDef)super.deepClone(info);
        ScriptActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (ScriptActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

