/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.ScriptType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class ScriptDef
extends AbstractKpdlElement {
    private static final long serialVersionUID = -3429251043281310565L;
    private static final String BOSTYPE = "WFSPTDEF";
    private String id;
    private ScriptType type;
    private String version;
    private String grammar;
    private String scriptContent;
    private static final String NAME = KpdlResourceUtils.SCRIPT_NAME.getName();

    public ScriptDef(AbstractKpdlElement container) {
        block4: {
            this.id = Uuid.create().toString() + BOSTYPE;
            this.type = ScriptType.JAVASCRIPT;
            this.version = "";
            this.grammar = "";
            this.scriptContent = "";
            this.setContainer(container);
            if (this.container != null) {
                try {
                    if (this.getNameResource() == null) {
                        this.setName(new Resource(NAME, this.id, "Script"));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"ScriptDef.new() error", (Throwable)((Object)e));
                }
            }
        }
    }

    public ScriptDef() {
        this.id = Uuid.create().toString() + BOSTYPE;
        this.type = ScriptType.JAVASCRIPT;
        this.version = "";
        this.grammar = "";
        this.scriptContent = "";
    }

    public ScriptDef(AbstractKpdlElement container, Element destScriptElement) throws WfKpdlParseException {
        this(container);
        this.parse(destScriptElement);
    }

    public ScriptDef(Element destScriptElement) throws WfKpdlParseException {
        this();
        this.parse(destScriptElement);
    }

    public int check() {
        return 0;
    }

    @Override
    public Element toElement() {
        Element postScriptElement = new Element("Script", DefinitionConstants.NS_INSTANCE_KPDL);
        if (!StringUtils.isEmpty((String)this.scriptContent)) {
            postScriptElement.setAttribute("Id", this.id);
            postScriptElement.setAttribute("Type", this.type != null ? this.type.getName() : "");
            postScriptElement.setAttribute("Version", this.version != null ? this.version : "");
            postScriptElement.setAttribute("Grammar", this.grammar != null ? this.grammar : "");
            Element content = new Element("content", DefinitionConstants.NS_INSTANCE_KPDL);
            postScriptElement.addContent((Content)content);
            content.addContent((Content)new CDATA(this.scriptContent));
            if (this.resources != null) {
                postScriptElement.addContent((Content)this.resources.toElement());
            }
        }
        return postScriptElement;
    }

    public String getGrammar() {
        return this.grammar;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public ScriptType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setGrammar(String string) {
        this.grammar = string;
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setScriptContent(String string) {
        this.scriptContent = string;
    }

    public void setType(ScriptType type) {
        this.type = type;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element destScriptElement) throws WfKpdlParseException {
        Element contentElement;
        if (destScriptElement == null) {
            throw new IllegalArgumentException();
        }
        this.id = XmlUtil.readStringAttr(destScriptElement, "Id");
        this.type = ScriptType.getEnum(destScriptElement.getAttributeValue("Type"));
        this.version = XmlUtil.readStringAttr(destScriptElement, "Version");
        this.grammar = XmlUtil.readStringAttr(destScriptElement, "Grammar");
        Element resourcesElement = destScriptElement.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL);
        if (resourcesElement != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        this.scriptContent = (contentElement = destScriptElement.getChild("content", DefinitionConstants.NS_INSTANCE_KPDL)) != null ? XmlUtil.readText(contentElement) : XmlUtil.readText(destScriptElement);
        return this;
    }

    public String getName() {
        return this.getName(this.container.getLocale());
    }

    public Resource getNameResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get(NAME + this.id);
    }

    public String getName(Locale locale) {
        if (this.getNameResource() == null) {
            return null;
        }
        return this.getNameResource().getValue(locale);
    }

    public void setName(String destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setName(this.container.getLocale(), destName);
    }

    public void setName(Locale locale, String destName) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destName == null) {
            throw new IllegalArgumentException();
        }
        if (this.getNameResource() == null) {
            this.setName(new Resource(NAME, this.id, locale, destName));
        } else {
            this.getNameResource().setValue(locale, destName);
        }
    }

    public void setName(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set(NAME + this.id, destName);
    }

    public String toString() {
        String name;
        String rtn = "";
        if (this.scriptContent != null) {
            rtn = rtn + this.scriptContent.trim();
        }
        if (!StringUtils.isEmpty((String)(name = this.getName()))) {
            rtn = name + "[" + rtn + "]";
        }
        return rtn;
    }
}

