/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.BasicType;
import com.kingdee.bos.workflow.define.DataType;
import com.kingdee.bos.workflow.define.ExternalType;
import com.kingdee.bos.workflow.define.FunctionScriptType;
import com.kingdee.bos.workflow.define.ScriptFunction;
import com.kingdee.bos.workflow.define.ScriptFunctionParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ScriptFunctionUtil {
    public static Element function2XML(ScriptFunction function) {
        Element el = new Element("function");
        el.setAttribute("name", function.getName());
        ScriptFunctionUtil.newChild(el, "script", function.getScript(), true);
        ScriptFunctionUtil.newChild(el, "description", function.getDescription(), true);
        ScriptFunctionUtil.newChild(el, "type", function.getScriptType().toString(), false);
        ScriptFunctionUtil.newChild(el, "editable", String.valueOf(function.isEditable()), false);
        if (function.getReturnType() != null) {
            Element returnEl = new Element("return");
            ScriptFunctionUtil.newChild(returnEl, "type", function.getReturnType().toString(), false);
            ScriptFunctionUtil.newChild(returnEl, "array", String.valueOf(function.isArray()), false);
            ScriptFunctionUtil.newChild(returnEl, "description", function.getReturnDesc(), true);
            el.addContent((Content)returnEl);
        }
        for (int i = 0; i < function.getParamSize(); ++i) {
            ScriptFunctionParameter param = function.getParam(i);
            Element paramEl = new Element("parameter");
            ScriptFunctionUtil.newChild(paramEl, "name", param.getName(), false);
            ScriptFunctionUtil.newChild(paramEl, "type", param.getType().toString(), false);
            ScriptFunctionUtil.newChild(paramEl, "array", String.valueOf(param.isArray()), false);
            ScriptFunctionUtil.newChild(paramEl, "description", param.getDescription(), true);
            el.addContent((Content)paramEl);
        }
        return el;
    }

    private static void newChild(Element parent, String name, String content, boolean isCdata) {
        Element el = new Element(name);
        if (isCdata) {
            el.addContent((Content)new CDATA(content));
        } else {
            el.addContent(content);
        }
        parent.addContent((Content)el);
    }

    public static ScriptFunction xml2Function(Element function) {
        List params;
        String editable;
        ScriptFunction sf = new ScriptFunction();
        sf.setName(function.getAttributeValue("name"));
        String desc = function.getChildText("description");
        sf.setDescription(desc == null ? "" : desc);
        String script = function.getChildText("script");
        sf.setScript(script == null ? "" : script.trim());
        FunctionScriptType sType = FunctionScriptType.getType(function.getChildText("type"));
        if (sType != null) {
            sf.setScriptType(sType);
        }
        if ((editable = function.getChildText("editable")) == null || !editable.equalsIgnoreCase("false")) {
            sf.setEditable(true);
        } else {
            sf.setEditable(false);
        }
        Element returnEl = function.getChild("return");
        if (returnEl != null) {
            String type = returnEl.getChildText("type");
            sf.setReturnType(ScriptFunctionUtil.parseType(type));
            sf.setReturnDesc(returnEl.getChildText("description"));
            sf.setArray(Boolean.valueOf(returnEl.getChildText("array")));
        }
        if ((params = function.getChildren("parameter")) != null) {
            for (int j = 0; j < params.size(); ++j) {
                Element param = (Element)params.get(j);
                ScriptFunctionParameter sfParam = new ScriptFunctionParameter();
                sfParam.setName(param.getChildText("name"));
                sfParam.setDescription(param.getChildText("description"));
                sfParam.setType(ScriptFunctionUtil.parseType(param.getChildText("type")));
                sfParam.setArray(Boolean.valueOf(param.getChildText("array")));
                sf.getParameters().add(sfParam);
            }
        }
        return sf;
    }

    public static ScriptFunction parse(String content) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document doc = builder.build((InputStream)bais);
        Element rootEl = doc.getRootElement();
        List functions = rootEl.getChildren("function");
        Element function = (Element)functions.get(0);
        ScriptFunction sf = ScriptFunctionUtil.xml2Function(function);
        return sf;
    }

    private static DataType parseType(String type) {
        DataType dataType = null;
        try {
            dataType = BasicType.parse(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataType == null) {
            try {
                dataType = ExternalType.parse(type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dataType;
    }
}

