/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ApplicationType;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.ToolType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom2.Element;

public class ServiceActivityDef
extends ToolActivityDef {
    private static final long serialVersionUID = 634421145084977173L;
    public static final String ELEMENT_NAME = "Service";
    private String serviceUri = null;

    public ServiceActivityDef(ProcessDef container) {
        super(container);
        try {
            this.setName("ServiceActivity");
        }
        catch (WfException e) {
            log.error((Object)e.getMessage());
        }
    }

    public ServiceActivityDef(ProcessDef container, Element destToolActivityDefElement) throws WfKpdlParseException {
        super(container, destToolActivityDefElement);
        this.serviceUri = destToolActivityDefElement.getAttributeValue("uri");
    }

    @Override
    public void setRedoApplication(ApplicationDef destRedoApplication) throws WfException {
        if (!ApplicationType.SERVICE.equals((Object)destRedoApplication.getType())) {
            throw new WfException("ApplicationType isn't SERVICE");
        }
        super.setRedoApplication(destRedoApplication);
    }

    @Override
    public void setRelatedApplication(ApplicationDef destRelatedApplication) throws WfException {
        if (!ApplicationType.SERVICE.equals((Object)destRelatedApplication.getType())) {
            throw new WfException("ApplicationType isn't SERVICE");
        }
        super.setRelatedApplication(destRelatedApplication);
    }

    @Override
    protected void setToolType(ToolType type) {
        this.toolType = ToolType.APPLICATION;
    }

    @Override
    public Element toElement() {
        Element ecElement = super.toElement();
        if (ecElement != null) {
            ecElement.setName(ELEMENT_NAME);
            if (this.serviceUri != null) {
                ecElement.setAttribute("uri", this.serviceUri);
            }
        }
        return ecElement;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
    }

    @Override
    public IKpdlElement innerParse(Element destToolActivityDefElement) throws WfKpdlParseException {
        this.serviceUri = destToolActivityDefElement.getAttributeValue("uri");
        return super.innerParse(destToolActivityDefElement);
    }

    public ServiceActivityDef deepClone(ServiceActivityDef info) {
        info = (ServiceActivityDef)super.deepClone(info);
        ServiceActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (ServiceActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

