/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.AbstractKpdlElementCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.TagDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class TagCollection
extends AbstractKpdlElementCollection {
    public TagCollection(AbstractKpdlElement containerElement) {
        this.container = containerElement;
    }

    public TagCollection(AbstractKpdlElement containerElement, Element destEventPoliciesElement) throws WfKpdlParseException {
        this(containerElement);
        this.parse(destEventPoliciesElement);
        this.trimToSize();
    }

    public boolean add(TagDef tag) throws WfException {
        return this.add(tag.getID(), tag);
    }

    public boolean add(String key, TagDef tag) throws WfException {
        return this.addObject(key, (Object)tag);
    }

    @Override
    public Object remove(String key) throws WfException {
        return this.removeObjectByKey(key);
    }

    public Object remove(TagDef tag) throws WfException {
        return this.remove(tag.getID());
    }

    public TagDef get(String key) {
        return (TagDef)this.getObject(key);
    }

    public TagDef get(int i) {
        return (TagDef)this.getObject(i);
    }

    public TagDef set(String key, TagDef tag) throws WfException {
        return (TagDef)this.setObject(key, (Object)tag);
    }

    @Override
    public Element toElement() {
        Element eventPoliciesElement = new Element("Tags", DefinitionConstants.NS_INSTANCE_KPDL);
        if (this.size() > 0) {
            TagDef tag = null;
            Iterator tagsIteratorSort = this.iterator();
            while (tagsIteratorSort.hasNext()) {
                tag = (TagDef)tagsIteratorSort.next();
                eventPoliciesElement.addContent((Content)tag.toElement());
            }
        }
        return eventPoliciesElement;
    }

    @Override
    public IKpdlElement parse(Element destTagsElement) throws WfKpdlParseException {
        if (destTagsElement == null) {
            throw new WfKpdlParseException("miss element Activities");
        }
        Element tempElement = null;
        TagDef tag = null;
        List tempElementList = destTagsElement.getChildren();
        try {
            for (int i = 0; i < tempElementList.size(); ++i) {
                tempElement = (Element)tempElementList.get(i);
                tag = new TagDef(this.container, tempElement);
                this.add(tag.getID(), tag);
            }
        }
        catch (WfException error) {
            throw new WfKpdlParseException(error.getMessage());
        }
        return this;
    }
}

