/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.EventType;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.IntermediateEventActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class TimerIntermediateEventActivityDef
extends IntermediateEventActivityDef {
    private static final long serialVersionUID = 272937122777065241L;
    protected String timeMode = "";
    protected String time = "";
    protected String description = "";
    private boolean isScript = false;
    private String scriptContent = "";
    private String referTimeObj = "";
    private String referTimeCalendar = "";
    private String orgId = "";
    private String orgName = "";
    private String endCondition = "";

    public TimerIntermediateEventActivityDef(ProcessDef process) {
        super(process);
    }

    public TimerIntermediateEventActivityDef(ProcessDef container, Element destEventActivityDefElement) throws WfKpdlParseException {
        super(container, destEventActivityDefElement);
        this.parseTimerValue(destEventActivityDefElement);
    }

    @Override
    protected void setActivityFeature() {
        this.actDefName = "TimerIntermediateEvent";
        this.eventType = EventType.EVENT_INTERMEDIATE_TIMER;
    }

    @Override
    public IKpdlElement innerParse(Element destEventActivityDefElement) throws WfKpdlParseException {
        super.innerParse(destEventActivityDefElement);
        this.parseTimerValue(destEventActivityDefElement);
        return this;
    }

    private void parseTimerValue(Element destEventActivityDefElement) {
        Element timerElement = destEventActivityDefElement.getChild("Timer", DefinitionConstants.NS_INSTANCE_KPDL);
        if (timerElement != null) {
            this.timeMode = XmlUtil.readStringAttr(timerElement, "timeMode");
            this.time = XmlUtil.readStringAttr(timerElement, "time");
            this.description = XmlUtil.readStringAttr(timerElement, "description") == null ? "" : XmlUtil.readStringAttr(timerElement, "description");
            this.isScript = Boolean.valueOf(XmlUtil.readStringAttr(timerElement, "isScript"));
            this.scriptContent = XmlUtil.readStringAttr(timerElement, "scriptContent");
            this.referTimeObj = XmlUtil.readStringAttr(timerElement, "referTimeObj");
            this.referTimeCalendar = XmlUtil.readStringAttr(timerElement, "referTimeCalendar");
            this.orgId = XmlUtil.readStringAttr(timerElement, "orgId");
            this.orgName = XmlUtil.readStringAttr(timerElement, "orgName");
            this.endCondition = XmlUtil.readStringAttr(timerElement, "endCondition");
        }
    }

    @Override
    public Element toElement() {
        Element element = super.toElement();
        if (element != null) {
            Element timerElement = new Element("Timer", DefinitionConstants.NS_INSTANCE_KPDL);
            timerElement.setAttribute("timeMode", this.timeMode == null ? "" : this.timeMode);
            timerElement.setAttribute("time", this.time == null ? "" : this.time);
            timerElement.setAttribute("description", this.description == null ? "" : this.description);
            timerElement.setAttribute("isScript", this.isScript ? "true" : "false");
            timerElement.setAttribute("scriptContent", this.scriptContent == null ? "" : this.scriptContent);
            timerElement.setAttribute("referTimeObj", this.referTimeObj == null ? "" : this.referTimeObj);
            timerElement.setAttribute("referTimeCalendar", this.referTimeCalendar == null ? "" : this.referTimeCalendar);
            timerElement.setAttribute("orgId", this.orgId == null ? "" : this.orgId);
            timerElement.setAttribute("orgName", this.orgName == null ? "" : this.orgName);
            timerElement.setAttribute("endCondition", this.endCondition == null ? "" : this.endCondition);
            element.addContent((Content)timerElement);
        }
        return element;
    }

    public String getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(String timeMode) {
        this.timeMode = timeMode;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setScript(boolean isScript) {
        this.isScript = isScript;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
    }

    public String getReferTimeObj() {
        return this.referTimeObj;
    }

    public void setReferTimeObj(String referTimeObj) {
        this.referTimeObj = referTimeObj;
    }

    public String getReferTimeCalendar() {
        return this.referTimeCalendar;
    }

    public void setReferTimeCalendar(String referTimeCalendar) {
        this.referTimeCalendar = referTimeCalendar;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getEndCondition() {
        return this.endCondition;
    }

    public void setEndCondition(String endCondition) {
        this.endCondition = endCondition;
    }

    @Override
    protected String getTypeResource() {
        return "TimerIntermediateEvent";
    }

    @Override
    public String getIconResource() {
        return "imgWf_event_waittimer";
    }

    @Override
    public String getIconResource(String state) {
        if ("closed.completed".equals(state)) {
            return "imgWf_event_waittimer_complete";
        }
        if ("closed.terminated".equals(state)) {
            return "imgWf_event_waittimer_terminate";
        }
        if ("closed.aborted".equals(state)) {
            return "imgWf_event_waittimer_abort";
        }
        if ("open.not_running.suspended".equals(state) || "open.not_running.blocked".equals(state)) {
            return "imgWf_event_waittimer_suspend";
        }
        if ("open.running".equals(state) || "open.not_running".equals(state) || "open.not_running.not_started".equals(state)) {
            return "imgWf_event_waittimer_running";
        }
        return this.getIconResource();
    }
}

