/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ApplicationCollection;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.DeadlineCollection;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IApplicationActivity;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ParticipantType;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ReferenceHumanType;
import com.kingdee.bos.workflow.define.RelationType;
import com.kingdee.bos.workflow.define.ToolType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class ToolActivityDef
extends ActivityDef
implements IApplicationActivity {
    private static final long serialVersionUID = 115770366430949858L;
    protected ActualParameterCollection actualParameters;
    protected ActualParameterCollection redoActualParameters;
    protected String applicationId;
    protected String redoApplicationId;
    protected ToolType toolType;
    protected DeadlineCollection deadlines;
    protected boolean isDefaultRollback;
    protected ParticipantDef applicationUser;
    private HashMap<Integer, String> toolActualsMap;

    @Override
    public String getIconResource(String state) {
        if (state.equals("closed.completed")) {
            return "imgWf_auto_complete";
        }
        if (state.equals("closed.terminated")) {
            return "imgWf_auto_terminate";
        }
        if (state.equals("closed.aborted")) {
            return "imgWf_auto_abort";
        }
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            return "imgWf_auto_suspend";
        }
        return this.getIconResource();
    }

    @Override
    public String getIconResource() {
        return "imgWf_auto";
    }

    @Override
    protected String getTypeResource() {
        return "tool";
    }

    public ToolActivityDef(ProcessDef process) {
        block3: {
            super(process);
            this.actualParameters = new ActualParameterCollection(this);
            this.redoActualParameters = new ActualParameterCollection(this);
            this.applicationId = "";
            this.redoApplicationId = "";
            this.toolType = ToolType.APPLICATION;
            this.deadlines = new DeadlineCollection(this);
            this.isDefaultRollback = true;
            this.toolActualsMap = null;
            this.toolType = ToolType.APPLICATION;
            this.setType(ActivityType.TOOL);
            this.applicationUser = new ParticipantDef(this);
            this.applicationUser.setParticipantType(ParticipantType.RELATION);
            this.applicationUser.setReferenceHumanType(ReferenceHumanType.PROCESS_INITIATOR);
            this.applicationUser.setRelationType(RelationType.SELF);
            this.isDefaultRollback = true;
            this.toolActualsMap = new HashMap();
            if (process != null) {
                try {
                    this.setName("Tool");
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"ToolActivityDef.construct error", (Throwable)((Object)e));
                }
            }
        }
    }

    public ToolActivityDef(ProcessDef container, Element destToolActivityDefElement) throws WfKpdlParseException {
        super(container, destToolActivityDefElement);
        this.actualParameters = new ActualParameterCollection(this);
        this.redoActualParameters = new ActualParameterCollection(this);
        this.applicationId = "";
        this.redoApplicationId = "";
        this.toolType = ToolType.APPLICATION;
        this.deadlines = new DeadlineCollection(this);
        this.isDefaultRollback = true;
        this.toolActualsMap = null;
        this.toolActualsMap = new HashMap();
        this.setType(ActivityType.TOOL);
        this.parse(destToolActivityDefElement);
    }

    @Override
    public ActualParameterCollection getActualParameters() {
        return this.actualParameters;
    }

    @Override
    public ApplicationDef getRelatedApplication() {
        if (this.applicationId == null) {
            return null;
        }
        return this.container().getApplicationDef(this.applicationId);
    }

    public void setRelatedApplication(ApplicationDef destRelatedApplication) throws WfException {
        if (destRelatedApplication == null) {
            throw new IllegalArgumentException("destRelatedApplication null");
        }
        if (this.container().getApplications() == null) {
            this.container().setApplications(new ApplicationCollection(this.container()));
        }
        this.container().getApplications().set(destRelatedApplication.getID(), destRelatedApplication);
        this.applicationId = destRelatedApplication.getID();
    }

    @Override
    public ApplicationDef getRedoApplication() {
        if (this.applicationId == null || this.applicationId.length() == 0) {
            return null;
        }
        return this.container().getApplicationDef(this.redoApplicationId);
    }

    public void setRedoApplication(ApplicationDef destRedoApplication) throws WfException {
        if (destRedoApplication == null) {
            throw new IllegalArgumentException("destRedoApplication null");
        }
        if (this.container().getApplications() == null) {
            this.container().setApplications(new ApplicationCollection(this.container()));
        }
        this.container().getApplications().set(destRedoApplication.getID(), destRedoApplication);
        this.redoApplicationId = destRedoApplication.getID();
    }

    public DeadlineCollection getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(DeadlineCollection destDeadlines) {
        this.deadlines = destDeadlines;
    }

    public ToolType getToolType() {
        return this.toolType;
    }

    protected void setToolType(ToolType type) {
        this.toolType = type;
    }

    @Override
    public Element toElement() {
        Element toolElement = super.toElement();
        if (toolElement != null) {
            toolElement.setName("Tool");
            if (this.applicationId != null && this.applicationId.length() > 0) {
                toolElement.setAttribute("ApplicationId", this.applicationId);
            }
            if (this.redoApplicationId != null && this.redoApplicationId.length() > 0) {
                toolElement.setAttribute("RedoApplicationId", this.redoApplicationId);
            }
            toolElement.setAttribute("ToolType", this.toolType.getName());
            if (this.actualParameters != null && this.actualParameters.size() > 0) {
                toolElement.addContent((Content)this.actualParameters.toElement());
            } else {
                toolElement.addContent((Content)new Element("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.redoActualParameters != null && this.redoActualParameters.size() > 0) {
                Element redoElement = this.redoActualParameters.toElement();
                redoElement.setName("RedoActualParameters");
                toolElement.addContent((Content)redoElement);
            } else {
                toolElement.addContent((Content)new Element("RedoActualParameters", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.deadlines != null && this.deadlines.size() > 0) {
                toolElement.addContent((Content)this.deadlines.toElement());
            } else {
                toolElement.addContent((Content)new Element("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.applicationUser != null) {
                toolElement.addContent((Content)this.applicationUser.toElement());
            }
            toolElement.setAttribute("IsDefaultRollback", String.valueOf(this.isDefaultRollback));
            if (this.toolActualsMap != null && this.toolActualsMap.size() > 0) {
                Element elm = new Element("ToolActualsMap", DefinitionConstants.NS_INSTANCE_KPDL);
                for (Map.Entry<Integer, String> e : this.toolActualsMap.entrySet()) {
                    Element toolActual = new Element("ToolActual", DefinitionConstants.NS_INSTANCE_KPDL);
                    String ek = e.getKey().toString();
                    String ev = e.getValue().toString();
                    toolActual.setAttribute("index", ek);
                    toolActual.setAttribute("value", ev);
                    elm.addContent((Content)toolActual);
                }
                toolElement.addContent((Content)elm);
            }
        }
        return toolElement;
    }

    @Override
    public IKpdlElement innerParse(Element destToolActivityDefElement) throws WfKpdlParseException {
        Element elm;
        String isDefaultRollbackStr;
        Element applicationuserElement;
        Element deadlineElementList;
        Element redoActualParametersElement;
        super.innerParse(destToolActivityDefElement);
        Element actualParametersElement = destToolActivityDefElement.getChild("ActualParameters", DefinitionConstants.NS_INSTANCE_KPDL);
        if (actualParametersElement != null) {
            this.actualParameters = new ActualParameterCollection(this, actualParametersElement);
        }
        if ((redoActualParametersElement = destToolActivityDefElement.getChild("RedoActualParameters", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.redoActualParameters = new ActualParameterCollection(this, redoActualParametersElement);
        }
        if ((deadlineElementList = destToolActivityDefElement.getChild("Deadlines", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.deadlines = new DeadlineCollection(this, deadlineElementList);
        }
        this.applicationId = XmlUtil.readStringAttr(destToolActivityDefElement, "ApplicationId");
        this.redoApplicationId = XmlUtil.readStringAttr(destToolActivityDefElement, "RedoApplicationId");
        this.toolType = ToolType.getEnum(destToolActivityDefElement.getAttributeValue("ToolType"));
        if (this.toolType == null) {
            this.toolType = ToolType.APPLICATION;
        }
        if ((applicationuserElement = destToolActivityDefElement.getChild("Participant", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.applicationUser = new ParticipantDef(this, applicationuserElement);
        }
        if (!StringUtils.isEmpty((String)(isDefaultRollbackStr = destToolActivityDefElement.getAttributeValue("IsDefaultRollback")))) {
            this.isDefaultRollback = Boolean.valueOf(isDefaultRollbackStr);
        }
        if ((elm = destToolActivityDefElement.getChild("ToolActualsMap", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            if (this.toolActualsMap == null) {
                this.toolActualsMap = new HashMap();
            }
            List ToolActuals = elm.getChildren("ToolActual", DefinitionConstants.NS_INSTANCE_KPDL);
            for (int i = 0; i < ToolActuals.size(); ++i) {
                Element toolActual = (Element)ToolActuals.get(i);
                int k = Integer.parseInt(toolActual.getAttributeValue("index"));
                String v = toolActual.getAttributeValue("value");
                this.toolActualsMap.put(k, v);
            }
        }
        return this;
    }

    public HashMap<Integer, String> getToolActualsMap() {
        return this.toolActualsMap;
    }

    public void setToolActualsMap(HashMap<Integer, String> toolActualsMap) {
        this.toolActualsMap = toolActualsMap;
    }

    public void setActualParameters(ActualParameterCollection collection) {
        this.actualParameters = collection;
    }

    public ActualParameterCollection getRedoActualParameters() {
        return this.redoActualParameters;
    }

    public ParticipantDef getApplicationUser() {
        return this.applicationUser;
    }

    public void setApplicationUser(ParticipantDef def) {
        this.applicationUser = def;
    }

    public boolean isDefaultRollback() {
        return this.isDefaultRollback;
    }

    public void setDefaultRollback(boolean isDefaultRollback) {
        this.isDefaultRollback = isDefaultRollback;
    }

    public ActivityDef getActivityDef() {
        return this;
    }

    public ToolActivityDef deepClone(ToolActivityDef info) {
        info = (ToolActivityDef)super.deepClone(info);
        ToolActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (ToolActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

