/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.diagram;

import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.TransitionDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class Line
implements Serializable {
    private String id;
    private TransitionDef refTransition;
    private String path;
    private String fromPort;
    private String toPort;
    private Diagram container;
    private ExtendedAttributeCollection extendedAttributes;
    protected static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.define.diagram.Line");

    public Line(Diagram diagram) {
        this.container = diagram;
        this.id = Uuid.create().toString() + "WFLINDEF";
        this.path = "";
        this.fromPort = "";
        if (diagram != null) {
            diagram.addLine(this);
            if (diagram.getProcess() != null) {
                this.setRefTransition(new TransitionDef(diagram.getProcess()));
            }
        } else {
            this.refTransition = new TransitionDef(null);
        }
    }

    public Line(Diagram diagram, Element destElement) throws WfKpdlParseException {
        this.container = diagram;
        this.id = Uuid.create().toString() + "WFLINDEF";
        this.path = "";
        this.fromPort = "";
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.parse(destElement);
    }

    public void parse(Element destElement) throws WfKpdlParseException {
        Element extendedAttrListElem;
        this.id = destElement.getAttributeValue("Id");
        String refTransitionId = destElement.getAttributeValue("RefTransitionId");
        if (refTransitionId != null && this.container != null && this.container.getProcess() != null) {
            this.refTransition = this.container.getProcess().getTransitionDef(refTransitionId);
        }
        this.path = XmlUtil.readString(destElement, "Path", DefinitionConstants.NS_INSTANCE_KPDL);
        Element tempPortElement = destElement.getChild("Port", DefinitionConstants.NS_INSTANCE_KPDL);
        if (tempPortElement != null) {
            this.fromPort = tempPortElement.getAttributeValue("From");
            this.toPort = tempPortElement.getAttributeValue("To");
        }
        if ((extendedAttrListElem = destElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttrListElem);
        }
    }

    public Element toElement() {
        Element lineElement = new Element("Line", DefinitionConstants.NS_INSTANCE_KPDL);
        lineElement.setAttribute("Id", this.id);
        lineElement.setAttribute("RefTransitionId", this.refTransition != null ? this.refTransition.getID() : "");
        Element pathElement = new Element("Path", DefinitionConstants.NS_INSTANCE_KPDL);
        pathElement.setText(this.path);
        lineElement.addContent((Content)pathElement);
        if (this.fromPort != null || this.toPort != null) {
            Element portElement = new Element("Port", DefinitionConstants.NS_INSTANCE_KPDL);
            portElement.setAttribute("From", this.fromPort == null ? "" : this.fromPort);
            portElement.setAttribute("To", this.toPort == null ? "" : this.toPort);
            lineElement.addContent((Content)portElement);
        }
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            lineElement.addContent((Content)this.extendedAttributes.toElement());
        } else {
            lineElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        return lineElement;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public String getPath() {
        return this.path;
    }

    public String getFromPort() {
        return this.fromPort;
    }

    public TransitionDef getRefTransition() {
        return this.refTransition;
    }

    public void setExtendedAttributes(ExtendedAttributeCollection collection) {
        this.extendedAttributes = collection;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setFromPort(String string) {
        this.fromPort = string;
    }

    public void setRefTransition(TransitionDef def, boolean isUpdate) {
        if (this.container != null && this.container.getProcess() != null) {
            if (isUpdate && this.refTransition != null && this.container.getProcess().getTransitions().get(this.refTransition.getID()) != null) {
                this.container.getProcess().getTransitions().remove(this.refTransition.getID());
            }
            this.container.getProcess().getTransitions().set(def.getID(), def);
        }
        this.refTransition = def;
    }

    public void setRefTransition(TransitionDef def) {
        this.setRefTransition(def, false);
    }

    public String getToPort() {
        return this.toPort;
    }

    public void setToPort(String string) {
        this.toPort = string;
    }

    public Diagram getContainer() {
        return this.container;
    }

    public void setContainer(Diagram diagram) {
        this.container = diagram;
        if (this.container != null) {
            this.container.getLines().set(this.id, this);
            if (this.refTransition != null && this.container.getProcess() != null && this.container.getProcess().getTransitions() != null) {
                this.container.getProcess().getTransitions().set(this.refTransition.getID(), this.refTransition);
            }
        }
    }
}

