/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.diagram;

import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Coordinate;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.define.diagram.NodeMode;
import com.kingdee.bos.workflow.define.diagram.NodeType;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -8321066832492293118L;
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.define.diagram.Node");
    protected String id;
    protected NodeType type;
    protected NodeMode mode;
    protected Coordinate coordinate;
    protected String icon;
    protected Diagram container;
    protected ExtendedAttributeCollection extendedAttributes;

    public Node(Diagram diagram) {
        this.container = diagram;
        this.id = Uuid.create().toString() + "WFNODDEF";
        this.type = NodeType.NOTE;
        this.mode = NodeMode.DIAGRAMNODE;
        this.coordinate = new Coordinate(0, 0);
        if (diagram != null) {
            diagram.addNode(this);
        }
    }

    public Node(Diagram diagram, Element destElement) throws WfKpdlParseException {
        this(diagram);
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.parse(destElement);
    }

    public void parse(Element destElement) throws WfKpdlParseException {
        this.id = destElement.getAttributeValue("Id");
        this.type = NodeType.getEnum(destElement.getAttributeValue("Type"));
        Element destCoordinateElement = destElement.getChild("Coordinate", DefinitionConstants.NS_INSTANCE_KPDL);
        if (destCoordinateElement != null) {
            this.coordinate = new Coordinate(destCoordinateElement);
        }
        this.icon = XmlUtil.readString(destElement, "Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        Element extendedAttrListElem = destElement.getChild("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL);
        if (extendedAttrListElem != null) {
            this.extendedAttributes = new ExtendedAttributeCollection(extendedAttrListElem);
        }
    }

    public Element toElement() {
        Element nodeElement = new Element("Node", DefinitionConstants.NS_INSTANCE_KPDL);
        nodeElement.setAttribute("Id", this.id);
        nodeElement.setAttribute("Type", this.type.getName());
        Element coordinateElement = this.coordinate.toElement();
        if (coordinateElement != null) {
            nodeElement.addContent((Content)coordinateElement);
        }
        Element iconElement = new Element("Icon", DefinitionConstants.NS_INSTANCE_KPDL);
        iconElement.setText(this.icon);
        nodeElement.addContent((Content)iconElement);
        if (this.extendedAttributes != null && this.extendedAttributes.size() > 0) {
            nodeElement.addContent((Content)this.extendedAttributes.toElement());
        } else {
            nodeElement.addContent((Content)new Element("ExtendedAttributes", DefinitionConstants.NS_INSTANCE_KPDL));
        }
        return nodeElement;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public String getIcon() {
        return this.icon;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setCoordinate(Coordinate destCoordinate) {
        this.coordinate = destCoordinate;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public ExtendedAttributeCollection getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(ExtendedAttributeCollection collection) {
        this.extendedAttributes = collection;
    }

    public NodeMode getMode() {
        return this.mode;
    }

    public void setMode(NodeMode mode) {
        this.mode = mode;
    }
}

