/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.diagram;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.KpdlResourceUtils;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.diagram.Diagram;
import com.kingdee.bos.workflow.define.diagram.Node;
import com.kingdee.bos.workflow.define.diagram.NodeType;
import java.util.Locale;
import org.jdom2.Element;

public class Note
extends Node {
    private static final long serialVersionUID = -1994350941345751259L;
    private final String content;
    private String name;

    public Note(Diagram diagram) {
        block4: {
            super(diagram);
            this.content = KpdlResourceUtils.NOTE_CONTENT.getName();
            this.name = "Note";
            this.type = NodeType.NOTE;
            if (this.container.getProcess() != null) {
                try {
                    if (this.getContentResource() == null) {
                        this.setContent(new Resource(this.content, this.id));
                    }
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Note.construct error", (Throwable)((Object)e));
                }
            }
        }
    }

    public Note(Diagram diagram, Element destElement) throws WfKpdlParseException {
        super(diagram, destElement);
        this.content = KpdlResourceUtils.NOTE_CONTENT.getName();
    }

    @Override
    public void parse(Element destElement) throws WfKpdlParseException {
        super.parse(destElement);
        this.name = destElement.getAttributeValue("name");
    }

    @Override
    public Element toElement() {
        Element routerElement = super.toElement();
        routerElement.setName("Note");
        routerElement.setAttribute("Content", this.content);
        return routerElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getContent() {
        return this.getContent(this.container.getProcess().getLocale());
    }

    public Resource getContentResource() {
        return this.container.getProcess().getResources().get(this.content + this.id);
    }

    public String getContent(Locale locale) {
        if (this.getContentResource() == null) {
            return null;
        }
        return this.getContentResource().getValue(locale);
    }

    public void setContent(String destContent) throws WfException {
        if (this.container.getProcess().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.setContent(this.container.getProcess().getLocale(), destContent);
    }

    public void setContent(Locale locale, String destContent) throws WfException {
        if (this.container == null) {
            throw new WfException("container null!");
        }
        if (this.container.getProcess().isReadOnly()) {
            throw new WfException("Read only");
        }
        if (destContent == null) {
            throw new IllegalArgumentException();
        }
        if (this.getContentResource() == null) {
            this.setContent(new Resource(this.content, this.id, locale, destContent));
        } else {
            this.getContentResource().setValue(locale, destContent);
        }
    }

    public void setContent(Resource destContent) throws WfException {
        if (this.container.getProcess().isReadOnly()) {
            throw new WfException("Read only");
        }
        this.container.getProcess().getResources().set(this.content + this.id, destContent);
    }
}

