/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.enhanced;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AbstractKpdlElement;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.define.ResourceCollection;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.util.XmlUtil;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class Abstracts
extends AbstractKpdlElement {
    private static final long serialVersionUID = 7778404685513285986L;
    public static final int APPEND = 0;
    public static final int OVER = 1;
    public static final String ELEMENT_NAME = "abstracts";
    private String id;
    private String content;
    private int type;
    private static final String BOSTYPE = "WFABSDEF";

    @Override
    public String getID() {
        return null;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String bosType() {
        return BOSTYPE;
    }

    @Override
    protected IKpdlElement innerParse(Element element) throws WfKpdlParseException {
        Element resourcesElement;
        if (element.getAttributes() != null && element.getAttributes().size() > 0) {
            this.id = XmlUtil.readStringAttr(element, "id");
            String typeValue = XmlUtil.readStringAttr(element, "type");
            try {
                this.type = Integer.parseInt(typeValue);
            }
            catch (Exception ex) {
                this.type = 0;
            }
            this.content = XmlUtil.readStringAttr(element, "content");
        }
        if ((resourcesElement = element.getChild("Resources", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
            this.resources = new ResourceCollection(this, resourcesElement);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element element = new Element(ELEMENT_NAME, DefinitionConstants.NS_INSTANCE_KPDL);
        element.setAttribute("id", String.valueOf(this.id));
        element.setAttribute("type", String.valueOf(this.type));
        if (this.content != null) {
            element.setAttribute("content", String.valueOf(this.content));
        }
        if (this.resources != null) {
            element.addContent((Content)this.resources.toElement());
        }
        return element;
    }

    public Abstracts(AbstractKpdlElement container) {
        block3: {
            this.type = 0;
            this.container = container;
            this.setID(Uuid.create().toString() + BOSTYPE);
            if (this.container != null && this.content != null) {
                try {
                    this.setContent(new Resource(this.content, this.id, ""));
                }
                catch (WfException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"ActivityMessage.construct setTitle error", (Throwable)((Object)e));
                }
            }
        }
    }

    public void setContent(Resource destName) throws WfException {
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        this.resources.set("CONTENT" + this.id, destName);
    }

    public String getContent(Locale locale) {
        if (this.getContentResource() == null) {
            return null;
        }
        return this.getContentResource().getValue(locale);
    }

    public Resource getContentResource() {
        if (this.container == null) {
            return null;
        }
        return this.resources.get("CONTENT" + this.id);
    }

    public void setContent(Locale locale, String string) throws WfException {
        if (this.container == null) {
            throw new WfException("Container is null");
        }
        if (this.container.isReadOnly()) {
            throw new WfException("Read only");
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.content = string;
        if (this.getContentResource() == null) {
            this.setContent(new Resource("CONTENT", this.id, locale, string));
        } else {
            this.getContentResource().setValue(locale, string);
        }
    }
}

