/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.define.extended;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.DefinitionConstants;
import com.kingdee.bos.workflow.define.IKpdlElement;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.define.ToolType;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

public class MessageActivityDef
extends ToolActivityDef
implements IEMessageActivity,
IMessageActivity {
    private static final long serialVersionUID = -350885720335608526L;
    private AssignmentMessage message;
    private ParticipantCollection receivers;
    private String billIdKey = null;
    private EMessage emessage;

    @Override
    public String getIconResource(String state) {
        if (state.equals("closed.completed")) {
            return "imgWf_message_complete";
        }
        if (state.equals("closed.terminated")) {
            return "imgWf_message_terminate";
        }
        if (state.equals("closed.aborted")) {
            return "imgWf_message_abort";
        }
        if (state.equals("open.not_running.suspended") || state.equals("open.not_running.blocked")) {
            return "imgWf_message_suspend";
        }
        return this.getIconResource();
    }

    @Override
    public String getIconResource() {
        return "imgWf_message";
    }

    public MessageActivityDef(ProcessDef process) {
        super(process);
        this.toolType = ToolType.EXTENDED;
        try {
            this.setName("Message");
        }
        catch (WfException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.activityHeader.setRollback(true);
        this.receivers = new ParticipantCollection();
    }

    public MessageActivityDef(ProcessDef container, Element destMessageActivityDefElement) throws WfKpdlParseException {
        super(container, destMessageActivityDefElement);
        this.parse(destMessageActivityDefElement);
    }

    @Override
    public IKpdlElement innerParse(Element element) throws WfKpdlParseException {
        super.innerParse(element);
        if (element != null) {
            Element emElement;
            Element participantsElement;
            Element messageElement = element.getChild("AssignmentMessage", DefinitionConstants.NS_INSTANCE_KPDL);
            if (messageElement != null) {
                this.message = new AssignmentMessage(this.container, messageElement);
            }
            if ((participantsElement = element.getChild("Participants", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
                try {
                    this.receivers = new ParticipantCollection(this, participantsElement);
                }
                catch (WfKpdlParseException e) {
                    log.error((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
            if ((emElement = element.getChild("emessage", DefinitionConstants.NS_INSTANCE_KPDL)) != null) {
                this.emessage = new EMessage(this);
                this.emessage.parse(emElement);
            }
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element messageElement = super.toElement();
        if (messageElement != null) {
            messageElement.setName("MessageActivity");
            messageElement.setAttribute("Id", this.id);
            if (this.message != null) {
                messageElement.addContent((Content)this.message.toElement());
            } else {
                messageElement.addContent((Content)new Element("AssignmentMessage", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.receivers != null) {
                messageElement.addContent((Content)this.receivers.toElement());
            } else {
                messageElement.addContent((Content)new Element("Participants", DefinitionConstants.NS_INSTANCE_KPDL));
            }
            if (this.emessage != null) {
                messageElement.addContent((Content)this.emessage.toElement());
            }
        }
        return messageElement;
    }

    @Override
    public AssignmentMessage getMessage() {
        return this.message;
    }

    public ParticipantCollection getReceivers() {
        return this.receivers;
    }

    @Override
    public void setMessage(AssignmentMessage message) {
        this.message = message;
    }

    public void setReceivers(ParticipantCollection collection) {
        this.receivers = collection;
    }

    public void addReceiver(ParticipantDef participant) {
        if (participant != null) {
            if (this.receivers == null) {
                this.receivers = new ParticipantCollection();
            }
            this.receivers.add(participant.getID(), participant);
        }
    }

    @Override
    public void setEMessage(EMessage msg) {
        this.emessage = msg;
    }

    @Override
    public EMessage getEMessage() {
        return this.emessage;
    }

    public String getBillIdKey() {
        return this.billIdKey;
    }

    public void setBillIdKey(String billIdKey) {
        this.billIdKey = billIdKey;
    }

    public MessageActivityDef deepClone(MessageActivityDef info) {
        info = (MessageActivityDef)super.deepClone(info);
        MessageActivityDef dc = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(info);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream bis = new ObjectInputStream(bais);
            dc = (MessageActivityDef)bis.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dc;
    }
}

