/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui;

import com.kingdee.bos.util.md5;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.bos.workflow.dynui.approve.ApproveUIDef;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;

public class DynUIParser {
    protected static final Logger log = Logger.getLogger(DynUIParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApproveUIDef parseDynUIDocFromPath(String path) throws WfDynUIParseException {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException();
        }
        String dynuiStr = "";
        File file = null;
        FileInputStream fileStream = null;
        try {
            file = new File(path);
            byte[] buffer = new byte[(int)file.length()];
            fileStream = new FileInputStream(file);
            fileStream.read(buffer);
            dynuiStr = new String(buffer, "UTF-8");
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"DynUIParser.parseDynUIDocFromPath error", (Throwable)e);
            }
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException e1) {
                log.error((Object)e1);
            }
        }
        return DynUIParser.parser(dynuiStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApproveUIDef parser(String text) throws WfDynUIParseException {
        ByteArrayInputStream inputStream;
        if (StringUtils.isEmpty((String)text)) {
            text = new ApproveUIDef().toXml();
        }
        md5 md = new md5(text);
        md.processString();
        String hashValue = md.getStringDigest();
        try {
            inputStream = new ByteArrayInputStream(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new WfDynUIParseException("UnsupportedEncodingException", ex);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ApproveUIDef approveUIDef = null;
        try {
            Document doc;
            Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            try {
                doc = inputStream.available() == 0 ? null : builder.build((InputStream)inputStream);
            }
            catch (JDOMException ex) {
                throw new WfDynUIParseException("JDOMException", ex);
            }
            catch (IOException ex) {
                throw new WfDynUIParseException("IOException", ex);
            }
            log.debug((Object)("ApproveUIDef HASH VALUE : " + hashValue + "  LENGHT IS : " + hashValue.length()));
            approveUIDef = DynUIParser.parseDynUIDoc(doc, hashValue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return approveUIDef;
    }

    public static ApproveUIDef parseDynUIDoc(Document doc, String hashValue) throws WfDynUIParseException {
        if (doc == null) {
            throw new IllegalArgumentException("doc");
        }
        Element destElement = doc.getRootElement();
        ApproveUIDef approveUIDef = new ApproveUIDef();
        approveUIDef.setHashValue(hashValue);
        approveUIDef.parse(destElement);
        return approveUIDef;
    }
}

