/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.workflow.dynui.IDynUIElement;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.util.SortedStringObjectMap;
import com.kingdee.util.Uuid;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class DynUIResource
implements IDynUIElement {
    private String id;
    private String key;
    private Map values;
    private Locale defaultLocale = Locale.getDefault();

    public DynUIResource() {
        this.values = new SortedStringObjectMap();
        this.id = Uuid.create().toString();
    }

    public DynUIResource(String destKey, String destId) {
        this();
        this.setPK(destKey, destId);
    }

    public DynUIResource(String destKey, String destId, String value) {
        this(destKey, destId, Locale.getDefault(), value);
    }

    public DynUIResource(String destKey, String destId, Locale locale, String value) {
        this(destKey, destId);
        this.setValue(locale, value);
    }

    public DynUIResource(Element destElement) throws WfDynUIParseException {
        this();
        this.parse(destElement);
    }

    @Override
    public IDynUIElement parse(Element destElement) throws WfDynUIParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        this.key = destElement.getAttributeValue("Key");
        this.id = destElement.getAttributeValue("Id");
        if (destElement.getChildren() != null) {
            Iterator languageIterator = destElement.getChildren().iterator();
            Element languageElement = null;
            String value = null;
            while (languageIterator.hasNext()) {
                languageElement = (Element)languageIterator.next();
                if (languageElement == null) continue;
                String locale = languageElement.getAttributeValue("Locale");
                value = languageElement.getText();
                if (locale == null || locale.length() <= 0 || value == null || value.length() <= 0) continue;
                this.values.put(locale.toLowerCase(), value);
            }
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element resourceElement = new Element("Resource");
        resourceElement.setAttribute("Key", String.valueOf(this.key));
        resourceElement.setAttribute("Id", String.valueOf(this.id));
        if (this.values != null && this.values.size() > 0) {
            Object value = null;
            Element languageElement = null;
            for (Map.Entry entry : this.values.entrySet()) {
                Object locale = entry.getKey();
                value = entry.getValue();
                if (locale != null) {
                    languageElement = new Element("Language");
                    languageElement.setAttribute("Locale", locale.toString().toLowerCase());
                    String valueStr = value != null ? value.toString() : "";
                    languageElement.addContent((Content)new CDATA(valueStr));
                    resourceElement.addContent((Content)languageElement);
                }
                languageElement = null;
            }
        }
        return resourceElement;
    }

    public String getPK() {
        return this.key + this.id;
    }

    public void setPK(String destKey, String destId) {
        this.setId(destId);
        this.setKey(destKey);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string.intern();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string.intern();
    }

    public void setValue(String string) {
        this.setValue(this.defaultLocale, string);
    }

    public void setValue(Locale locale, String string) {
        if (locale == null) {
            locale = this.defaultLocale;
        }
        this.values.put(BOSLocaleUtil.getShortCode((Locale)locale).toLowerCase(), string);
    }

    public String getValue() {
        return this.getValue(this.defaultLocale);
    }

    public String getValue(Locale locale) {
        Object v;
        if (locale == null) {
            locale = this.defaultLocale;
        }
        return (v = this.values.get(BOSLocaleUtil.getShortCode((Locale)locale).toLowerCase())) != null ? v.toString() : "";
    }

    @Override
    public Locale getLocale() {
        return this.defaultLocale;
    }
}

