/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui;

import com.kingdee.bos.workflow.dynui.AbstractDynUIElementCollectionBase;
import com.kingdee.bos.workflow.dynui.DynUIResource;
import com.kingdee.bos.workflow.dynui.IDynUIElement;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DynUIResourceCollection
extends AbstractDynUIElementCollectionBase {
    private String id;

    public DynUIResourceCollection() {
        this.id = Uuid.create().toString();
    }

    public DynUIResourceCollection(IDynUIElement container) {
        this.container = container;
        this.id = Uuid.create().toString();
    }

    public DynUIResourceCollection(Element destResourceElement) throws WfDynUIParseException {
        this();
        this.parse(destResourceElement);
        this.trimToSize();
    }

    public DynUIResourceCollection(IDynUIElement container, Element destResourceElement) throws WfDynUIParseException {
        this(destResourceElement);
        this.container = container;
    }

    @Override
    public IDynUIElement parse(Element destElement) throws WfDynUIParseException {
        if (destElement == null) {
            throw new IllegalArgumentException();
        }
        String tid = destElement.getAttributeValue("Id");
        if (!StringUtils.isEmpty((String)tid)) {
            this.id = tid;
        }
        List resourceElementList = destElement.getChildren("Resource");
        Element resourceElement = null;
        DynUIResource tempResourceDef = null;
        for (int i = 0; i < resourceElementList.size(); ++i) {
            resourceElement = (Element)resourceElementList.get(i);
            tempResourceDef = new DynUIResource(resourceElement);
            this.add(tempResourceDef.getKey(), tempResourceDef);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element resourcesElement = new Element("Resources");
        resourcesElement.setAttribute("Id", String.valueOf(this.id));
        for (int i = 0; i < this.size(); ++i) {
            resourcesElement.addContent((Content)this.get(i).toElement());
        }
        return resourcesElement;
    }

    public boolean add(String key, DynUIResource value) {
        return this.addObject(key, (Object)value);
    }

    public DynUIResource set(String key, DynUIResource value) {
        return (DynUIResource)this.setObject(key, (Object)value);
    }

    public DynUIResource removeDynUIResource(String key) {
        return (DynUIResource)super.remove(key);
    }

    public DynUIResource getDynUIResource(String key) {
        return (DynUIResource)super.get(key);
    }

    public DynUIResource getDynUIResource(int i) {
        return (DynUIResource)super.get(i);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

