/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui.approve;

import com.kingdee.bos.workflow.dynui.AbstractDynUIElement;
import com.kingdee.bos.workflow.dynui.DynUIResourceCollection;
import com.kingdee.bos.workflow.dynui.DynUIUtils;
import com.kingdee.bos.workflow.dynui.IDynUIElement;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class DynUIColumnDef
extends AbstractDynUIElement {
    private String id = Uuid.create().toString();
    private String bindValue;
    private int width;

    public DynUIColumnDef() {
    }

    public DynUIColumnDef(Element destElement) throws WfDynUIParseException {
        this();
        this.parse(destElement);
    }

    public DynUIColumnDef(IDynUIElement container, Element destResourceElement) throws WfDynUIParseException {
        this(destResourceElement);
        this.container = container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IDynUIElement parse(Element destElement) throws WfDynUIParseException {
        if (destElement == null) {
            throw new WfDynUIParseException("miss element");
        }
        String tid = destElement.getAttributeValue("Id");
        if (!StringUtils.isEmpty((String)tid)) {
            this.id = tid;
        }
        this.bindValue = destElement.getAttributeValue("BindValue");
        this.width = DynUIUtils.parseInt(destElement.getAttributeValue("Width"), -1);
        Element resourcesElement = destElement.getChild("Resources");
        if (resourcesElement != null) {
            this.resources = new DynUIResourceCollection(this, resourcesElement);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element resourcesElement = new Element("Column");
        resourcesElement.setAttribute("Id", String.valueOf(this.id));
        resourcesElement.setAttribute("BindValue", String.valueOf(this.bindValue));
        resourcesElement.setAttribute("Width", String.valueOf(this.width));
        if (this.resources != null) {
            resourcesElement.addContent((Content)this.resources.toElement());
        }
        return resourcesElement;
    }

    public String getBindValue() {
        return this.bindValue;
    }

    public void setBindValue(String bindvalue) {
        this.bindValue = bindvalue;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setText(String text) {
        this.setResource("HEADER_TEXT", text);
    }

    public void setText(String text, Locale locale) {
        this.setResource("HEADER_TEXT", text, locale);
    }

    public String getText() {
        return this.getResourceValue("HEADER_TEXT");
    }

    public String getText(Locale locale) {
        return this.getResourceValue("HEADER_TEXT", locale);
    }
}

