/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.dynui.approve;

import com.kingdee.bos.workflow.dynui.AbstractDynUIElement;
import com.kingdee.bos.workflow.dynui.DynUIResourceCollection;
import com.kingdee.bos.workflow.dynui.DynUIUtils;
import com.kingdee.bos.workflow.dynui.IDynUIElement;
import com.kingdee.bos.workflow.dynui.WfDynUIParseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;

public class DynUITextAreaDef
extends AbstractDynUIElement {
    private String id = Uuid.create().toString();
    private String type;
    private int height;
    private int width;

    public DynUITextAreaDef() {
    }

    public DynUITextAreaDef(Element destElement) throws WfDynUIParseException {
        this();
        this.parse(destElement);
    }

    public DynUITextAreaDef(IDynUIElement container, Element destResourceElement) throws WfDynUIParseException {
        this(destResourceElement);
        this.container = container;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IDynUIElement parse(Element destElement) throws WfDynUIParseException {
        if (destElement == null) {
            throw new WfDynUIParseException("miss element");
        }
        String tid = destElement.getAttributeValue("Id");
        if (!StringUtils.isEmpty((String)tid)) {
            this.id = tid;
        }
        this.type = destElement.getAttributeValue("Type");
        this.height = DynUIUtils.parseInt(destElement.getAttributeValue("Height"), -1);
        this.width = DynUIUtils.parseInt(destElement.getAttributeValue("Width"), -1);
        Element resourcesElement = destElement.getChild("Resources");
        if (resourcesElement != null) {
            this.resources = new DynUIResourceCollection(this, resourcesElement);
        }
        return this;
    }

    @Override
    public Element toElement() {
        Element resourcesElement = new Element("TextArea");
        resourcesElement.setAttribute("Id", String.valueOf(this.id));
        resourcesElement.setAttribute("Type", String.valueOf(this.type));
        resourcesElement.setAttribute("Height", String.valueOf(this.height));
        resourcesElement.setAttribute("Width", String.valueOf(this.width));
        if (this.resources != null) {
            resourcesElement.addContent((Content)this.resources.toElement());
        }
        return resourcesElement;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setText(String text) {
        this.setResource("DEFAULT_TEXT", text);
    }

    public void setText(String text, Locale locale) {
        this.setResource("DEFAULT_TEXT", text, locale);
    }

    public String getText() {
        return this.getResourceValue("DEFAULT_TEXT");
    }

    public String getText(Locale locale) {
        return this.getResourceValue("DEFAULT_TEXT", locale);
    }
}

