/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.def;

import com.kingdee.bos.workflow.emluator.def.ApproveSplitCollection;
import com.kingdee.bos.workflow.emluator.def.BizExterndDataCollecition;
import com.kingdee.bos.workflow.emluator.def.DecitionSplitCollection;
import com.kingdee.bos.workflow.emluator.def.EmluationOptionInfo;
import com.kingdee.bos.workflow.emluator.def.ITestableElement;
import com.kingdee.bos.workflow.emluator.def.MutexSplitCollection;
import com.kingdee.bos.workflow.emluator.def.StartupInfo;
import com.kingdee.bos.workflow.emluator.def.SubFlowEmluationCollection;
import com.kingdee.bos.workflow.emluator.def.ValidateResult;
import com.kingdee.bos.workflow.emluator.def.WfSimulationParseException;
import com.kingdee.util.Uuid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ProcessTestMetaDef
implements ITestableElement {
    private String id = Uuid.create().toString();
    private String processDefId;
    private String ais;
    private String solution;
    private String strLocale;
    private String serverUrl;
    private String clientMetaPath;
    private String name = "";
    private StartupInfo startupInfo = new StartupInfo(this);
    private EmluationOptionInfo optionInfo;
    private MutexSplitCollection mutexCol = new MutexSplitCollection();
    private DecitionSplitCollection decitionSplitCol;
    private ApproveSplitCollection approveSplitCol;
    private BizExterndDataCollecition bizExterndDataCol;
    private SubFlowEmluationCollection subFlowCol;

    public ProcessTestMetaDef() {
        this.optionInfo = new EmluationOptionInfo(this);
        this.decitionSplitCol = new DecitionSplitCollection();
        this.approveSplitCol = new ApproveSplitCollection();
        this.bizExterndDataCol = new BizExterndDataCollecition();
        this.subFlowCol = new SubFlowEmluationCollection();
    }

    public static ProcessTestMetaDef createByFileSystem(String filePath) throws WfSimulationParseException {
        File file = new File(filePath);
        if (!file.exists() || file.isDirectory()) {
            throw new WfSimulationParseException("target file is not exsit or is not a file");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element rootElement = doc.getRootElement();
            ProcessTestMetaDef def = new ProcessTestMetaDef();
            return (ProcessTestMetaDef)def.parse(rootElement);
        }
        catch (JDOMException e) {
            throw new WfSimulationParseException(e);
        }
        catch (IOException e) {
            throw new WfSimulationParseException(e);
        }
    }

    public static ProcessTestMetaDef createByInputStream(InputStream inputStream) throws WfSimulationParseException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inputStream);
            Element rootElement = doc.getRootElement();
            ProcessTestMetaDef def = new ProcessTestMetaDef();
            return (ProcessTestMetaDef)def.parse(rootElement);
        }
        catch (JDOMException e) {
            throw new WfSimulationParseException(e);
        }
        catch (IOException e) {
            throw new WfSimulationParseException(e);
        }
    }

    public static ProcessTestMetaDef createByString(String xml) throws WfSimulationParseException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("utf-8"));
            return ProcessTestMetaDef.createByInputStream(inputStream);
        }
        catch (IOException e) {
            throw new WfSimulationParseException(e);
        }
    }

    @Override
    public Element toElement() {
        Element root = new Element("processTestMetas");
        root.setAttribute("id", this.id);
        root.setAttribute("name", this.name);
        root.setAttribute("processDefId", this.processDefId);
        root.setAttribute("solution", this.solution);
        root.setAttribute("ais", this.ais);
        root.setAttribute("serverUrl", this.serverUrl);
        root.setAttribute("strLocale", this.strLocale);
        root.addContent((Content)this.startupInfo.toElement());
        root.addContent((Content)this.optionInfo.toElement());
        root.addContent((Content)this.mutexCol.toElement());
        root.addContent((Content)this.approveSplitCol.toElement());
        root.addContent((Content)this.decitionSplitCol.toElement());
        root.addContent((Content)this.bizExterndDataCol.toElement());
        root.addContent((Content)this.subFlowCol.toElement());
        Element metaPathElement = new Element("clientMetaPath");
        metaPathElement.setText(this.clientMetaPath);
        root.addContent((Content)metaPathElement);
        return root;
    }

    @Override
    public ITestableElement parse(Element element) throws WfSimulationParseException {
        this.id = element.getAttributeValue("id");
        this.name = element.getAttributeValue("name");
        this.processDefId = element.getAttributeValue("processDefId");
        this.solution = element.getAttributeValue("solution");
        this.ais = element.getAttributeValue("ais");
        this.serverUrl = element.getAttributeValue("serverUrl");
        this.strLocale = element.getAttributeValue("strLocale");
        Element startupElement = element.getChild("startupInfo");
        this.startupInfo = (StartupInfo)new StartupInfo(this).parse(startupElement);
        Element optionElement = element.getChild("emluationOptionInfo");
        if (optionElement != null) {
            this.optionInfo = (EmluationOptionInfo)new EmluationOptionInfo(this).parse(optionElement);
        }
        Element mutexElement = element.getChild("mutexSplitInfos");
        this.mutexCol = new MutexSplitCollection(this, mutexElement);
        Element bizExterndDataElement = element.getChild("bizExterndDataInfos");
        this.bizExterndDataCol = new BizExterndDataCollecition(this, bizExterndDataElement);
        Element approveSplitElement = element.getChild("approveSplitInfos");
        this.approveSplitCol = new ApproveSplitCollection(this, approveSplitElement);
        Element decitionSplitElement = element.getChild("decitionSplitInfos");
        this.decitionSplitCol = new DecitionSplitCollection(this, decitionSplitElement);
        Element subFlowElement = element.getChild("subFlowEmluationInfos");
        this.subFlowCol = new SubFlowEmluationCollection(this, subFlowElement);
        Element metaPahtElement = element.getChild("clientMetaPath");
        this.clientMetaPath = metaPahtElement.getTextTrim();
        return this;
    }

    @Override
    public ValidateResult validate() {
        return new ValidateResult();
    }

    @Override
    public ITestableElement getParent() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toXML() throws WfSimulationParseException {
        Element element = this.toElement();
        Document doc = new Document(element);
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        try {
            XMLOutputter xml = new XMLOutputter();
            Format f = xml.getFormat();
            f.setLineSeparator("");
            f.setIndent("\t  ");
            xml.output(doc, (OutputStream)baOut);
            byte[] bytes = baOut.toByteArray();
            return new String(bytes);
        }
        catch (IOException e) {
            throw new WfSimulationParseException(e);
        }
    }

    public String getAis() {
        return this.ais;
    }

    public void setAis(String ais) {
        this.ais = ais;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public StartupInfo getStartupInfo() {
        return this.startupInfo;
    }

    public void setStartupInfo(StartupInfo startupInfo) {
        this.startupInfo = startupInfo;
    }

    public String getStrLocale() {
        return this.strLocale;
    }

    public void setStrLocale(String strLocale) {
        this.strLocale = strLocale;
    }

    public ApproveSplitCollection getApproveSplitCol() {
        return this.approveSplitCol;
    }

    public BizExterndDataCollecition getBizExterndDataCol() {
        return this.bizExterndDataCol;
    }

    public DecitionSplitCollection getDecitionSplitCol() {
        return this.decitionSplitCol;
    }

    public MutexSplitCollection getMutexCol() {
        return this.mutexCol;
    }

    public String getClientMetaPath() {
        return this.clientMetaPath;
    }

    public void setClientMetaPath(String clientMetaPath) {
        this.clientMetaPath = clientMetaPath;
    }

    public SubFlowEmluationCollection getSubFlowCol() {
        return this.subFlowCol;
    }

    public EmluationOptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public void setOptionInfo(EmluationOptionInfo optionInfo) {
        this.optionInfo = optionInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

