/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.emluator.engine.DefaultMethodInvoker;
import com.kingdee.bos.workflow.emluator.engine.EmluationContext;
import com.kingdee.bos.workflow.emluator.engine.EmluationException;
import com.kingdee.bos.workflow.emluator.engine.IMethodInvoker;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class AbstractExecutable
implements Serializable {
    private BOSObjectType bosType;
    private String methodName;
    protected EmluationContext ctx;
    protected Object[] args;
    protected Object methodRtnValue;
    protected IMethodInvoker invoker = new DefaultMethodInvoker();
    protected List voPkList;

    public void fillContext(EmluationContext ctx, BOSObjectType type, String methodName) {
        this.ctx = ctx;
        this.bosType = type;
        this.methodName = methodName;
        this.voPkList = ctx.getBizObjectIds();
    }

    protected Map getProcessContext(String bizObjId) throws WfException, BOSException {
        return EnactmentServiceFactory.createRemoteEnactService().getProcessContext(bizObjId);
    }

    public final Object bizMethodInvoke() {
        try {
            this.args = this.constructNewArgs();
            this.methodRtnValue = this.methodInvoke(this.args);
        }
        catch (Exception ex) {
            throw new EmluationException(2002, StringUtils.stackToString((Exception)ex));
        }
        return this.methodRtnValue;
    }

    protected Object methodInvoke(Object[] args) throws Exception {
        return this.getMethodInvoker().invoke(this.bosType, this.methodName, args);
    }

    public String[] getObjectPK() {
        return this.getObjectPK(this.args, this.methodRtnValue);
    }

    protected abstract String[] getObjectPK(Object[] var1, Object var2);

    protected abstract Object[] constructNewArgs() throws Exception;

    public abstract void assertion() throws Exception;

    protected IMethodInvoker getMethodInvoker() {
        return this.invoker;
    }

    public Context getContext() {
        return this.getMethodInvoker().getContext();
    }
}

