/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.emluator.util;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.emluator.engine.EmluationException;

public class WfModelUtil {
    public static ActivityDef getActivityDef(ProcessDef processDef, String activityDefId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activityDefId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new EmluationException("activity type is not Manpower,it is " + (Object)((Object)actDef.getType()));
        }
        return actDef;
    }

    public static OperationInfo getOperation(ProcessDef processDef, String activityId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activityId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new EmluationException("activity type is not Manpower,it is " + (Object)((Object)actDef.getType()));
        }
        ApplicationDef appDef = ((ManpowerActivityDef)actDef).getRelatedApplication();
        FunctionDef funcDef = appDef.getFunction();
        String packName = funcDef.getPackageName();
        String funcName = funcDef.getName();
        String operName = funcDef.getOperation();
        FunctionObjectInfo func = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)new MetaDataPK(packName, funcName));
        OperationCollection operCol = func.getOperation();
        OperationInfo operInfo = null;
        int n = operCol.size();
        for (int i = 0; i < n; ++i) {
            if (!operName.equals(operCol.get(i).getName())) continue;
            operInfo = operCol.get(i);
            break;
        }
        if (operInfo == null) {
            throw new EmluationException("can not get operation");
        }
        return operInfo;
    }

    public static String getExecutor(ProcessDef processDef, String activityId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activityId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new EmluationException("activity type is not Manpower,it is " + (Object)((Object)actDef.getType()));
        }
        ApplicationDef appDef = ((ManpowerActivityDef)actDef).getRelatedApplication();
        FunctionDef funcDef = appDef.getFunction();
        String packName = funcDef.getPackageName();
        String funcName = funcDef.getName();
        String operName = funcDef.getOperation();
        FunctionObjectInfo func = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)new MetaDataPK(packName, funcName));
        OperationCollection operCol = func.getOperation();
        OperationInfo operInfo = null;
        if (operCol != null && operCol.size() > 0) {
            int n = operCol.size();
            for (int i = 0; i < n; ++i) {
                if (operCol.get(i) == null || !operName.equals(operCol.get(i).getName())) continue;
                operInfo = operCol.get(i);
                break;
            }
        }
        if (operInfo == null) {
            throw new EmluationException("can not get operation");
        }
        return operInfo.getExtendedProperty("executor");
    }

    public static BOSObjectType getEntityBosType(ProcessDef processDef, String activityId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activityId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new EmluationException("activity type is not Manpower,it is " + (Object)((Object)actDef.getType()));
        }
        ApplicationDef appDef = ((ManpowerActivityDef)actDef).getRelatedApplication();
        FunctionDef funcDef = appDef.getFunction();
        String packName = funcDef.getPackageName();
        String funcName = funcDef.getName();
        String operName = funcDef.getOperation();
        FunctionObjectInfo func = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)new MetaDataPK(packName, funcName));
        if (func == null) {
            throw new EmluationException("can not get function");
        }
        OperationCollection operCol = func.getOperation();
        OperationInfo operInfo = null;
        if (operCol != null && operCol.size() > 0) {
            int n = operCol.size();
            for (int i = 0; i < n; ++i) {
                if (operCol.get(i) == null || !operName.equals(operCol.get(i).getName())) continue;
                operInfo = operCol.get(i);
                break;
            }
        }
        if (operInfo == null) {
            throw new EmluationException("can not get operation");
        }
        BOSObjectType type = null;
        type = operInfo.getFacadeObjectRef() != null ? operInfo.getFacadeObjectRef().getBOSType() : operInfo.getEntityObjectRef().getBOSType();
        return type;
    }

    public static String getMethodName(ProcessDef processDef, String activityId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activityId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        if (!(actDef instanceof ManpowerActivityDef)) {
            throw new EmluationException("activity type is not Manpower,it is " + (Object)((Object)actDef.getType()));
        }
        ApplicationDef appDef = ((ManpowerActivityDef)actDef).getRelatedApplication();
        FunctionDef funcDef = appDef.getFunction();
        String packName = funcDef.getPackageName();
        String funcName = funcDef.getName();
        String operName = funcDef.getOperation();
        FunctionObjectInfo func = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)new MetaDataPK(packName, funcName));
        if (func == null) {
            throw new EmluationException("can not get function");
        }
        OperationCollection operCol = func.getOperation();
        OperationInfo operInfo = null;
        if (operCol != null && operCol.size() > 0) {
            int n = operCol.size();
            for (int i = 0; i < n; ++i) {
                if (operCol.get(i) == null || !operName.equals(operCol.get(i).getName())) continue;
                operInfo = operCol.get(i);
                break;
            }
        }
        if (operInfo == null) {
            throw new EmluationException("can not get operation");
        }
        String methodName = "";
        if (operInfo.getFacadeObjectRef() != null) {
            operInfo.getFacadeMethodRef().getName();
        } else {
            operInfo.getEntityMethodRef().getName();
        }
        return methodName;
    }

    public static ActivityCollection getPrevActivityDef(ProcessDef processDef, String activiyDefId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activiyDefId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        try {
            return actDef.getPreviousActivities();
        }
        catch (WfException e) {
            throw new EmluationException((Throwable)((Object)e));
        }
    }

    public static ActivityCollection getPostActivityDef(ProcessDef processDef, String activiyDefId) {
        ActivityCollection col = processDef.getActivitys();
        ActivityDef actDef = col.get(activiyDefId);
        if (actDef == null) {
            throw new EmluationException("can not get fitable activty");
        }
        try {
            return actDef.getPostActivities();
        }
        catch (WfException e) {
            throw new EmluationException((Throwable)((Object)e));
        }
    }

    public static ActivityCollection getActivitys(ProcessDef procDef, ActivityType[] type) {
        ActivityCollection activities = new ActivityCollection(procDef);
        for (int i = 0; i < procDef.getActivitys().size(); ++i) {
            int m = type.length;
            for (int j = 0; j < m; ++j) {
                if (!procDef.getActivitys().get(i).getType().equals((Object)type[j])) continue;
                activities.add(procDef.getActivitys().get(i));
            }
        }
        return activities;
    }
}

