/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.history;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.contrast.InfoAccess;
import com.kingdee.bos.dao.ormapping.contrast.MapSerializer;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.history.HistoryInfo;
import com.kingdee.bos.workflow.metas.BillHistoryCollection;
import com.kingdee.bos.workflow.metas.BillHistoryFactory;
import com.kingdee.bos.workflow.metas.BillHistoryInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.util.DataZipUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HistoryHandler {
    private static Logger log = Logger.getLogger((String)HistoryHandler.class.getName());
    public static final String IS_SHOW_BILL_HISTORY = "IS_SHOW_BILL_HISTORY";

    public static boolean isShowBillHistory(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)IS_SHOW_BILL_HISTORY);
            return "TRUE".equalsIgnoreCase(value);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static CoreBaseInfo getLastestHisBillInfo(Context ctx, BOSObjectType bosType, IObjectPK pk) {
        if (!HistoryHandler.isShowBillHistory(ctx)) {
            return null;
        }
        try {
            BillHistoryInfo billHistory = HistoryHandler.getLastestHistoryInfo(ctx, bosType, pk).getBillHistory();
            if (billHistory == null) {
                return null;
            }
            EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            CoreBaseInfo newVal = iObjectBase.getValue(pk);
            InfoAccess infoAccess = new InfoAccess(bo, (IObjectValue)newVal, MapSerializer.deserialize((byte[])DataZipUtils.unpack((byte[])billHistory.getContent())));
            return (CoreBaseInfo)infoAccess.transFormForOldValue();
        }
        catch (Throwable e) {
            log.info((Object)"getLastestHisBillInfo fail! ", e);
            return null;
        }
    }

    public static HistoryInfo getLastestHistoryInfo(Context ctx, BOSObjectType bosType, IObjectPK pk) {
        if (!HistoryHandler.isShowBillHistory(ctx)) {
            return null;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(HistoryHandler.getBillHistorySelectors());
            SorterItemInfo sort = new SorterItemInfo("version");
            sort.setSortType(SortType.DESCEND);
            view.getSorter().add(sort);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)pk.toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType.toString()));
            String maskString = "#0 and #1";
            filterInfo.setMaskString(maskString);
            view.setFilter(filterInfo);
            view.setTopCount(1);
            BillHistoryCollection hstCol = BillHistoryFactory.getLocalInstance(ctx).getBillHistoryCollection(view);
            if (hstCol.size() == 0) {
                return null;
            }
            BillHistoryInfo billHistory = hstCol.get(0);
            EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            CoreBaseInfo newVal = iObjectBase.getValue(pk);
            InfoAccess infoAccess = new InfoAccess(bo, (IObjectValue)newVal, MapSerializer.deserialize((byte[])DataZipUtils.unpack((byte[])billHistory.getContent())));
            Map map = infoAccess.transFormForMap();
            HistoryInfo historyInfo = new HistoryInfo();
            historyInfo.setBillHistory(billHistory);
            historyInfo.setAddList((List)map.get("addList"));
            historyInfo.setDeleteList((List)map.get("deleteList"));
            historyInfo.setUpdateList((List)map.get("updateList"));
            return historyInfo;
        }
        catch (Throwable e) {
            log.info((Object)"getLastestHisBillInfo fail! ", e);
            return null;
        }
    }

    public static List<CoreBaseInfo> getAllHisBillInfo(Context ctx, BOSObjectType bosType, IObjectPK pk) {
        return null;
    }

    public static List<BillHistoryInfo> getAllHistoryInfo(Context ctx, BOSObjectType bosType, IObjectPK pk) {
        return null;
    }

    private static SelectorItemCollection getBillHistorySelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("billId"));
        selectors.add(new SelectorItemInfo("bosType"));
        selectors.add(new SelectorItemInfo("content"));
        selectors.add(new SelectorItemInfo("version"));
        selectors.add(new SelectorItemInfo("createdTime"));
        return selectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveBillHistory(Context ctx, CoreBaseInfo newVal) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(newVal.getId());
            BOSObjectType bosType = newVal.getBOSType();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT Max(FVersion)+1 FROM T_WFR_BillHistory WHERE ");
            sql.append("FBillId = ? AND FBosType = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            ps = BaseDataAccess.prepareStatement((Connection)conn, (String)sql.toString());
            ps.setString(1, pk.toString());
            ps.setString(2, bosType.toString());
            int version = 1;
            rs = ps.executeQuery();
            if (rs.next()) {
                version = rs.getInt(1);
            }
            EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            InfoAccess infoAccess = new InfoAccess(bo);
            SelectorItemCollection col = infoAccess.getSelectors();
            CoreBaseInfo oldVal = HistoryHandler.getValueByRequiresNew(iObjectBase, (IObjectPK)pk, col);
            infoAccess.setNewValue((IObjectValue)newVal);
            infoAccess.setOldValue((IObjectValue)oldVal);
            BillHistoryInfo billHistory = new BillHistoryInfo();
            billHistory.setBillId(pk.toString());
            billHistory.setBosType(bosType.toString());
            billHistory.setContent(DataZipUtils.pack((byte[])MapSerializer.serialize((Map)infoAccess.contrastInfoToMap())));
            billHistory.setCreatedTime(new Timestamp(System.currentTimeMillis()));
            billHistory.setVersion(version);
            BillHistoryFactory.getLocalInstance(ctx).addnew(billHistory);
            int n = version;
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return n;
        }
        catch (Exception e) {
            log.info((Object)"saveBillHistory fail! ", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            SQLUtils.cleanup(rs, ps, conn);
        }
    }

    private static CoreBaseInfo getValueByRequiresNew(IObjectBase objectBase, IObjectPK pk, SelectorItemCollection col) throws Exception {
        try {
            Method method = objectBase.getClass().getMethod("getValue", IObjectPK.class, SelectorItemCollection.class);
            Object[] params = new Object[]{pk, col};
            int transaction = 3;
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)objectBase);
            Object resutl = txInvoker.invoke(method, params, transaction);
            return (CoreBaseInfo)resutl;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }
}

