/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.IEntityObject;
import com.kingdee.bos.workflow.mdo.IEntityProperty;
import com.kingdee.bos.workflow.mdo.impl.EntityLinkProperty;
import com.kingdee.bos.workflow.mdo.impl.EntityOwnProperty;
import com.kingdee.bos.workflow.util.TreeSelectorUtils;
import java.util.ArrayList;
import java.util.List;

public class EntityObject
implements IEntityObject {
    private static final long serialVersionUID = -4433087449146181715L;
    private String name;
    private String fullName;
    private String alias;
    private BOSObjectType type;
    private List properties = new ArrayList();

    private EntityObject() {
    }

    public static IEntityObject create(EntityObjectInfo entity) {
        EntityObject entityObject = new EntityObject();
        entityObject.setName(entity.getName());
        entityObject.setAlias(TreeSelectorUtils.getEntityAlias(entity));
        entityObject.setFullName(entity.getFullName());
        entityObject.setType(entity.getType());
        PropertyCollection collection = entity.getInheritedProperties();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = collection.get(i);
            IEntityProperty property = propertyInfo instanceof OwnPropertyInfo ? EntityOwnProperty.create((OwnPropertyInfo)propertyInfo) : EntityLinkProperty.create((LinkPropertyInfo)propertyInfo);
            entityObject.addtProperty(property);
        }
        return entityObject;
    }

    public static IEntityObject create(String name, String alias, String fullName, BOSObjectType type) {
        EntityObject entityObject = new EntityObject();
        entityObject.setName(name);
        entityObject.setAlias(alias);
        entityObject.setFullName(fullName);
        entityObject.setType(type);
        return entityObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    private void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public List getProperties() {
        return this.properties;
    }

    private void addtProperty(IEntityProperty property) {
        this.properties.add(property);
    }

    @Override
    public BOSObjectType getType() {
        return this.type;
    }

    private void setType(BOSObjectType type) {
        this.type = type;
    }

    @Override
    public BOSObjectType getMDOType() {
        return MDO_TYPE;
    }
}

