/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mdo.impl;

import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.mdo.IFunctionObject;
import com.kingdee.bos.workflow.mdo.IOperationObject;
import com.kingdee.bos.workflow.mdo.impl.OperationObject;
import com.kingdee.bos.workflow.util.TreeSelectorUtils;
import java.util.ArrayList;
import java.util.List;

public class FunctionObject
implements IFunctionObject {
    private static final long serialVersionUID = 5416046892293318954L;
    private String packageName;
    private String name;
    private String alias;
    private String fullName;
    private List operations = new ArrayList();
    private boolean isDynamic;
    private String description = "";

    private FunctionObject() {
    }

    public static IFunctionObject create(FunctionObjectInfo function) {
        OperationCollection collection;
        FunctionObject functionObject = new FunctionObject();
        functionObject.setPackageName(function.getPackage());
        functionObject.setName(function.getName());
        functionObject.setAlias(TreeSelectorUtils.getFunctionAlias(function));
        functionObject.setFullName(function.getFullName());
        functionObject.setDynamic(function.isDynamic());
        String funDescription = function.getDescription();
        if (funDescription != null) {
            functionObject.setDescription(funDescription);
        }
        if ((collection = function.getOperation()) != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                OperationInfo operationInfo = collection.get(i);
                IOperationObject operationObject = OperationObject.create(functionObject, operationInfo);
                functionObject.addOperation(operationObject);
            }
        }
        return functionObject;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    private void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    private void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public List getOperations() {
        return this.operations;
    }

    @Override
    public IOperationObject getOperation(String name) {
        int size = this.operations.size();
        for (int i = 0; i < size; ++i) {
            IOperationObject operationObject = (IOperationObject)this.operations.get(i);
            if (!operationObject.getName().equals(name)) continue;
            return operationObject;
        }
        return null;
    }

    private void addOperation(IOperationObject operation) {
        this.operations.add(operation);
    }

    @Override
    public BOSObjectType getMDOType() {
        return MDO_TYPE;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

