/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import bos.org.apache.commons.dbutils.DbUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.workflow.metas.AbstractAdjustWfDataControllerBean;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.util.EngineConfig;
import com.kingdee.bos.workflow.util.WfDbUtil;
import com.kingdee.bos.workflow.util.WorkflowLogUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;

public class AdjustWfDataControllerBean
extends AbstractAdjustWfDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.AdjustWfDataControllerBean");
    private int minBatchCount = 100;
    private int maxBatchCount = 300;
    private int minDay = 1;

    @Override
    protected void _adjustWfData(Context ctx) throws BOSException {
        this.innerAdjustWfData(ctx, 0, 100);
    }

    @Override
    protected void _adjustWfData(Context ctx, int day) throws BOSException {
        this._adjustWfData(ctx, day, 100);
    }

    @Override
    protected void _adjustWfData(Context ctx, int day, int batchCount) throws BOSException {
        logger.debug((Object)"AdjustWfDataControllerBean._adjustWfData() start!");
        if (day < this.minDay) {
            day = this.minDay;
        }
        if (batchCount < this.minBatchCount) {
            batchCount = this.minBatchCount;
        }
        if (batchCount > this.maxBatchCount) {
            batchCount = this.maxBatchCount;
        }
        this.dumpWfDataInner(ctx, day, batchCount);
        logger.debug((Object)"AdjustWfDataControllerBean._adjustWfData() end!");
    }

    @Override
    protected void _adjustWfLogData(Context ctx, int day) throws BOSException {
        logger.debug((Object)"AdjustWfDataControllerBean._adjustWfLogData() start!");
        long startTime = System.currentTimeMillis();
        if (day < this.minDay) {
            day = this.minDay;
        }
        Connection cn = null;
        try {
            cn = WfDbUtil.getConnection(ctx);
            StringBuffer buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ENGINELOG");
            buffer.append(" WHERE (FTIME < (GETDATE()-?))");
            String sql = buffer.toString();
            PreparedStatement statement = cn.prepareStatement(sql);
            statement.setInt(1, day);
            statement.execute();
            statement.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_PROCESSDEFLOG");
            buffer.append(" WHERE (FTIME < (GETDATE()-?))");
            sql = buffer.toString();
            statement = cn.prepareStatement(sql);
            statement.setInt(1, day);
            statement.execute();
            statement.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_PROCESSINSTLOG");
            buffer.append(" WHERE (FTIME < (GETDATE()-?))");
            sql = buffer.toString();
            statement = cn.prepareStatement(sql);
            statement.setInt(1, day);
            statement.execute();
            statement.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_QUEUELOG");
            buffer.append(" WHERE (FTIME < (GETDATE()-?))");
            sql = buffer.toString();
            statement = cn.prepareStatement(sql);
            statement.setInt(1, day);
            statement.execute();
        }
        catch (SQLException e) {
            throw new BOSException("SQLException", (Throwable)e);
        }
        finally {
            try {
                cn.close();
            }
            catch (SQLException e) {
                throw new BOSException("SQLException", (Throwable)e);
            }
        }
        long endTime = System.currentTimeMillis();
        long consumeTime = (endTime - startTime) / 1000L;
        logger.info((Object)("AdjustWfDataControllerBean._adjustWfLogData() consume " + consumeTime + " seconds!"));
        logger.info((Object)"AdjustWfDataControllerBean._adjustWfLogData() end!");
    }

    @Override
    protected void _throwException(Context ctx) throws BOSException {
        throw new BOSException("Test method!");
    }

    private void innerAdjustWfData(Context ctx, int day, int batchCount) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdjustWfDataControllerBean.innerAdjustWfData(");
        buffer.append(day);
        buffer.append(",");
        buffer.append(batchCount);
        buffer.append(")!");
        String msg = buffer.toString();
        logger.info((Object)msg);
        Connection cn = null;
        try {
            cn = WfDbUtil.getConnection(ctx);
            String procInstIdSet = this.getProcInstIdSet(cn, batchCount, day);
            while (!StringUtils.isEmpty((String)procInstIdSet)) {
                this.adjustWfDataBatch(cn, procInstIdSet);
                procInstIdSet = this.getProcInstIdSet(cn, batchCount, day);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQLException", (Throwable)e);
        }
        finally {
            try {
                cn.close();
            }
            catch (SQLException e) {
                throw new BOSException("SQLException", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcInstIdSet(Connection cn, int batchCount, int day) throws SQLException {
        if (cn == null) {
            throw new IllegalArgumentException();
        }
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT");
        buffer.append(" FPROCINSTID, FPARENTPROCINSTID");
        buffer.append(" FROM T_WFR_ProcInst");
        buffer.append(" WHERE");
        buffer.append(" (");
        buffer.append("     (FSTATE = 'closed.completed')");
        buffer.append(" OR (FSTATE = 'closed.aborted')");
        buffer.append(" OR (FSTATE = 'closed.terminated')");
        buffer.append(" )");
        if (day > 0) {
            buffer.append(" AND (DATEDIFF(Day,FLASTSTATETIME,GETDATE()) >= " + day + ")");
        }
        sql = buffer.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, Boolean> parentProcInstIds = new HashMap<String, Boolean>();
        try {
            ps = cn.prepareStatement(sql);
            rs = ps.executeQuery();
            HashSet<String> ids = new HashSet<String>();
            String processIds = "";
            int index = 0;
            while (rs.next() && index < batchCount) {
                String processId = rs.getString("FPROCINSTID");
                String parentProcInstId = rs.getString("FPARENTPROCINSTID");
                if (parentProcInstId == null) {
                    parentProcInstIds.put(processId, Boolean.TRUE);
                } else {
                    boolean b = this.parentProcIsClosed(cn, parentProcInstIds, processId);
                    parentProcInstIds.put(processId, b);
                    if (!b) continue;
                }
                ids.add(processId);
                ++index;
            }
            processIds = this.setToString(ids);
            String processIdSet = "";
            if (!"".equals(processIds)) {
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append("('");
                buffer2.append(processIds);
                buffer2.append("')");
                processIdSet = buffer2.toString();
            }
            logger.debug((Object)("\"processIdSet\" is \"" + processIdSet + "\"!"));
            String string = processIdSet;
            return string;
        }
        finally {
            ps.close();
            rs.close();
        }
    }

    private String setToString(Set<String> set) {
        if (set == null || set.size() == 0) {
            return "";
        }
        Iterator<String> itr = set.iterator();
        StringBuilder buffer = new StringBuilder();
        while (itr.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append("','");
            }
            buffer.append(itr.next());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parentProcIsClosed(Connection cn, HashMap parentProcInstIds, String procInstId) throws SQLException {
        Boolean b = (Boolean)parentProcInstIds.get(procInstId);
        if (b != null) {
            return b;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FPARENTPROCINSTID");
        buffer.append(" FROM T_WFR_ProcInst");
        buffer.append(" WHERE");
        buffer.append(" (");
        buffer.append("     (FSTATE = 'closed.completed')");
        buffer.append(" OR (FSTATE = 'closed.aborted')");
        buffer.append(" OR (FSTATE = 'closed.terminated')");
        buffer.append(" ) and FPROCINSTID='" + procInstId + "'");
        String sql = buffer.toString();
        Statement smt = null;
        ResultSet rs = null;
        try {
            boolean t;
            block9: {
                block8: {
                    smt = cn.createStatement();
                    rs = this.executeQuery(sql, smt);
                    if (rs.next()) break block8;
                    Statement smt2 = null;
                    ResultSet rs2 = null;
                    try {
                        smt2 = cn.createStatement();
                        rs2 = this.executeQuery(" select FPROCINSTID from T_WFR_ProcInst where FPROCINSTID='" + procInstId + "' ", smt2);
                        t = !rs2.next();
                    }
                    catch (Throwable throwable) {
                        DbUtils.closeQuietly((Statement)smt2);
                        DbUtils.closeQuietly(rs2);
                        throw throwable;
                    }
                    DbUtils.closeQuietly((Statement)smt2);
                    DbUtils.closeQuietly((ResultSet)rs2);
                    break block9;
                }
                String parentProcInstId = rs.getString("FPARENTPROCINSTID");
                t = parentProcInstId == null ? true : this.parentProcIsClosed(cn, parentProcInstIds, parentProcInstId);
            }
            parentProcInstIds.put(procInstId, t);
            boolean bl = t;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (smt != null) {
                smt.close();
            }
        }
    }

    private ResultSet executeQuery(String sql, Statement smt) throws SQLException {
        return smt.executeQuery(sql);
    }

    private void adjustWfDataBatch(Connection cn, String procInstIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)procInstIdSet)) {
            return;
        }
        this.transferWfDataBatch(cn, procInstIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyWfDataBatch(Connection cn) throws SQLException {
        try (Statement ps = null;){
            String sql = "DELETE T_WFR_ASSIGNHST WHERE FASSIGNID IN(SELECT FASSIGNID FROM T_WFR_ASSIGNDETAIL)";
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "DELETE T_WFR_ACTINSTHST WHERE FACTINSTID IN(SELECT FACTINSTID FROM T_WFR_ACTINST)";
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "DELETE T_WFR_PROCINSTDATAHST WHERE FPROCINSTID IN(SELECT FPROCINSTID FROM T_WFR_PROCINSTDATA)";
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "DELETE T_WFR_PROCINSTHST WHERE FPROCINSTID IN(SELECT FPROCINSTID FROM T_WFR_PROCINST)";
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "DELETE T_WFR_PROCINSTREFHST WHERE FPROCINSTID IN(SELECT FPROCINSTID FROM T_WFR_PROCINSTREF)";
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferWfDataBatch(Connection cn, String procInstIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)procInstIdSet)) {
            return;
        }
        try (Statement ps = null;){
            StringBuffer buffer = new StringBuffer();
            buffer.append(" INSERT INTO  T_WFR_ProcInstHst  (FPROCINSTID,FSTATE,FPROCDEFID,FPROCDEFVER,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFXPDL,FPROCDEFHASH,FCOMLETETIME,FLASTSTATETIME,FCREATEDTIME,FPARENTACTINSTID,FPARENTACTDEFID,FPACTDEFNAME_L1,FPACTDEFNAME_L2,FPACTDEFNAME_L3,FPARENTPROCINSTID,FPARENTPROCDEFID,FPPROCDEFNAME_L1,FPPROCDEFNAME_L2,FPPROCDEFNAME_L3,FTIMEUNIT,FLIMIT,FINITIATORID,FINITIATORNAME_L1,FINITIATORNAME_L2,FINITIATORNAME_L3,FSTARTACTINSTID,FPROCDEFTYPE,FCODE,FWAITINGTIME,FDURATION,FWORKINGTIME,FPROCINSTTOPIC_L1,FPROCINSTTOPIC_L2,FPROCINSTTOPIC_L3,FCONTROLUNITID)SELECT FPROCINSTID,FSTATE,FPROCDEFID,FPROCDEFVER,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFXPDL,FPROCDEFHASH,FCOMLETETIME,FLASTSTATETIME,FCREATEDTIME,FPARENTACTINSTID,FPARENTACTDEFID,FPACTDEFNAME_L1,FPACTDEFNAME_L2,FPACTDEFNAME_L3,FPARENTPROCINSTID,FPARENTPROCDEFID,FPPROCDEFNAME_L1,FPPROCDEFNAME_L2,FPPROCDEFNAME_L3,FTIMEUNIT,FLIMIT,FINITIATORID,FINITIATORNAME_L1,FINITIATORNAME_L2,FINITIATORNAME_L3,FSTARTACTINSTID,FPROCDEFTYPE,FCODE,FWAITINGTIME,FDURATION,FWORKINGTIME,FPROCINSTTOPIC_L1,FPROCINSTTOPIC_L2,FPROCINSTTOPIC_L3,FCONTROLUNITID FROM T_WFR_ProcInst");
            buffer.append(" WHERE");
            buffer.append("  (FPROCINSTID IN " + procInstIdSet + ")");
            String sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_WFR_ProcInstDataHst  (FPROCINSTID,FTIME,FPROCDEFID,FPROCDEFHASH,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFVER,FACTINSTID,FISCURRENT,FISROLLBACK,FDATAVALUE  ) SELECT FPROCINSTID,FTIME,FPROCDEFID,FPROCDEFHASH,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFVER,FACTINSTID,FISCURRENT,FISROLLBACK,FDATAVALUE FROM T_WFR_ProcInstData");
            buffer.append(" WHERE");
            buffer.append(" (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_WFR_ActInstHst  (FACTINSTID,FSTATE,FINITED,FPROCINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFHASH,FCOMLETETIME,FLASTSTATETIME,FCREATEDTIME,FTIMEUNIT,FLIMIT,FWORKINGTIME,FWAITTINGTIME,FDURATION,FEXTATTR,FSEQUENCE,FASSIGNOPTION,FACCEPTOPTION,FFROMACTINSTLIST,FPREACTINSTLIST,FISREDO,FTOACTINSTLIST,FPOSTACTINSTLIST,FTRANSED,FSUBPROCINSTID,FPERFORMERLIST,FPROCDEFTYPE,FGroupName,FPRIORITY, fparentactinstid, fdeadlinetime ) SELECT FACTINSTID,FSTATE,FINITED,FPROCINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCDEFHASH,FCOMLETETIME,FLASTSTATETIME,FCREATEDTIME,FTIMEUNIT,FLIMIT,FWORKINGTIME,FWAITTINGTIME,FDURATION,FEXTATTR,FSEQUENCE,FASSIGNOPTION,FACCEPTOPTION,FFROMACTINSTLIST,FPREACTINSTLIST,FISREDO,FTOACTINSTLIST,FPOSTACTINSTLIST,FTRANSED,FSUBPROCINSTID,FPERFORMERLIST,FPROCDEFTYPE,FGroupName,FPRIORITY, fparentactinstid, fdeadlinetime FROM T_WFR_ActInst");
            buffer.append(" WHERE");
            buffer.append("  (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_WFR_AssignHst  (FASSIGNID,FSUBJECT_L1,FSUBJECT_L2,FSUBJECT_L3,FBODY_L1,FBODY_L2,FBODY_L3,FSTATE,FPERSONUSERID,FPERSONUSERNAME_L1,FPERSONUSERNAME_L2,FPERSONUSERNAME_L3,FPERSONEMPID,FPERSONEMPNAME_L1,FPERSONEMPNAME_L2,FPERSONEMPNAME_L3,FPERFORMERUID,FPERFORMERUNAME_L1,FPERFORMERUNAME_L2,FPERFORMERUNAME_L3,FPERFORMEREID,FPERFORMERENAME_L1,FPERFORMERENAME_L2,FPERFORMERENAME_L3,FACTINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFHASH,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCINSTID,FENDTIME,FLASTSTATETIME,FCREATEDTIME,FFORWARDPATH,FEXTATTR,FACCEPTTIME,FBIZPACKAGE,FBIZFUNCTION,FBIZOPERATION,FBIZOBJID,FAPPDEFID,FPRIORITY,FDURATION,FWORKINGTIME,FWAITINGTIME ,FIsSendMsg,FOrgId,FOrgType,FInitiatorName_L1, FInitiatorName_L2,FInitiatorName_L3, FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3,FBILLENTITY,FResponsibleEmpId, FSourceAssignId  )  SELECT FASSIGNID,FSUBJECT_L1,FSUBJECT_L2,FSUBJECT_L3,FBODY_L1,FBODY_L2,FBODY_L3,FSTATE,FPERSONUSERID,FPERSONUSERNAME_L1,FPERSONUSERNAME_L2,FPERSONUSERNAME_L3,FPERSONEMPID,FPERSONEMPNAME_L1,FPERSONEMPNAME_L2,FPERSONEMPNAME_L3,FPERFORMERUID,FPERFORMERUNAME_L1,FPERFORMERUNAME_L2,FPERFORMERUNAME_L3,FPERFORMEREID,FPERFORMERENAME_L1,FPERFORMERENAME_L2,FPERFORMERENAME_L3,FACTINSTID,FACTDEFID,FACTDEFNAME_L1,FACTDEFNAME_L2,FACTDEFNAME_L3,FPROCDEFHASH,FPROCDEFID,FPROCDEFNAME_L1,FPROCDEFNAME_L2,FPROCDEFNAME_L3,FPROCINSTID,FENDTIME,FLASTSTATETIME,FCREATEDTIME,FFORWARDPATH,FEXTATTR,FACCEPTTIME,FBIZPACKAGE,FBIZFUNCTION,FBIZOPERATION,FBIZOBJID,FAPPDEFID,FPRIORITY,FDURATION,FWORKINGTIME,FWAITINGTIME ,FIsSendMsg,FOrgId,FOrgType,FInitiatorName_L1, FInitiatorName_L2,FInitiatorName_L3,FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3,FBILLENTITY,FResponsibleEmpId, FSourceAssignId  FROM T_WFR_AssignDetail");
            buffer.append(" WHERE");
            buffer.append("  (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_WFR_ProcInstRefHst  (fprocinstid, frefid, ftype)  SELECT fprocinstid, frefid, ftype FROM T_WFR_ProcInstRef");
            buffer.append(" WHERE");
            buffer.append("  (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_AssignDetail");
            buffer.append(" WHERE (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ActInst");
            buffer.append(" WHERE (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ProcInstData ");
            buffer.append("WHERE (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ProcInst ");
            buffer.append("WHERE (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ProcInstRef ");
            buffer.append("WHERE (FPROCINSTID IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_ProcessMonitorData ");
            buffer.append("WHERE (fprocinstId IN " + procInstIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getAllCronExpression(Context ctx) throws BOSException {
        try {
            Connection connection = WfDbUtil.getConnection(ctx);
            Statement statement = connection.createStatement();
            String sql = "SELECT B.FPROCDEFID,B.FNAME_L2,A.FDATA FROM T_QTZ_TRIGGERS A INNER JOIN T_WFR_PROCDEF B ON A.FTRIGGERNAME=B.FPROCDEFID";
            ResultSet resultSet = this.executeQuery(sql, statement);
            StringBuffer buffer = new StringBuffer();
            InputStream binaryStream = null;
            ObjectInputStream triggerData = null;
            while (resultSet.next()) {
                String procdefId = resultSet.getString("FPROCDEFID");
                String procdefName = resultSet.getString("FNAME_L2");
                String cronExpression = "";
                try {
                    binaryStream = resultSet.getBinaryStream("FData");
                    triggerData = new ObjectInputStream(binaryStream);
                    CronTrigger trigger = (CronTrigger)triggerData.readObject();
                    cronExpression = trigger.getCronExpression();
                }
                finally {
                    if (triggerData != null) {
                        try {
                            triggerData.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (binaryStream != null) {
                        try {
                            binaryStream.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                buffer.append(procdefId);
                buffer.append("->");
                buffer.append(procdefName);
                buffer.append("->");
                buffer.append(cronExpression);
                buffer.append("\n");
            }
            return buffer.toString();
        }
        catch (ClassNotFoundException e) {
            return "";
        }
        catch (SQLException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    protected void _dumpWfData(Context ctx, int day) throws BOSException {
        day = EngineConfig.getInstance().getProcessInstDumpDays();
        int processInstDumpRecordOfBatch = EngineConfig.getInstance().getProcessInstDumpRecordOfBatch();
        this.dumpWfDataInner(ctx, day, processInstDumpRecordOfBatch);
    }

    protected void dumpWfDataInner(Context ctx, int day, int batchCount) throws BOSException {
        String dumpProcInstIDs;
        long startTime;
        Connection cn;
        block6: {
            cn = null;
            IObjectPK logPk = WorkflowLogUtil.beginLogByLocal((Context)ctx, (WorkflowLogItem)WorkflowLogItem.WORKFLOW_MONITORING_DUMP, (Object)"\u6d41\u7a0b\u5b9e\u4f8b");
            WorkflowLogUtil.endLogByLocal((Context)ctx, (IObjectPK)logPk);
            startTime = System.currentTimeMillis();
            cn = this.getConnection(ctx);
            this.clearDirtyWfDataBatch(cn);
            this.clearDirtyMultiapproveDataBatch(cn);
            dumpProcInstIDs = this.getProcInstIdSet(cn, batchCount, day);
            if (!StringUtils.isEmpty((String)dumpProcInstIDs)) break block6;
            logger.info((Object)"Finish dump Wfdata, total 0 records.");
            SQLUtils.cleanup((Connection)cn);
            return;
        }
        try {
            int count = 0;
            String multiapproveIDs = this.getMultiapproveIdSet(cn, dumpProcInstIDs);
            String counterSignIDs = this.getCounterSignIdSet(cn, dumpProcInstIDs);
            IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance(ctx);
            while (!StringUtils.isEmpty((String)dumpProcInstIDs)) {
                String[] parts = dumpProcInstIDs.split(",");
                count += parts.length;
                delegate.invokeRequiresNew(this.getClass().getName(), this, "dumpWfData", new Class[]{Context.class, String.class, String.class, String.class}, new Object[]{ctx, dumpProcInstIDs, multiapproveIDs, counterSignIDs});
                dumpProcInstIDs = this.getProcInstIdSet(cn, batchCount, day);
                multiapproveIDs = this.getMultiapproveIdSet(cn, dumpProcInstIDs);
                counterSignIDs = this.getCounterSignIdSet(cn, dumpProcInstIDs);
            }
            long endTime = System.currentTimeMillis();
            logger.info((Object)("Finish dump Wfdata, total " + count + "records, cost " + (endTime - startTime) + "ms."));
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)cn);
    }

    public void dumpWfData(Context ctx, String dumpProcInstIDs, String dumpMultiapproveIDs, String counterSignIDs) throws BOSException {
        Connection cn = null;
        try {
            if (dumpProcInstIDs == null || dumpProcInstIDs.length() == 0) {
                return;
            }
            long startTime = System.currentTimeMillis();
            cn = this.getConnection(ctx);
            this.adjustWfDataBatch(cn, dumpProcInstIDs);
            this.adjustMultiapproveDataBatch(cn, dumpMultiapproveIDs);
            this.transferCounterSignDataBatch(cn, counterSignIDs);
            long endTime = System.currentTimeMillis();
            String[] parts = dumpProcInstIDs.split(",");
            int count = parts.length;
            logger.info((Object)("Dump Wfdata " + count + "records , cost " + (endTime - startTime) + "ms."));
            SQLUtils.cleanup((Connection)cn);
        }
        catch (SQLException e) {
            logger.error((Object)"Error dump Wfdata");
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(cn);
        }
    }

    private void adjustMultiapproveDataBatch(Connection cn, String multiapproveIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)multiapproveIdSet)) {
            return;
        }
        this.transferMultiapproveDataBatch(cn, multiapproveIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyMultiapproveDataBatch(Connection cn) throws SQLException {
        String sql = "DELETE T_BAS_MULTIAPPROVEHST WHERE FID IN(SELECT FID FROM T_BAS_MULTIAPPROVE)";
        try (PreparedStatement ps = null;){
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferMultiapproveDataBatch(Connection cn, String multiapproveIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)multiapproveIdSet)) {
            return;
        }
        try (Statement ps = null;){
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_BAS_MultiApproveHst  (FID,FIsPass,FOpinion_L1,FOpinion_L2,FOpinion_L3,FHandlerOption,FHandlerContent,FBillID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FBosType,FControlUnitID,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext, FOrgName_l1,FOrgName_l2,FOrgName_l3,FPositionName_l1,FPositionName_l2,FPositionName_l3,FOrgDisplayName_l1,FOrgDisplayName_l2,FOrgDisplayName_l3,FInputType,FESIGNATUREID) SELECT FID,FIsPass,FOpinion_L1,FOpinion_L2,FOpinion_L3,FHandlerOption,FHandlerContent,FBillID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FBosType,FControlUnitID,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext,FOrgName_l1,FOrgName_l2,FOrgName_l3,FPositionName_l1,FPositionName_l2,FPositionName_l3,FOrgDisplayName_l1,FOrgDisplayName_l2,FOrgDisplayName_l3,FInputType,FESIGNATUREID  FROM T_BAS_MultiApprove");
            buffer.append(" WHERE");
            buffer.append("  (FID IN " + multiapproveIdSet + ")");
            String sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_BAS_MultiApprove");
            buffer.append(" WHERE (FID IN " + multiapproveIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferCounterSignDataBatch(Connection cn, String counterSignIdSet) throws SQLException {
        if (StringUtils.isEmpty((String)counterSignIdSet)) {
            return;
        }
        try (Statement ps = null;){
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO  T_WFR_CounterSignHst  (FID,fcounterSignInitiator,finitiatorName_L1,finitiatorName_L2,finitiatorName_L3,fassignOpinion_L1,fassignOpinion_L2,fassignOpinion_L3,FCREATEDTIME,FASSIGNID) SELECT FID,fcounterSignInitiator,finitiatorName_L1,finitiatorName_L2,finitiatorName_L3,fassignOpinion_L1,fassignOpinion_L2,fassignOpinion_L3,FCREATEDTIME,FASSIGNID FROM T_WFR_CounterSign");
            buffer.append(" WHERE");
            buffer.append("  (FID IN " + counterSignIdSet + ")");
            String sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
            ps.close();
            buffer = new StringBuffer();
            buffer.append("DELETE T_WFR_CounterSign");
            buffer.append(" WHERE (FID IN " + counterSignIdSet + ")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMultiapproveIdSet(Connection cn, String procInstIds) throws SQLException {
        if (cn == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)procInstIds)) {
            return "";
        }
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT");
        buffer.append(" *");
        buffer.append(" FROM T_BAS_MultiApprove");
        buffer.append(" WHERE (");
        buffer.append(" fassignmentid in (");
        buffer.append(" SELECT fassignid");
        buffer.append(" FROM T_WFR_ASSIGNDETAIL");
        buffer.append(" WHERE (");
        buffer.append(" fprocinstid in " + procInstIds + ")");
        buffer.append("))");
        sql = buffer.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = cn.prepareStatement(sql);
            rs = ps.executeQuery();
            String multiapproveIds = "";
            StringBuffer buffer2 = new StringBuffer();
            while (rs.next()) {
                String multiapproveId = rs.getString("FID");
                if (buffer2.length() > 0) {
                    buffer2.append("','");
                }
                buffer2.append(multiapproveId);
            }
            multiapproveIds = buffer2.toString();
            String multiapproveIdSet = "";
            if (!"".equals(multiapproveIds)) {
                StringBuffer buffer3 = new StringBuffer();
                buffer3.append("('");
                buffer3.append(multiapproveIds);
                buffer3.append("')");
                multiapproveIdSet = buffer3.toString();
            }
            logger.debug((Object)("\"multiapproveIdSet\" is \"" + multiapproveIdSet + "\"!"));
            String string = multiapproveIdSet;
            return string;
        }
        finally {
            rs.close();
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCounterSignIdSet(Connection cn, String procInstIds) throws SQLException {
        if (cn == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)procInstIds)) {
            return "";
        }
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT");
        buffer.append(" *");
        buffer.append(" FROM T_WFR_CounterSign");
        buffer.append(" WHERE (");
        buffer.append(" FASSIGNID in (");
        buffer.append(" SELECT fassignid");
        buffer.append(" FROM T_WFR_ASSIGNDETAIL");
        buffer.append(" WHERE (");
        buffer.append(" fprocinstid in " + procInstIds + ")");
        buffer.append("))");
        sql = buffer.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = cn.prepareStatement(sql);
            rs = ps.executeQuery();
            String counterSignIds = "";
            StringBuffer buffer2 = new StringBuffer();
            while (rs.next()) {
                String counterSignId = rs.getString("FID");
                if (buffer2.length() > 0) {
                    buffer2.append("','");
                }
                buffer2.append(counterSignId);
            }
            counterSignIds = buffer2.toString();
            String counterSignIdSet = "";
            if (!"".equals(counterSignIds)) {
                StringBuffer buffer3 = new StringBuffer();
                buffer3.append("('");
                buffer3.append(counterSignIds);
                buffer3.append("')");
                counterSignIdSet = buffer3.toString();
            }
            logger.debug((Object)("\"multiapproveIdSet\" is \"" + counterSignIdSet + "\"!"));
            String string = counterSignIdSet;
            return string;
        }
        finally {
            rs.close();
            ps.close();
        }
    }
}

