/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.metas.AbstractAutoFixProcControllerBean;
import com.kingdee.bos.workflow.monitor.AutoFixRecordFactory;
import com.kingdee.bos.workflow.monitor.AutoFixRecordInfo;
import com.kingdee.bos.workflow.monitor.app.FixResult;
import com.kingdee.bos.workflow.monitor.app.FixType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoFixProcControllerBean
extends AbstractAutoFixProcControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.AutoFixProcControllerBean");

    @Override
    protected int _autoFix(Context ctx, int day) throws BOSException {
        if (day == 0) {
            day = 1;
        }
        if (day > 30) {
            day = 30;
        }
        this.deleteSomeRecord(ctx);
        Timestamp ts = new Timestamp(System.currentTimeMillis() - (long)(day * 24 * 60 * 60) * 1000L);
        this.updateNextId(ctx);
        int seqId = this.getNextId(ctx);
        String procBuilder = this.fixWfBgJob(ctx, ts, seqId);
        this.doResumeProcInst(ctx, ts, procBuilder, seqId);
        return 0;
    }

    private void deleteSomeRecord(Context ctx) {
        try {
            String sql = "select fid from t_wfr_fixrecord order by ffixtime desc";
            ArrayList ids = SQL.executeQuery((Context)ctx, (String)sql);
            if (ids.size() < 500) {
                return;
            }
            StringBuilder idStr = new StringBuilder();
            int size = ids.size() - 500;
            for (int i = 0; i < size; ++i) {
                String id = (String)((Map)ids.get(i)).get("fid");
                idStr.append("'" + id + "',");
            }
            idStr.setLength(idStr.length() - 1);
            sql = "delete from t_wfr_fixrecord where fid in(" + idStr + ")";
            SQL.executeUpdate((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.error((Object)"AutoFixProcControllerBean deleteSomeRecord error", (Throwable)e);
        }
    }

    private void doResumeProcInst(Context ctx, Timestamp ts, String procBuilder, int seqId) throws BOSException {
        String sql = "select p.fprocinstid as id,p.fprocinstid as procinstId,p.FPROCDEFNAME_L2 as name,p.FPROCINSTTOPIC_L2 as topic from t_wfr_procinst p where p.fstate ='open.not_running.suspended' and p.flaststatetime > ?  and p.fprocinstid not in (select d.FPROCINSTID from t_wfr_dynamicop d where ftype='suspend' and d.FCREATETIME >?) ";
        if (procBuilder.length() > 0) {
            sql = sql + " and p.fprocinstid not in(" + procBuilder + ")";
        }
        sql = sql + "  order by p.fcreatedtime desc";
        int[] types = new int[]{93, 93};
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])new Object[]{ts, ts});
        if (list.size() > 0) {
            this.innerRecord(ctx, null, list, seqId, FixType.Resume);
            IEnactmentService enact = EnactmentServiceFactory.createEnactService(ctx);
            for (Object obj : list) {
                String id = (String)((Map)obj).get("id");
                enact.resumeProcessInst(id);
            }
        }
    }

    private String fixWfBgJob(Context ctx, Timestamp ts, int seqId) throws BOSException {
        HashMap<String, String> procIdMap = new HashMap<String, String>();
        HashMap mulIdMap = new HashMap();
        HashMap billIdMap = new HashMap();
        StringBuilder procBuilder = new StringBuilder();
        StringBuilder mulBuilder = new StringBuilder();
        StringBuilder billIdBuilder = new StringBuilder();
        String sql = "select fjobinstid,fexception,ftitle from t_job_inst where fjobtype ='WfJobs' and fstate = 'Failed' and fscheduledtime > ? order by fcreatedtime desc";
        int[] types = new int[]{93};
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])new Object[]{ts});
        if (list.size() > 0) {
            String[] ids = new String[list.size()];
            int i = 0;
            for (Object obj : list) {
                String id = (String)((Map)obj).get("fjobinstid");
                String ex = (String)((Map)obj).get("fexception");
                ids[i++] = id;
                if (!id.endsWith("WFPCINST")) continue;
                procIdMap.put(id, ex);
                procBuilder.append("'" + id + "',");
            }
            if (procBuilder.length() > 0) {
                procBuilder.setLength(procBuilder.length() - 1);
                sql = "select fprocinstid as id,fprocinstid as procinstId,FPROCDEFNAME_L2 as name,FPROCINSTTOPIC_L2 as topic from t_wfr_procinst where fprocinstid in(" + procBuilder.toString() + ")";
                this.doRecord(ctx, sql, procIdMap, seqId, FixType.FixBgJob);
            }
            if (ids.length > 0) {
                JobServiceFactory.getLocalInstance((Context)ctx).restart(ids);
            }
        }
        return procBuilder.toString();
    }

    private void doRecord(Context ctx, String sql, Map<String, String> idMap, int seqId, FixType fixType) throws BOSException {
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
        this.innerRecord(ctx, idMap, list, seqId, fixType);
    }

    private void innerRecord(Context ctx, Map<String, String> idMap, List list, int seqId, FixType fixType) throws BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (Object obj : list) {
            AutoFixRecordInfo info = new AutoFixRecordInfo();
            info.setFixid(seqId + "");
            info.setProcdefname((String)((Map)obj).get("name"));
            info.setProctopic((String)((Map)obj).get("topic"));
            String pId = (String)((Map)obj).get("id");
            info.setJobinstid(pId);
            if (idMap == null) {
                info.setException("\u6d41\u7a0b\u5f02\u5e38");
            } else {
                info.setException(idMap.get(pId));
            }
            info.setFixtype(fixType);
            info.setResult(FixResult.FIXING);
            info.setFixtime(new Timestamp(System.currentTimeMillis()));
            info.setProcinstid((String)((Map)obj).get("procinstid"));
            colls.add((CoreBaseInfo)info);
        }
        try {
            AutoFixRecordFactory.getLocalInstance((Context)ctx).addnewBatchData(colls);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int getNextId(Context ctx) throws BOSException {
        String sql = "select id from t_wfr_fixrecordnextid";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
        if (list.size() == 0) {
            sql = "insert into t_wfr_fixrecordnextid values(1)";
            SQL.executeUpdate((Context)ctx, (String)sql);
            return 1;
        }
        BigDecimal id = (BigDecimal)((Map)list.get(0)).get("id");
        return id.intValue();
    }

    private void updateNextId(Context ctx) throws BOSException {
        String sql = "select id from t_wfr_fixrecordnextid";
        ArrayList list = SQL.executeQuery((Context)ctx, (String)sql);
        if (list.size() == 0) {
            sql = "insert into t_wfr_fixrecordnextid values(1)";
            SQL.executeUpdate((Context)ctx, (String)sql);
        } else {
            sql = "update t_wfr_fixrecordnextid set id = (id+1)";
            SQL.executeUpdate((Context)ctx, (String)sql);
        }
    }
}

