/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.AbstractOtherSysTaskControllerBean;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.OtherSysTaskInfo;
import com.kingdee.bos.workflow.metas.OtherSysTaskState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class OtherSysTaskControllerBean
extends AbstractOtherSysTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.OtherSysTaskControllerBean");

    @Override
    protected void _callback(Context ctx, String taskId, String result) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(taskId);
        OtherSysTaskInfo model = this.getValue(ctx, (IObjectPK)pk);
        model.setReturnVal(result);
        model.setTaskState(OtherSysTaskState.FINISH);
        model.setLaststatetime(new Timestamp(System.currentTimeMillis()));
        this.update(ctx, (IObjectPK)pk, model);
        this.saveOperation(ctx, model.getActinstId(), model.getProcinstId());
    }

    private void saveOperation(Context ctx, String actinstId, String procinstId) {
        try {
            WfEngine wfEngine = WfEngine.getEngine((Context)ctx);
            WfActivity actinst = wfEngine.getActivityInst(actinstId);
            WfProcess procinst = wfEngine.getProcessInst(procinstId);
            IOption Wfoption = OptionFactory.getLocalInstance(ctx);
            OptionInfo opinfo = new OptionInfo();
            opinfo.setOption(null);
            opinfo.setBillID(BOSUuid.read((String)procinst.getBizObjIds()[0]));
            opinfo.setType(OptionType.automate);
            opinfo.setPersonID(BOSUuid.read((String)ctx.getCaller().toString()));
            opinfo.setNextHandlerPersonID(null);
            opinfo.setAssignmentID(null);
            opinfo.setNextAssignid(null);
            opinfo.setCurrentAcinstID(BOSUuid.read((String)actinstId));
            opinfo.setActinstID(null);
            opinfo.setResult("\u6210\u529f");
            opinfo.setProcinstID(BOSUuid.read((String)procinstId));
            opinfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            Wfoption.addnew(opinfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u4fdd\u5b58\u673a\u5668\u4eba\u8282\u70b9\u64cd\u4f5c\u8bb0\u5f55\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _recordErrorInfo(Context ctx, String taskID, String errorInfo) throws BOSException {
        OtherSysTaskInfo model = null;
        try {
            ObjectUuidPK pk = new ObjectUuidPK(taskID);
            model = this.getValue(ctx, (IObjectPK)pk);
            model.setErrorInfo(errorInfo);
            model.setTaskState(OtherSysTaskState.ERR_STOP);
            model.setLaststatetime(new Timestamp(System.currentTimeMillis()));
            this.update(ctx, (IObjectPK)pk, model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            logger.error((Object)("recordErrorInfo().taskID:" + taskID));
            if (null != model) {
                IEnactmentService service = EnactmentServiceFactory.createEnactService(ctx);
                service.suspendActInst(model.getActinstId());
            }
        }
    }
}

