/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ProcessHeaderDef;
import com.kingdee.bos.workflow.metas.AbstractProcDefInfo;
import com.kingdee.bos.workflow.metas.PublishPlatformEnum;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Locale;

public class ProcDefInfo
extends AbstractProcDefInfo
implements Serializable {
    public ProcDefInfo() {
        super(null);
    }

    protected ProcDefInfo(String pkField) {
        super(pkField);
    }

    public static ProcDefInfo convertFromWfModel(ProcessDef prcsDef, Locale[] lcls) {
        if (prcsDef == null || lcls == null || lcls.length == 0) {
            throw new IllegalArgumentException();
        }
        ProcessHeaderDef processHeaderDef = prcsDef.getProcessHeader();
        ProcDefInfo procDefInfo = new ProcDefInfo();
        for (int i = 0; i <= lcls.length - 1; ++i) {
            Locale lcl = lcls[i];
            procDefInfo.setName(prcsDef.getName(lcl), lcl);
            procDefInfo.setDescription(processHeaderDef.getDescription(lcl), lcl);
            procDefInfo.setBizPackage(processHeaderDef.getBizPackage(lcl), lcl);
        }
        procDefInfo.setProcCode(prcsDef.getCode());
        procDefInfo.setProcdefID(BOSUuid.read((String)prcsDef.getID()));
        procDefInfo.setCreatedTime(new Timestamp(System.currentTimeMillis()));
        procDefInfo.setAuthor(processHeaderDef.getAuthor());
        String rspnID = processHeaderDef.getResponsibles().getIDListString();
        procDefInfo.setResponsibleID(rspnID);
        String rspnName = processHeaderDef.getResponsibles().getNameListString();
        procDefInfo.setResponsibleName(rspnName);
        procDefInfo.setValidFrom(new Timestamp(processHeaderDef.getValidFrom().getTime()));
        procDefInfo.setValidTo(new Timestamp(processHeaderDef.getValidTo().getTime()));
        procDefInfo.setVerDesc(processHeaderDef.getVersion());
        procDefInfo.setStartActID(BOSUuid.read((String)prcsDef.getStartActivity().getID()));
        procDefInfo.setPackageName(processHeaderDef.getPackageName());
        procDefInfo.setProcdefType(prcsDef.getType().getName());
        if (prcsDef.getAbstract() != null) {
            procDefInfo.setAbstractContent(prcsDef.getAbstract().getContent());
            procDefInfo.setAbstractType(prcsDef.getAbstract().getType());
        }
        if (prcsDef.getExtendedAttributes().get("publish_by_webDesigner") != null) {
            procDefInfo.setPublishPlatform(PublishPlatformEnum.wbos_wfdesigner);
        } else {
            procDefInfo.setPublishPlatform(PublishPlatformEnum.BOS);
        }
        return procDefInfo;
    }

    public String getProcdefID_Ex() {
        return this.getProcdefID().toString();
    }

    public void setProcdefID_Ex(String item) {
        this.setProcdefID(BOSUuid.read((String)item));
    }

    public String getStartActID_Ex() {
        return this.getStartActID().toString();
    }

    public void setStartActID_Ex(String item) {
        this.setStartActID(BOSUuid.read((String)item));
    }

    public String getKpdl_Ex() {
        if (!StringUtils.isEmpty((String)this.getKpdl())) {
            return new String(this.getKpdl());
        }
        return null;
    }

    public void setKpdl_Ex(String item) {
        this.setKpdl(item);
    }

    public String getAbstractContent() {
        return this.getString("abstractContent");
    }

    public void setAbstractContent(String content) {
        this.setString("abstractContent", content);
    }

    public int getAbstractType() {
        return this.getInt("abstractType");
    }

    public void setAbstractType(int type) {
        this.setInt("abstractType", type);
    }
}

