/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.extscheme.procdiagram.service.ProcDiagramService;
import com.kingdee.bos.workflow.metas.AbstractSAProcessDATASyncFacadeControllerBean;
import com.kingdee.bos.workflow.statsa.caldate.SAWorkCalendarUtil;
import com.kingdee.bos.workflow.statsa.service.SAProcessDATASyncService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAProcessDATASyncFacadeControllerBean
extends AbstractSAProcessDATASyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.SAProcessDATASyncFacadeControllerBean");
    private static final int BATCH = 500;

    @Override
    protected boolean _saSync(Context ctx, int day) throws BOSException {
        SAProcessDATASyncService tSAProcessDATASyncService = new SAProcessDATASyncService();
        return tSAProcessDATASyncService.saSync(ctx, false, day);
    }

    @Override
    protected boolean _saSyncReExtract(Context ctx, boolean isReExtract, int day) throws BOSException {
        SAProcessDATASyncService tSAProcessDATASyncService = new SAProcessDATASyncService();
        return tSAProcessDATASyncService.saSync(ctx, isReExtract, day);
    }

    @Override
    protected boolean _existWorkCalendar(Context ctx, int day) throws BOSException {
        return SAWorkCalendarUtil.existWorkCalendar((Context)ctx, (int)day);
    }

    @Override
    protected void _gatherProcessMonitorData(Context ctx) throws BOSException {
        try {
            HashMap<String, Timestamp> lastStateMap = new HashMap<String, Timestamp>();
            String sql = " select fprocinstId procinstId,FLASTSTATETIME lastStateTime from  T_WFR_ProcessMonitorData ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String procinstId = rs.getString(1);
                Timestamp lastStateTime = rs.getTimestamp(2);
                lastStateMap.put(procinstId, lastStateTime);
            }
            Map<String, Map<String, Object>> timeoutDataMap = this.getTimeoutDataMap(ctx);
            sql = " select a.fprocinstId procinstId,a.FPROCDEFID procdefId,b.FLASTUPDATEDTIME lastStateTime,a.fstate state,flaststatetime endTime from t_wfr_procinst a left join t_wfr_runtime b on a.fprocinstId=b.FPROCINSTID ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateParamList2 = new ArrayList<Object[]>();
            int i = 0;
            while (rs.next()) {
                String procinstId = rs.getString("procinstId");
                String procdefId = rs.getString("procdefId");
                Timestamp curStateTime = rs.getTimestamp("lastStateTime");
                Timestamp endTime = rs.getTimestamp("endTime");
                boolean closed = rs.getString("state").startsWith("closed");
                if (curStateTime == null && closed) {
                    curStateTime = endTime;
                }
                int progress = -2;
                String progressDetail = null;
                Timestamp lastStateTime = (Timestamp)lastStateMap.get(procinstId);
                if (lastStateTime == null || curStateTime == null || curStateTime.after(lastStateTime)) {
                    try {
                        ProcDiagramService procDiagramService = new ProcDiagramService(ctx);
                        Map ret = procDiagramService.calProcessProgress(procdefId, procinstId);
                        progress = (Integer)ret.get("progress");
                        progressDetail = (String)ret.get("detail");
                        if (curStateTime == null) {
                            curStateTime = new Timestamp(System.currentTimeMillis());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        progress = -1;
                    }
                }
                boolean isTimeout = false;
                String timeoutDef = null;
                if (!closed) {
                    timeoutDef = this.getTimeoutDef(ctx, procinstId, timeoutDataMap);
                    boolean bl = isTimeout = !StringUtils.isEmpty((String)timeoutDef);
                }
                if (lastStateMap.containsKey(procinstId)) {
                    Object[] updateParams = null;
                    if (progress != -2) {
                        updateParams = new Object[]{isTimeout, timeoutDef, progress, progressDetail, curStateTime, procinstId};
                        updateParamList.add(updateParams);
                    } else {
                        updateParams = new Object[]{isTimeout, timeoutDef, procinstId};
                        updateParamList2.add(updateParams);
                    }
                } else {
                    Object[] insertParams = new Object[]{procinstId, procdefId, progress, progressDetail, isTimeout, timeoutDef, curStateTime};
                    insertParamList.add(insertParams);
                }
                if (++i != 500) continue;
                DbUtil.executeBatch((Context)ctx, (String)"insert into T_WFR_ProcessMonitorData (FProcinstId,FProcdefId,FProgress,FProgressDetail,FIsTimeout,FTimeoutDef,FLastStateTime) values (?,?,?,?,?,?,?) ", insertParamList);
                DbUtil.executeBatch((Context)ctx, (String)"update T_WFR_ProcessMonitorData set FIsTimeout=?,FTimeoutDef=?, FProgress=?,FProgressDetail=?,FLastStateTime=? where FProcinstId=? ", updateParamList);
                DbUtil.executeBatch((Context)ctx, (String)"update T_WFR_ProcessMonitorData set FIsTimeout=?,FTimeoutDef=? where FProcinstId=? ", updateParamList2);
                i = 0;
                insertParamList = new ArrayList();
                updateParamList = new ArrayList();
                updateParamList2 = new ArrayList();
            }
            if (i > 0) {
                DbUtil.executeBatch((Context)ctx, (String)"insert into T_WFR_ProcessMonitorData (FProcinstId,FProcdefId,FProgress,FProgressDetail,FIsTimeout,FTimeoutDef,FLastStateTime) values (?,?,?,?,?,?,?) ", insertParamList);
                DbUtil.executeBatch((Context)ctx, (String)"update T_WFR_ProcessMonitorData set FIsTimeout=?,FTimeoutDef=?,FProgress=?,FProgressDetail=?,FLastStateTime=? where FProcinstId=? ", updateParamList);
                DbUtil.executeBatch((Context)ctx, (String)"update T_WFR_ProcessMonitorData set FIsTimeout=?,FTimeoutDef=? where FProcinstId=? ", updateParamList2);
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }

    private Map<String, Map<String, Object>> getTimeoutDataMap(Context ctx) throws BOSException {
        HashMap<String, Map<String, Object>> timeoutDataMap = new HashMap<String, Map<String, Object>>();
        try {
            String sql = " select fid procdefId,fOvertime overtime,fUnit unit,fUseCalendar useCalendar,FCalendarOrganization orgId from  T_WFR_OvertimeManagement where FOVERTIME>0 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                HashMap<String, Object> timeoutData = new HashMap<String, Object>();
                String procdefId = rs.getString("procdefId");
                long overtime = rs.getInt("overtime");
                int unit = rs.getInt("unit");
                if (unit == 1) {
                    overtime *= 60L;
                } else if (unit == 2) {
                    overtime = overtime * 60L * 60L;
                } else if (unit == 3) {
                    overtime = overtime * 60L * 60L * 24L;
                }
                timeoutData.put("timeout", overtime * 1000L);
                int useCalendar = rs.getInt("useCalendar");
                if (useCalendar == 1) {
                    timeoutData.put("orgId", rs.getString("orgId"));
                }
                timeoutDataMap.put(procdefId, timeoutData);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return timeoutDataMap;
    }

    private String getTimeoutDef(Context ctx, String procinstId, Map<String, Map<String, Object>> timeoutDataMap) {
        block6: {
            try {
                String sql = "select top 1 FPROCDEFID procdefId,FCREATEDTIME createdTime from  t_wfr_actinst where FPROCINSTID =? and FSTATE like 'open%' order by  FCREATEDTIME";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{procinstId});
                if (!rs.next()) break block6;
                long timeout = 86400000L;
                Date nowDate = new Date();
                String procdefId = rs.getString("procdefId");
                Map<String, Object> timeoutData = timeoutDataMap.get(procdefId);
                if (timeoutData != null) {
                    timeout = (Long)timeoutData.get("timeout");
                }
                Timestamp createdTime = rs.getTimestamp("createdTime");
                long time = 0L;
                try {
                    BigDecimal spent = SAWorkCalendarUtil.calExecuteTime((Context)ctx, (Date)createdTime, (Date)nowDate, null);
                    time = spent.longValue() * 1000L * 60L;
                }
                catch (BOSException e) {
                    time = nowDate.getTime() - createdTime.getTime();
                }
                if (time > timeout) {
                    String executeTime = "";
                    long h = timeout / 3600000L;
                    executeTime = h > 0L ? h + "h" : timeout / 60000L + "min";
                    return executeTime;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

