/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.AbstractWfIntegrationControllerBean;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignDetailCollection;
import com.kingdee.bos.workflow.metas.AssignDetailFactory;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.store.WorkItemStorer;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfIntegrationControllerBean
extends AbstractWfIntegrationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.WfIntegrationControllerBean");
    private static final String STATE_ASSIGNED = "assigned";
    private static final String STATE_HANDLED = "handled";
    private static final String STATE_REMOVED = "removed";
    private static final String PLACEHOLDER = " ";

    @Override
    protected void _addAssign(Context ctx, Map otherAssignData) throws BOSException {
        if (otherAssignData == null || otherAssignData.isEmpty()) {
            throw new BOSException("\u7b2c\u4e09\u65b9\u5f85\u529e\u6570\u636e  otherAssignData \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String assignId = (String)otherAssignData.get("assignId");
        if (StringUtils.isEmpty((String)assignId)) {
            throw new BOSException("assignId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String otherType = (String)otherAssignData.get("otherType");
        if (StringUtils.isEmpty((String)otherType)) {
            throw new BOSException("otherType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AssignInfo assignInfo = new AssignInfo();
        String actDefId = this.getPlaceHolderFieldValue(otherAssignData, "actDefId", PLACEHOLDER);
        String actInstId = this.getPlaceHolderFieldValue(otherAssignData, "actInstId", PLACEHOLDER);
        String procDefId = this.getPlaceHolderFieldValue(otherAssignData, "procDefId", PLACEHOLDER);
        String procInstId = this.getPlaceHolderFieldValue(otherAssignData, "procInstId", PLACEHOLDER);
        String procDefHash = this.getPlaceHolderFieldValue(otherAssignData, "procDefHash", PLACEHOLDER);
        String forwardPath = this.getPlaceHolderFieldValue(otherAssignData, "forwardPath", PLACEHOLDER);
        assignInfo.put("actdefID", actDefId);
        assignInfo.put("actInstID", actInstId);
        assignInfo.put("procdefID", procDefId);
        assignInfo.put("procInstID", procInstId);
        assignInfo.setProcdefhash(procDefHash);
        assignInfo.setForwardPath(forwardPath);
        String userId = ctx.getCaller().toString();
        String userName = this.getPlaceHolderFieldValue(otherAssignData, "userName", null);
        String personId = this.getPlaceHolderFieldValue(otherAssignData, "personId", null);
        String personName = this.getPlaceHolderFieldValue(otherAssignData, "personName", null);
        String subject = this.getPlaceHolderFieldValue(otherAssignData, "subject", null);
        String body = this.getPlaceHolderFieldValue(otherAssignData, "body", null);
        String billId = this.getPlaceHolderFieldValue(otherAssignData, "billId", null);
        assignInfo.setOtherType(otherType);
        assignInfo.put("personUserID", userId);
        assignInfo.put("personEmpID", personId);
        assignInfo.setPersonUserName(userName);
        assignInfo.setPersonEmpName(personName);
        assignInfo.setSubject(subject, new Locale("l1"));
        assignInfo.setSubject(subject, new Locale("l2"));
        assignInfo.setSubject(subject, new Locale("l3"));
        assignInfo.setBody(body, new Locale("l1"));
        assignInfo.setBody(body, new Locale("l2"));
        assignInfo.setBody(body, new Locale("l3"));
        assignInfo.setBizObjID(billId);
        assignInfo.setIsSendMsg(true);
        assignInfo.setState(WfAssignmentState.ASSIGNED);
        Timestamp createdTime = null;
        Object createdTimestamp = otherAssignData.get("createdTime");
        createdTime = createdTimestamp != null ? new Timestamp(TypeConversionUtils.objToLong(createdTimestamp)) : new Timestamp(System.currentTimeMillis());
        assignInfo.setCreatedTime(createdTime);
        assignInfo.setLastStateTime(createdTime);
        if (BOSUuid.isValid((String)assignId, (boolean)true) && assignId.endsWith("WFWKITEM")) {
            assignInfo.setAssignID(BOSUuid.read((String)assignId));
        } else {
            AssignCollection collection = this.getAssignByBillIdAndOtherType(ctx, assignId, otherType);
            if (collection.size() > 0) {
                throw new BOSException("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "],\u5df2\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u63a8\u9001\u8fc7\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            assignInfo.setBizObjID(assignId);
        }
        String destAssignId = AssignFactory.getLocalInstance(ctx).addnew(assignInfo).toString();
        AssignReadInfo assignReadInfo = new AssignReadInfo();
        assignReadInfo.setStatus(MsgStatus.UNREADED);
        assignReadInfo.setAssignID(BOSUuid.read((String)destAssignId));
        assignReadInfo.setIsWebSupport(true);
        try {
            AssignReadFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)assignReadInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("WfIntegrationControllerBean.addAssign \u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "],EAS\u4efb\u52a1 [" + destAssignId + "] \u6dfb\u52a0\u6210\u529f!"));
    }

    @Override
    protected void _handleAssign(Context ctx, String assignId, String otherType, Long endTime, Boolean dumpToAssignDetail) throws BOSException {
        if (StringUtils.isEmpty((String)assignId)) {
            throw new BOSException("assignId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)otherType)) {
            throw new BOSException("otherType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String srcAssignId = assignId;
        if (!assignId.endsWith("WFWKITEM")) {
            AssignCollection collection = this.getAssignByBillIdAndOtherType(ctx, assignId, otherType);
            if (collection.size() == 0) {
                throw new BOSException("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "] \u5bf9\u5e94\u7684\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728\uff01");
            }
            assignId = collection.get(0).getAssignID().toString();
            if (collection.size() > 1) {
                logger.info((Object)("WfIntegrationControllerBean.handleAssign \u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "] \u5b58\u5728\u591a\u6761\u5f85\u529e\uff0c\u53ef\u80fd\u5df2\u63a8\u9001\u591a\u6b21\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
        }
        IAssign assign = AssignFactory.getLocalInstance(ctx);
        ObjectStringPK assignPk = new ObjectStringPK(assignId);
        if (dumpToAssignDetail != null && dumpToAssignDetail.booleanValue()) {
            AssignInfo assignInfo = new AssignInfo();
            assignInfo.setAssignID(BOSUuid.read((String)assignId));
            Timestamp endTimestamp = null;
            endTimestamp = endTime != null ? new Timestamp(endTime) : new Timestamp(System.currentTimeMillis());
            assignInfo.setState(WfAssignmentState.COMPLETED);
            assignInfo.setEndTime(endTimestamp);
            assign.update((IObjectPK)assignPk, assignInfo);
            WfEngine engine = WfEngine.getEngine((Context)ctx);
            WorkItemStorer storer = engine.getStoreManager().getWorkItemStorer();
            HashSet<String> assignIds = new HashSet<String>();
            assignIds.add(assignId);
            storer.dumpTx(assignIds, false);
        } else {
            assign.delete((IObjectPK)assignPk);
        }
        try {
            AssignReadFactory.getLocalInstance((Context)ctx).delete("where assignID='" + assignId + "'");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("WfIntegrationControllerBean.handleAssign \u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + srcAssignId + "],EAS\u4efb\u52a1 [" + assignId + "] \u79fb\u9664\u6210\u529f!"));
    }

    @Override
    protected String _getAssignState(Context ctx, String assignId, String otherType) throws BOSException {
        if (StringUtils.isEmpty((String)assignId)) {
            throw new BOSException("assignId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)otherType)) {
            throw new BOSException("otherType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String result = STATE_REMOVED;
        if (BOSUuid.isValid((String)assignId, (boolean)true) && assignId.endsWith("WFWKITEM")) {
            ObjectStringPK assignPk = new ObjectStringPK(assignId);
            boolean exists = AssignFactory.getLocalInstance(ctx).exists((IObjectPK)assignPk);
            if (exists) {
                result = STATE_ASSIGNED;
            } else {
                exists = AssignDetailFactory.getLocalInstance(ctx).exists((IObjectPK)assignPk);
                if (exists) {
                    result = STATE_HANDLED;
                }
            }
        } else {
            AssignCollection collection = this.getAssignByBillIdAndOtherType(ctx, assignId, otherType);
            if (collection.size() == 0) {
                AssignDetailCollection collection2 = this.getAssignDetailByBillIdAndOtherType(ctx, assignId, otherType);
                if (collection2.size() == 1) {
                    result = STATE_HANDLED;
                } else if (collection2.size() > 1) {
                    logger.info((Object)("WfIntegrationControllerBean.getAssignState \u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "] \u5b58\u5728\u591a\u6761\u5f85\u529e\uff0c\u53ef\u80fd\u5df2\u63a8\u9001\u591a\u6b21\uff0c\u8bf7\u68c0\u67e5\uff01"));
                }
            } else if (collection.size() == 1) {
                result = STATE_ASSIGNED;
            } else if (collection.size() > 1) {
                logger.info((Object)("WfIntegrationControllerBean.getAssignState \u7b2c\u4e09\u65b9\u7cfb\u7edf\u4efb\u52a1 [" + assignId + "] \u5b58\u5728\u591a\u6761\u5f85\u529e\uff0c\u53ef\u80fd\u5df2\u63a8\u9001\u591a\u6b21\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
        }
        return result;
    }

    private AssignCollection getAssignByBillIdAndOtherType(Context ctx, String billId, String otherType) throws BOSException {
        return (AssignCollection)this.getAssignByBillIdAndOtherTypeInner(ctx, billId, otherType, "assign");
    }

    private AssignDetailCollection getAssignDetailByBillIdAndOtherType(Context ctx, String billId, String otherType) throws BOSException {
        return (AssignDetailCollection)this.getAssignByBillIdAndOtherTypeInner(ctx, billId, otherType, "detail");
    }

    private AbstractObjectCollection getAssignByBillIdAndOtherTypeInner(Context ctx, String billId, String otherType, String type) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("otherType", (Object)otherType));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("assignID");
        viewInfo.setSelector(selector);
        if ("assign".equals(type)) {
            return AssignFactory.getLocalInstance(ctx).getCollection(viewInfo);
        }
        return AssignDetailFactory.getLocalInstance(ctx).getCollection(viewInfo);
    }

    private String getPlaceHolderFieldValue(Map otherAssignData, String filedName, String placeholder) {
        String ret = (String)otherAssignData.get(filedName);
        if (StringUtils.isEmpty((String)ret)) {
            return placeholder;
        }
        return ret;
    }
}

