/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.metas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.workflow.metas.AbstractWfLogGatherControllerBean;
import com.kingdee.bos.workflow.metas.FileItem;
import com.kingdee.bos.workflow.metas.IWfLogGather;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class WfLogGatherControllerBean
extends AbstractWfLogGatherControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.workflow.metas.WfLogGatherControllerBean");
    private static final String[] LOG_TYPES = new String[]{"apusic", "workflow", "workflowbsmessage", "workflowmultiapprove", "scheduler"};
    private static final long MAX_ZIP_SIZE = 0x3200000L;
    private static final long MAX_SIZE = 1572864000L;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String EAS_HOME = System.getProperty("EAS_HOME");
    private static final String SPLIT_CHAR = ",";
    private static final Semaphore semaphore = new Semaphore(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] _getLogFileStream(Context ctx, Date fromDate, Date toDate, String serverKey, String logType) throws BOSException {
        if (fromDate == null) {
            throw new BOSException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> logTypes = new ArrayList<String>();
        if (StringUtils.isEmpty((String)logType)) {
            logTypes.add("workflow");
            logTypes.add("workflowmultiapprove");
            logTypes.add("workflowbsmessage");
        } else {
            String[] arr;
            for (String item : arr = logType.split(SPLIT_CHAR)) {
                if (!this.isLegal(item)) continue;
                logTypes.add(item);
            }
        }
        try {
            byte[] byArray;
            byte[] ret = null;
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new BOSException((Throwable)e);
            }
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            if (StringUtils.isEmpty((String)serverKey)) {
                RPCServerView sv = RPCServerView.getLast();
                if (sv == null) {
                    String[] serverNames;
                    File profilesPath = new File(EAS_HOME + FILE_SEPARATOR + "server" + FILE_SEPARATOR + "profiles");
                    for (String serverName : serverNames = profilesPath.list()) {
                        ret = this.getLocalLogFileStream(ctx, fromDate, toDate, logTypes, serverName);
                        if (ret == null) continue;
                        list.add(ret);
                    }
                } else {
                    IRPCServer[] ss = sv.getServers();
                    for (int i = 0; i < ss.length; ++i) {
                        IRPCServer s = ss[i];
                        if (s.connectionFailed()) continue;
                        String url = s.getUrl();
                        if (StringUtils.isEmpty((String)url) || this.isLocal(url)) {
                            ret = this.getLocalLogFileStream(ctx, fromDate, toDate, logTypes, s.getName());
                        } else {
                            String newServerKey = s.getName() + "@" + url.replace("tcp://", "");
                            ret = this.getRemoteLogFileStream(url, fromDate, toDate, logType, newServerKey);
                        }
                        if (ret == null) continue;
                        list.add(ret);
                    }
                }
            } else {
                String[] serverKeys;
                for (String newServerKey : serverKeys = serverKey.split(SPLIT_CHAR)) {
                    String[] temp = newServerKey.split("@");
                    String serverName = temp[0];
                    String url = "tcp://" + temp[1];
                    ret = this.isLocal(url) ? this.getLocalLogFileStream(ctx, fromDate, toDate, logTypes, serverName) : this.getRemoteLogFileStream(url, fromDate, toDate, logType, newServerKey);
                    if (ret == null) continue;
                    list.add(ret);
                }
            }
            if (list.size() == 0) {
                byArray = null;
                return byArray;
            }
            if (list.size() == 1) {
                byArray = (byte[])list.get(0);
                return byArray;
            }
            byArray = this.combineData(list);
            return byArray;
        }
        finally {
            semaphore.release();
        }
    }

    private byte[] getRemoteLogFileStream(String rpcUrl, Date fromDate, Date toDate, String logType, String newServerKey) {
        byte[] ret = null;
        try {
            IWfLogGather wfLogGather = (IWfLogGather)RPCEngineFactory.getEngine((String)rpcUrl).createObject("com.kingdee.bos.workflow.metas.WfLogGather", IWfLogGather.class);
            ret = wfLogGather.getLogFileStream(fromDate, toDate, newServerKey, logType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private byte[] getLocalLogFileStream(Context ctx, final Date fromDate, final Date toDate, final List<String> logTypes, String serverName) throws BOSException {
        String logPath = EAS_HOME + FILE_SEPARATOR + "server" + FILE_SEPARATOR + "profiles" + FILE_SEPARATOR + serverName + FILE_SEPARATOR + "logs";
        File logDir = new File(logPath);
        long maxSize = 0L;
        final AtomicLong size = new AtomicLong(0L);
        final HashMap temp = new HashMap();
        String[] expectedLogFiles = logDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String type : logTypes) {
                    long lastModified;
                    File item;
                    if (!name.contains(type + ".") && (!"apusic".equals(type) || !name.contains(type) || name.endsWith(".lck")) || !(item = new File(dir, name)).isFile() || (lastModified = item.lastModified()) <= fromDate.getTime()) continue;
                    if (toDate != null && lastModified < toDate.getTime()) {
                        size.addAndGet(item.length());
                        return true;
                    }
                    FileItem fileItem = (FileItem)temp.get(type);
                    if (fileItem == null) {
                        fileItem = new FileItem(lastModified, item.length(), name);
                        temp.put(type, fileItem);
                        continue;
                    }
                    if (lastModified >= fileItem.getLastModified()) continue;
                    fileItem.setLastModified(lastModified);
                    fileItem.setLength(item.length());
                    fileItem.setName(name);
                }
                return false;
            }
        });
        if (toDate == null) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (Map.Entry entry : temp.entrySet()) {
                FileItem fileItem = (FileItem)entry.getValue();
                maxSize += fileItem.getLength();
                nameList.add(fileItem.getName());
            }
            expectedLogFiles = nameList.toArray(new String[0]);
        } else {
            maxSize = size.longValue();
        }
        if (maxSize > 1572864000L) {
            throw new BOSException("\u65e5\u5fd7\u6587\u4ef6\u8fc7\u5927\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u52361500M");
        }
        if (maxSize == 0L) {
            return null;
        }
        return this.compress(logPath, serverName, expectedLogFiles);
    }

    private byte[] compress(String logPath, String serverName, String[] expectedLogFiles) throws BOSException {
        String key = UUID.randomUUID().toString().replace("-", "");
        String destPath = EAS_HOME + FILE_SEPARATOR + key + ".zip";
        File destFile = new File(destPath);
        ZipOutputStream zos = null;
        BufferedInputStream bis = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(destFile));
            zos.setLevel(9);
            String comment = serverName + "@" + Configuration.getRpcUrl();
            zos.setComment(comment);
            for (String logFileName : expectedLogFiles) {
                String logFilePath = logPath + FILE_SEPARATOR + logFileName;
                File srcFile = new File(logFilePath);
                if (!srcFile.exists()) continue;
                ZipEntry entry = new ZipEntry(logFileName);
                entry.setTime(srcFile.lastModified());
                zos.putNextEntry(entry);
                bis = new BufferedInputStream(new FileInputStream(srcFile));
                byte[] buf = new byte[2048];
                int length = -1;
                while ((length = bis.read(buf)) != -1) {
                    zos.write(buf, 0, length);
                }
                this.closeQuietly(bis);
            }
        }
        catch (Exception e) {
            this.closeQuietly(zos);
            if (destFile.exists()) {
                destFile.delete();
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeQuietly(bis);
            this.closeQuietly(zos);
        }
        if (destFile.length() > 0x3200000L) {
            throw new BOSException("\u65e5\u5fd7\u538b\u7f29\u6587\u4ef6\u8fc7\u5927\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236 50M");
        }
        return this.getByteArrayAndDelete(destFile);
    }

    private byte[] combineData(List<byte[]> dataList) throws BOSException {
        String key = UUID.randomUUID().toString().replace("-", "");
        String destPath = EAS_HOME + FILE_SEPARATOR + key + ".zip";
        File destFile = new File(destPath);
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(destFile));
            zos.setLevel(9);
            for (int i = 0; i < dataList.size(); ++i) {
                zos.putNextEntry(new ZipEntry("logs" + (i + 1) + ".zip"));
                zos.write(dataList.get(i));
            }
            this.closeQuietly(zos);
        }
        catch (Exception e) {
            try {
                this.closeQuietly(zos);
                if (destFile.exists()) {
                    destFile.delete();
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(zos);
                throw throwable;
            }
        }
        if (destFile.length() > 0x3200000L) {
            throw new BOSException("\u65e5\u5fd7\u538b\u7f29\u6587\u4ef6\u8fc7\u5927\uff0c\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236 50M");
        }
        return this.getByteArrayAndDelete(destFile);
    }

    private byte[] getByteArrayAndDelete(File destFile) throws BOSException {
        if (destFile != null && destFile.exists()) {
            byte[] byArray;
            block7: {
                ByteArrayOutputStream baos = null;
                BufferedInputStream bis = null;
                try {
                    baos = new ByteArrayOutputStream();
                    bis = new BufferedInputStream(new FileInputStream(destFile));
                    byte[] buf = new byte[2048];
                    int length = -1;
                    while ((length = bis.read(buf)) != -1) {
                        baos.write(buf, 0, length);
                    }
                    byArray = baos.toByteArray();
                    this.closeQuietly(bis);
                    if (!destFile.exists()) break block7;
                    destFile.delete();
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.closeQuietly(bis);
                        if (destFile.exists()) {
                            destFile.delete();
                        }
                        throw throwable;
                    }
                }
            }
            return byArray;
        }
        return null;
    }

    private void closeQuietly(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isLocal(String url) {
        String rpcUrl = Configuration.getRpcUrl();
        String localIp = this.getIpFromUrl(rpcUrl);
        String serverIp = this.getIpFromUrl(url);
        return serverIp.equals(localIp);
    }

    private String getIpFromUrl(String url) {
        int index = url.indexOf("//");
        String ip = null;
        ip = index < 0 ? url.substring(0, url.lastIndexOf(":")) : url.substring(url.indexOf("//") + 2, url.lastIndexOf(":"));
        return ip;
    }

    private boolean isLegal(String name) {
        if (!StringUtils.isEmpty((String)name)) {
            for (String type : LOG_TYPES) {
                if (!type.equals(name)) continue;
                return true;
            }
        }
        return false;
    }
}

