/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc;

import com.kingdee.bos.util.BOSUuid;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;

public class Config
implements Serializable {
    private static final long serialVersionUID = -412708232446441877L;
    public static final String ASSIGN_DEVOLVE_MODE = "assignment.devolve.mode";
    Properties properties;

    public boolean getBoolean(String key, String billId, String defaultValue) {
        String s = this.getString(key, billId, defaultValue).toLowerCase(Locale.ENGLISH);
        return "true".equals(s);
    }

    public int getInt(String key, String billId, String defaultValue) {
        String s = this.getString(key, billId, defaultValue).toLowerCase();
        return Integer.parseInt(s);
    }

    public String getString(String key, String billId, String defaultValue) {
        String s = this.getConfig(key, billId);
        if (s == null || s.length() == 0) {
            return defaultValue;
        }
        return s;
    }

    public static Object newInstance(Class c) {
        if (c == null) {
            return null;
        }
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("initiate object instance of {" + c + "} failed!", e);
        }
    }

    public static Class getClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class {" + className + "}.", e);
        }
    }

    public String getConfig(String key, String billId) {
        String bosType = Config.getBOSType(billId);
        String value = this.getValue(bosType + "." + key);
        if (value == null) {
            value = this.getValue(key);
        }
        return value;
    }

    public static String getBOSType(String billId) {
        if (billId == null || billId.length() == 0) {
            return "";
        }
        if (billId.length() < 10) {
            return billId;
        }
        BOSUuid id = BOSUuid.read((String)billId);
        return id.getType().toString();
    }

    public String getValue(String key) {
        String v = this.properties.getProperty(key);
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    Config(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.properties.toString();
    }
}

