/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.service.ormrpc.struct;

import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.ormrpc.struct.IProcessImage;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class WfProcessImageUtil {
    public static final Collator COLLATOR = Collator.getInstance(Locale.CHINA);
    private static final Comparator<IProcessImage.Activity> comparator = new Comparator<IProcessImage.Activity>(){

        @Override
        public int compare(IProcessImage.Activity a1, IProcessImage.Activity a2) {
            int c = COLLATOR.compare(a1.name, a2.name);
            if (c != 0) {
                return c;
            }
            return a1.getActDefId().compareTo(a2.getActDefId());
        }
    };
    private static final String[] SEQ = new String[]{"\uff11", "\uff12", "\uff13", "\uff14", "\uff15", "\uff16", "\uff17", "\uff18", "\uff19", "10", "11", "12", "\uff11\uff13", "14", "15", "16", "17", "18", "19", "20"};

    public static Map<String, String> rename(ProcessDef def, Locale l) {
        ActivityCollection acts = def.getActivitys();
        ArrayList<IProcessImage.Activity> list = new ArrayList<IProcessImage.Activity>(acts.size());
        for (int i = 0; i < acts.size(); ++i) {
            IProcessImage.Activity a = new IProcessImage.Activity();
            ActivityDef v = acts.get(i);
            a.actDefId = v.getID();
            a.name = v.getName(l);
            list.add(a);
        }
        WfProcessImageUtil.rename(list);
        HashMap<String, String> mapping = new HashMap<String, String>(list.size());
        for (IProcessImage.Activity a : list) {
            mapping.put(a.actDefId, a.name);
        }
        return mapping;
    }

    public static void rename(Collection<IProcessImage.Activity> list) {
        Object[] acts = list.toArray(new IProcessImage.Activity[list.size()]);
        Arrays.sort((Object[])acts, comparator);
        int count = 0;
        int j = 0;
        int i = 1;
        while (i < acts.length) {
            if (((IProcessImage.Activity)acts[i]).name.equals(((IProcessImage.Activity)acts[j]).name)) {
                count = WfProcessImageUtil.addSuffix((IProcessImage.Activity[])acts, count, j);
            } else if (count > 0) {
                WfProcessImageUtil.addSuffix((IProcessImage.Activity[])acts, count, j);
                count = 0;
            }
            ++i;
            ++j;
        }
        if (count > 0) {
            WfProcessImageUtil.addSuffix((IProcessImage.Activity[])acts, count, j);
        }
    }

    private static int addSuffix(IProcessImage.Activity[] acts, int count, int j) {
        String suffix = SEQ.length > ++count ? SEQ[count - 1] : String.valueOf(count);
        acts[j].name = acts[j].name + suffix;
        return count;
    }
}

