/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.parser;

import com.kingdee.bos.workflow.shell.WfShellParserException;
import com.kingdee.bos.workflow.shell.parser.KeyWord;
import com.kingdee.bos.workflow.shell.parser.StringReader;
import com.kingdee.bos.workflow.shell.parser.Token;
import java.util.Locale;

public class Lexer {
    KeyWord _keywords;
    private StringReader _reader;
    private int _col = 1;
    private int _line = 1;
    private int _ptr;
    private boolean _skipComment = true;

    public Lexer(KeyWord keyword, StringReader _reader) {
        this._keywords = keyword;
        this._reader = _reader;
    }

    public Lexer(StringReader reader) {
        this._ptr = reader._ptr;
        this._keywords = KeyWord.instance();
        this._reader = reader;
    }

    public Lexer(String text) {
        this(text, true);
    }

    public Lexer(String text, boolean skipComment) {
        this._skipComment = skipComment;
        if (text == null) {
            throw new IllegalArgumentException("text");
        }
        this._keywords = KeyWord.instance();
        this._reader = new StringReader(text);
    }

    public final Token next() throws WfShellParserException {
        while (!this._reader.eos()) {
            String text;
            char ch = this._reader.next();
            if (Character.isWhitespace(ch)) {
                ++this._col;
                if (ch != '\n') continue;
                ++this._line;
                this._col = 1;
                continue;
            }
            this._ptr = this._reader._ptr;
            if (ch == '\'') {
                if (this._reader.eos()) {
                    throw new WfShellParserException("unexpected input end");
                }
                String charstr = this.readChar();
                return new Token(charstr, 6, this._line, this._col, this._ptr);
            }
            if (ch == '\"') {
                text = this.readString();
                return new Token(text, 6, this._line, this._col, this._ptr);
            }
            if (Character.isLetter(ch) || ch == '_' || ch == '#') {
                int x = this._col;
                int y = this._line;
                String text2 = this.readIdent(ch);
                if (this._keywords.isKeyWord(text2)) {
                    return new Token(text2, 3, y, x, this._ptr);
                }
                return new Token(text2, 1, y, x, this._ptr);
            }
            if (ch == '?') {
                ++this._col;
                return new Token("?", 5, this._line, this._col, this._ptr);
            }
            if (Character.isDigit(ch)) {
                return this.readDigit(ch, this._col);
            }
            if (ch == '/' && this._reader.peek() == '/') {
                ++this._col;
                this._reader.skip();
                text = this.readlineComment();
                if (this._skipComment) continue;
                return new Token(text, 0, this._line, this._col, this._ptr);
            }
            if (ch == '/' && this._reader.peek() == '*') {
                this._reader.skip();
                StringBuffer comment = new StringBuffer();
                while (true) {
                    if ((ch = this._reader.next()) == '*' && this._reader.peek() == '/') break;
                    comment.append(ch);
                }
                this._reader.skip();
                if (this._skipComment) continue;
                return new Token(comment.toString(), 14, this._line, this._col, this._ptr);
            }
            Token token = this.readOperator(ch);
            if (token != null) {
                return token;
            }
            token = this.readPunctuation(ch);
            if (token != null) {
                return token;
            }
            if (ch == '$') {
                ch = this._reader.peek();
                ++this._col;
                if (Character.isDigit(ch)) {
                    return this.readDigit(ch, this._col);
                }
            }
            String message = "Error: Unknowen char not read at (";
            throw new WfShellParserException(message, this._line, this._col);
        }
        return new Token("", 12, this._line, this._col, this._ptr);
    }

    private final String readIdent(char c) throws WfShellParserException {
        StringBuffer s = new StringBuffer();
        s.append(c);
        ++this._col;
        while (!this._reader.eos()) {
            c = this._reader.next();
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#') {
                this._reader.unget();
                break;
            }
            s.append(c);
            ++this._col;
        }
        return s.toString().toLowerCase(Locale.ENGLISH);
    }

    private final Token readDigit(char ch, int x) throws WfShellParserException {
        char nextChar;
        int y = this._line;
        ++this._col;
        boolean isdouble = false;
        StringBuffer text = new StringBuffer();
        text.append(ch);
        boolean hexFlag = false;
        if (ch == '0' && this._reader.peek() == 'x') {
            text.append(this._reader.next());
            hexFlag = true;
        }
        while ((nextChar = this._reader.peek()) >= '0' && nextChar <= '9' || hexFlag && nextChar >= 'A' && nextChar <= 'F' || hexFlag && nextChar >= 'a' && nextChar <= 'f') {
            text.append(this._reader.next());
            ++this._col;
        }
        if (this._reader.peek() == '.') {
            isdouble = true;
            text.append(this._reader.next());
            ++this._col;
            while (Character.isDigit(this._reader.peek())) {
                text.append(this._reader.next());
                ++this._col;
            }
        } else {
            if (this._reader.peek() == 'L' || this._reader.peek() == 'l') {
                this._reader.skip();
                return new Token(text.toString(), 15, y, x, this._ptr);
            }
            if (this._reader.peek() == 'F' || this._reader.peek() == 'f') {
                this._reader.skip();
                return new Token(text.toString(), 9, y, x, this._ptr);
            }
            if (this._reader.peek() == 'D' || this._reader.peek() == 'd') {
                this._reader.skip();
                return new Token(text.toString(), 10, y, x, this._ptr);
            }
        }
        if (isdouble) {
            if (this._reader.peek() == 'F' || this._reader.peek() == 'f') {
                this._reader.skip();
                return new Token(text.toString(), 9, y, x, this._ptr);
            }
            if (this._reader.peek() == 'D' || this._reader.peek() == 'd') {
                this._reader.skip();
                return new Token(text.toString(), 10, y, x, this._ptr);
            }
            if (this._reader.peek() == 'E') {
                text.append('E');
                this._reader.skip();
                ++this._col;
                while (Character.isDigit(this._reader.peek())) {
                    text.append(this._reader.next());
                    ++this._col;
                }
            }
            return new Token(text.toString(), 10, y, x, this._ptr);
        }
        return new Token(text.toString(), 8, y, x, this._ptr);
    }

    private final String readChar() throws WfShellParserException {
        char ch = '\u0000';
        StringBuffer text = new StringBuffer();
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == '\'') {
                return text.toString();
            }
            ++this._col;
            if (ch == '\\') {
                char nextChar = this._reader.lookup(0);
                if (nextChar == '\\') {
                    text.append('\\');
                } else if (nextChar == '\"') {
                    text.append('\"');
                } else if (nextChar == 't') {
                    text.append('\t');
                } else if (nextChar == 'r') {
                    text.append('\r');
                } else if (nextChar == 'n') {
                    text.append('\n');
                } else {
                    throw new WfShellParserException("TODO." + nextChar);
                }
                this._col = 1;
                this._reader.skip();
                continue;
            }
            text.append(ch);
        }
        if (ch != '\'') {
            String message = "End of File before String terminated at (";
            throw new WfShellParserException(message, this._line, this._col);
        }
        return text.toString();
    }

    private final String readString() throws WfShellParserException {
        char ch = '\u0000';
        StringBuffer text = new StringBuffer();
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == '\"') {
                return text.toString();
            }
            ++this._col;
            if (ch == '\\') {
                char nextChar = this._reader.lookup(0);
                if (nextChar == '\\') {
                    text.append('\\');
                } else if (nextChar == '\"') {
                    text.append('\"');
                } else if (nextChar == 't') {
                    text.append('\t');
                } else if (nextChar == 'r') {
                    text.append('\r');
                } else if (nextChar == 'n') {
                    text.append('\n');
                } else {
                    throw new WfShellParserException("TODO." + nextChar);
                }
                this._col = 1;
                this._reader.skip();
                continue;
            }
            text.append(ch);
        }
        if (ch != '\"') {
            String message = "End of File before String terminated at (";
            throw new WfShellParserException(message, this._line, this._col);
        }
        return text.toString();
    }

    private final String readlineComment() throws WfShellParserException {
        if (this._reader.eos()) {
            return "";
        }
        StringBuffer comment = new StringBuffer();
        char ch = this._reader.next();
        while (ch != '\n' && !this._reader.eos()) {
            comment.append(ch);
            ch = this._reader.next();
        }
        return comment.toString();
    }

    private final Token readOperator(char ch) throws WfShellParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case '+': {
                if (this._reader.eos()) {
                    return new Token("+", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '+': {
                        ++this._col;
                        return new Token("++", 4, y, x);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("+=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("+", 4, y, x, this._ptr);
            }
            case '-': {
                if (this._reader.eos()) {
                    return new Token("-", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '-': {
                        ++this._col;
                        return new Token("--", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("-=", 4, y, x);
                    }
                    case '>': {
                        ++this._col;
                        throw new WfShellParserException("ERROR");
                    }
                }
                this._reader.unget();
                char peek = this._reader.peek();
                if (this._col > 0 && peek >= '0' && peek <= '9') {
                    char p;
                    int i = -2;
                    if (i + this._reader._ptr < 0) {
                        i = this._reader._ptr * -1;
                    }
                    while (Character.isWhitespace(p = this._reader.lookup(i)) && this._col + --i > 1) {
                    }
                    if (p == ',' || p == '(' || this.isOperator(p)) {
                        return this.readDigit('-', this._col - 1);
                    }
                    return new Token("-", 4, y, x, this._ptr);
                }
                return new Token("-", 4, y, x, this._ptr);
            }
            case '*': {
                if (this._reader.eos()) {
                    return new Token("*", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("*=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("*", 4, y, x, this._ptr);
            }
            case '/': {
                if (this._reader.eos()) {
                    return new Token("/", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("/=", 4, y, x, this._ptr);
                    }
                    case '*': {
                        throw new WfShellParserException("TODO");
                    }
                }
                this._reader.unget();
                return new Token("/", 4, y, x, this._ptr);
            }
            case '%': {
                if (this._reader.eos()) {
                    return new Token("%", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("%=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("%", 4, y, x, this._ptr);
            }
            case '&': {
                if (this._reader.eos()) {
                    return new Token("&", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '&': {
                        ++this._col;
                        return new Token("&&", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("&=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("&", 4, y, x, this._ptr);
            }
            case '|': {
                if (this._reader.eos()) {
                    return new Token("|", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '|': {
                        ++this._col;
                        return new Token("||", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("|=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("|", 4, y, x, this._ptr);
            }
            case '^': {
                if (this._reader.eos()) {
                    return new Token("^", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("^=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("^", 4, y, x, this._ptr);
            }
            case '!': {
                if (this._reader.eos()) {
                    return new Token("!", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("!=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("!", 4, y, x, this._ptr);
            }
            case '~': {
                return new Token("~", 4, y, x, this._ptr);
            }
            case '=': {
                if (this._reader.eos()) {
                    return new Token("=", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("==", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("=", 4, y, x, this._ptr);
            }
            case '<': {
                if (this._reader.eos()) {
                    return new Token("<", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '<': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token("<<=", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token("<<", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("<=", 4, y, x, this._ptr);
                    }
                    case '>': {
                        ++this._col;
                        return new Token("<>", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("<", 4, y, x, this._ptr);
            }
            case '>': {
                if (this._reader.eos()) {
                    return new Token(">", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '>': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token(">>=", 4, y, x, this._ptr);
                            }
                            case '>': {
                                this._col += 2;
                                if (!this._reader.eos() && this._reader.peek() == '=') {
                                    ++this._col;
                                    this._reader.skip();
                                    return new Token(">>>=", 4, y, x, this._ptr);
                                }
                                return new Token(">>>", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token(">>", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token(">=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token(">", 4, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final Token readPunctuation(char ch) throws WfShellParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case ';': {
                return new Token(";", 5, y, x, this._ptr);
            }
            case ':': {
                return new Token(":", 5, y, x, this._ptr);
            }
            case ',': {
                return new Token(",", 5, y, x, this._ptr);
            }
            case '.': {
                if (Character.isDigit(this._reader.peek())) {
                    this._reader.unget();
                    this._col -= 2;
                    return this.readDigit('0', this._col + 1);
                }
                return new Token(".", 5, y, x, this._ptr);
            }
            case ')': {
                return new Token(")", 5, y, x, this._ptr);
            }
            case '(': {
                return new Token("(", 5, y, x, this._ptr);
            }
            case ']': {
                return new Token("]", 5, y, x, this._ptr);
            }
            case '[': {
                return new Token("[", 5, y, x, this._ptr);
            }
            case '}': {
                return new Token("}", 5, y, x, this._ptr);
            }
            case '{': {
                return new Token("{", 5, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final boolean isOperator(char c) {
        switch (c) {
            case '!': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }
}

