/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.parser;

import com.kingdee.bos.kscript.dom.Function;
import com.kingdee.bos.workflow.shell.WfShellParserException;
import com.kingdee.bos.workflow.shell.ast.expr.ArrayIndexerExpr;
import com.kingdee.bos.workflow.shell.ast.expr.BinaryOpExpr;
import com.kingdee.bos.workflow.shell.ast.expr.BoolExpr;
import com.kingdee.bos.workflow.shell.ast.expr.CharExpr;
import com.kingdee.bos.workflow.shell.ast.expr.ConditionExpr;
import com.kingdee.bos.workflow.shell.ast.expr.DoubleExpr;
import com.kingdee.bos.workflow.shell.ast.expr.FloatExpr;
import com.kingdee.bos.workflow.shell.ast.expr.IdentifierExpr;
import com.kingdee.bos.workflow.shell.ast.expr.IntExpr;
import com.kingdee.bos.workflow.shell.ast.expr.LambdaExpr;
import com.kingdee.bos.workflow.shell.ast.expr.LongExpr;
import com.kingdee.bos.workflow.shell.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.workflow.shell.ast.expr.NewFunctionExpr;
import com.kingdee.bos.workflow.shell.ast.expr.NullExpr;
import com.kingdee.bos.workflow.shell.ast.expr.ObjectCreateExpr;
import com.kingdee.bos.workflow.shell.ast.expr.PropertyExpr;
import com.kingdee.bos.workflow.shell.ast.expr.StringExpr;
import com.kingdee.bos.workflow.shell.ast.expr.UnaryExpr;
import com.kingdee.bos.workflow.shell.ast.expr.VarRefExpr;
import com.kingdee.bos.workflow.shell.ast.expr.WfShellExpr;
import com.kingdee.bos.workflow.shell.parser.Lexer;
import com.kingdee.bos.workflow.shell.parser.Token;
import com.kingdee.bos.workflow.shell.parser.TokenList;
import com.kingdee.bos.workflow.shell.parser.WfShellStmtParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WfShellExprParser {
    public final List namespaces;
    public final Map classMap;
    private TokenList _tokenList;

    public WfShellExprParser(TokenList tokList) {
        this.namespaces = new ArrayList();
        this.classMap = new HashMap();
        this._tokenList = tokList;
    }

    public WfShellExprParser(TokenList tokList, List namespaces, Map classMap) {
        this.namespaces = namespaces;
        this.classMap = classMap;
        this._tokenList = tokList;
    }

    public WfShellExprParser(String text) throws WfShellParserException {
        this.namespaces = new ArrayList();
        this.classMap = new HashMap();
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
    }

    public final WfShellExpr expr() throws WfShellParserException {
        WfShellExpr expr = this.unary();
        if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            return expr;
        }
        return this.exprRest(expr);
    }

    public final WfShellExpr exprRest(WfShellExpr expr) throws WfShellParserException {
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.shiftRest(expr);
        expr = this.relationalRest(expr);
        expr = this.andRest(expr);
        expr = this.xorRest(expr);
        expr = this.orRest(expr);
        expr = this.conditionalRest(expr);
        expr = this.assignRest(expr);
        return expr;
    }

    public final void exprList(Collection exprCol) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            return;
        }
        WfShellExpr expr = this.expr();
        exprCol.add(expr);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            expr = this.expr();
            exprCol.add(expr);
        }
    }

    public final WfShellExpr unary() throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.IncrementToken)) {
            this._tokenList.match();
            WfShellExpr expr = this.unary();
            return new UnaryExpr(3, expr);
        }
        if (this._tokenList.lookup(0).equals(Token.DecrementToken)) {
            this._tokenList.match();
            WfShellExpr expr = this.unary();
            return new UnaryExpr(5, expr);
        }
        if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            this._tokenList.match();
            WfShellExpr expr = this.unary();
            return new UnaryExpr(0, expr);
        }
        if (this._tokenList.lookup(0).equals(Token.BitwiseComplementToken)) {
            this._tokenList.match();
            WfShellExpr expr = this.unary();
            return new UnaryExpr(7, expr);
        }
        return this.primary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final WfShellExpr primary() throws WfShellParserException {
        WfShellExpr rtnExpr = null;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            rtnExpr = this.expr();
            this._tokenList.match(Token.CloseBraceToken);
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 1) {
            rtnExpr = new IdentifierExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup(0).equals(Token.New)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.FunctionToken)) {
                this._tokenList.match();
                Function func = new Function();
                this._tokenList.match(Token.OpenBraceToken);
                if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                    String pramName = this._tokenList.lookup((int)0).value;
                    func.paramList.add(pramName);
                    this._tokenList.match(1);
                    while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                        this._tokenList.match();
                        pramName = this._tokenList.lookup((int)0).value;
                        func.paramList.add(pramName);
                        this._tokenList.match(1);
                    }
                }
                this._tokenList.match(Token.CloseBraceToken);
                this._tokenList.match(Token.OpenCurlyBraceToken);
                WfShellStmtParser stmtParser = new WfShellStmtParser(this._tokenList, this.namespaces, this.classMap);
                stmtParser.stmtList(func.stmtList, Token.CloseCurlyBraceToken);
                this._tokenList.match(Token.CloseCurlyBraceToken);
                NewFunctionExpr newFuncExpr = new NewFunctionExpr(func);
                rtnExpr = newFuncExpr;
                return this.primaryRest(rtnExpr);
            } else {
                StringBuffer typeNameBuffer = new StringBuffer();
                typeNameBuffer.append(this._tokenList.lookup((int)0).value);
                this._tokenList.match();
                while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                    this._tokenList.match();
                    typeNameBuffer.append('.');
                    typeNameBuffer.append(this._tokenList.lookup((int)0).value);
                    this._tokenList.match();
                }
                if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                    this._tokenList.match();
                    ObjectCreateExpr newExpr = new ObjectCreateExpr(typeNameBuffer.toString());
                    this.exprList(newExpr.paramList);
                    this._tokenList.match(Token.CloseBraceToken);
                    rtnExpr = newExpr;
                    return this.primaryRest(rtnExpr);
                } else {
                    if (!this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken)) throw new WfShellParserException("TODO, " + this._tokenList.lookup((int)0).value);
                    StringBuffer arrayBuff = new StringBuffer();
                    ObjectCreateExpr newExpr = new ObjectCreateExpr();
                    while (this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken)) {
                        this._tokenList.match();
                        arrayBuff.append('[');
                        if (!this._tokenList.lookup(0).equals(Token.CloseSquareBraceToken)) {
                            WfShellExpr pramExpr = this.expr();
                            newExpr.paramList.add(pramExpr);
                            this._tokenList.match(Token.CloseSquareBraceToken);
                            continue;
                        }
                        this._tokenList.match();
                    }
                    boolean primitiveFlag = false;
                    String typeName = typeNameBuffer.toString();
                    if (typeName.equals("char")) {
                        typeName = "C";
                    } else if (typeName.equals("byte")) {
                        typeName = "B";
                    } else if (typeName.equals("short")) {
                        typeName = "S";
                    } else if (typeName.equals("int")) {
                        typeName = "I";
                    } else if (typeName.equals("long")) {
                        typeName = "J";
                    } else if (typeName.equals("float")) {
                        typeName = "F";
                    } else if (typeName.equals("double")) {
                        typeName = "D";
                    } else {
                        primitiveFlag = true;
                    }
                    newExpr.objType = typeName = primitiveFlag ? arrayBuff.toString() + "L" + typeName + ";" : arrayBuff.toString() + typeName;
                    if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                        this._tokenList.match();
                        if (this._tokenList.lookup(0).equals(Token.CloseCurlyBraceToken)) {
                            this._tokenList.match();
                        } else {
                            this.exprList(newExpr.initExprList);
                            this._tokenList.match(Token.CloseCurlyBraceToken);
                        }
                    }
                    rtnExpr = newExpr;
                }
            }
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 8) {
            rtnExpr = new IntExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 7) {
            rtnExpr = new CharExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 15) {
            rtnExpr = new LongExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 9) {
            rtnExpr = new FloatExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 10) {
            rtnExpr = new DoubleExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 6) {
            rtnExpr = new StringExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup((int)0).type == 2) {
            rtnExpr = new VarRefExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup(0).equals(Token.NullToken)) {
            this._tokenList.match();
            rtnExpr = NullExpr.instance;
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup(0).equals(Token.TrueToken)) {
            this._tokenList.match();
            rtnExpr = new BoolExpr(true);
            return this.primaryRest(rtnExpr);
        } else if (this._tokenList.lookup(0).equals(Token.FalseToken)) {
            this._tokenList.match();
            rtnExpr = new BoolExpr(false);
            return this.primaryRest(rtnExpr);
        } else {
            if (!this._tokenList.lookup(0).equals(Token.LambdaToken)) throw new WfShellParserException("ERROR. " + this._tokenList.lookup((int)0).value, 0, 0);
            rtnExpr = this.lambda();
        }
        return this.primaryRest(rtnExpr);
    }

    public LambdaExpr lambda() throws WfShellParserException {
        this._tokenList.match(Token.LambdaToken);
        LambdaExpr rtnExpr = new LambdaExpr();
        if (this._tokenList.lookup((int)0).type == 1) {
            rtnExpr.paramList.add(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
        }
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            rtnExpr.paramList.add(this._tokenList.lookup((int)0).value);
            this._tokenList.match(1);
        }
        this._tokenList.match(Token.ColonToken);
        rtnExpr.expr = this.expr();
        return rtnExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final WfShellExpr primaryRest(WfShellExpr expr) throws WfShellParserException {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
            this._tokenList.match();
            String memberName = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                MethodInvokeExpr methodInvokeExpr = new MethodInvokeExpr(expr, memberName);
                this.exprList(methodInvokeExpr.paramList);
                this._tokenList.match(Token.CloseBraceToken);
                return this.primaryRest(methodInvokeExpr);
            }
            PropertyExpr propExpr = new PropertyExpr(expr, memberName);
            return this.primaryRest(propExpr);
        }
        if (this._tokenList.lookup(0).equals(Token.IncrementToken)) {
            this._tokenList.match();
            return new UnaryExpr(4, expr);
        }
        if (this._tokenList.lookup(0).equals(Token.DecrementToken)) {
            this._tokenList.match();
            return new UnaryExpr(6, expr);
        }
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            if (!(expr instanceof IdentifierExpr)) throw new WfShellParserException("TODO", 0, 0);
            IdentifierExpr identExpr = (IdentifierExpr)expr;
            MethodInvokeExpr methodInvokeExpr = new MethodInvokeExpr(null, identExpr.value);
            this.exprList(methodInvokeExpr.paramList);
            this._tokenList.match(Token.CloseBraceToken);
            return this.primaryRest(methodInvokeExpr);
        }
        if (!this._tokenList.lookup(0).equals(Token.OpenSquareBraceToken)) return expr;
        this._tokenList.match();
        ArrayIndexerExpr arrayIndexerExpr = new ArrayIndexerExpr();
        arrayIndexerExpr.targetObjExpr = expr;
        arrayIndexerExpr.indexExpr = this.expr();
        this._tokenList.match(Token.CloseSquareBraceToken);
        return this.primaryRest(arrayIndexerExpr);
    }

    public final WfShellExpr assign() throws WfShellParserException {
        WfShellExpr expr = this.conditional();
        return this.assignRest(expr);
    }

    public final WfShellExpr assignRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.AssignToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            expr = new BinaryOpExpr(expr, 2, rightExp);
            expr = this.assignRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.AddEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 28, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.SubEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 29, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.MulEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 30, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.DivEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 31, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.ModEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 32, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LeftShiftEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 33, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.RightShiftEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 34, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.UnsignRightShiftEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 34, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.BitwiseAndEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 36, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.BitwiseOrEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 37, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.BitwiseXorEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.assign();
            rightExp = this.assignRest(rightExp);
            expr = new BinaryOpExpr(expr, 38, rightExp);
        }
        return expr;
    }

    public final WfShellExpr additive() throws WfShellParserException {
        WfShellExpr expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    public final WfShellExpr additiveRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.PlusToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.multiplicative();
            expr = new BinaryOpExpr(expr, 0, rightExp);
            expr = this.additiveRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.MinusToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.multiplicative();
            if (expr instanceof StringExpr || rightExp instanceof StringExpr) {
                throw new WfShellParserException("Error. minus operator can not use add Char Or NChar");
            }
            expr = new BinaryOpExpr(expr, 26, rightExp);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    public final WfShellExpr multiplicative() throws WfShellParserException {
        WfShellExpr expr = this.unary();
        return this.multiplicativeRest(expr);
    }

    public final WfShellExpr multiplicativeRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.MulToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 22, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.DivToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 9, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.ModToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 21, rightExp);
            expr = this.multiplicativeRest(expr);
        }
        return expr;
    }

    public final WfShellExpr shift() throws WfShellParserException {
        WfShellExpr expr = this.additive();
        return this.shiftRest(expr);
    }

    public final WfShellExpr shiftRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.LeftShiftToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.additive();
            expr = new BinaryOpExpr(expr, 17, rightExp);
            expr = this.shiftRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.RightShiftToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.additive();
            expr = new BinaryOpExpr(expr, 19, rightExp);
            expr = this.shiftRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.UnsignRightShiftToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.additive();
            expr = new BinaryOpExpr(expr, 27, rightExp);
            expr = this.shiftRest(expr);
        }
        return expr;
    }

    public final WfShellExpr and() throws WfShellParserException {
        WfShellExpr expr = this.relational();
        return this.andRest(expr);
    }

    public final WfShellExpr andRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.BooleanAndToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.relational();
            expr = new BinaryOpExpr(expr, 7, rightExp);
            expr = this.andRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.BitwiseAndToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.relational();
            expr = new BinaryOpExpr(expr, 3, rightExp);
            expr = this.andRest(expr);
        }
        return expr;
    }

    public final WfShellExpr xor() throws WfShellParserException {
        WfShellExpr expr = this.and();
        return this.xorRest(expr);
    }

    public final WfShellExpr xorRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.BitwiseXorToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.and();
            expr = new BinaryOpExpr(expr, 6, rightExp);
            expr = this.xorRest(expr);
        }
        return expr;
    }

    public final WfShellExpr or() throws WfShellParserException {
        WfShellExpr expr = this.xor();
        return this.orRest(expr);
    }

    public final WfShellExpr orRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.BooleanOrToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.or();
            expr = new BinaryOpExpr(expr, 8, rightExp);
            expr = this.andRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.BitwiseOrToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.xor();
            expr = new BinaryOpExpr(expr, 5, rightExp);
            expr = this.andRest(expr);
        }
        return expr;
    }

    public final WfShellExpr relational() throws WfShellParserException {
        WfShellExpr expr = this.additive();
        return this.relationalRest(expr);
    }

    public final WfShellExpr relationalRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.LessThanToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 14, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LessThanOrEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 15, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 11, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanOrEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 12, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.EqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 10, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotEqualToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.shift();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 23, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.InstanceofToken)) {
            this._tokenList.match();
            WfShellExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 13, rightExp);
        }
        return expr;
    }

    private WfShellExpr conditional() throws WfShellParserException {
        WfShellExpr expr = this.or();
        return this.conditionalRest(expr);
    }

    private WfShellExpr conditionalRest(WfShellExpr expr) throws WfShellParserException {
        if (this._tokenList.lookup(0).equals(Token.QuestionToken)) {
            this._tokenList.match();
            WfShellExpr trueExpr = this.expr();
            trueExpr = this.exprRest(trueExpr);
            this._tokenList.match(Token.ColonToken);
            WfShellExpr falseExpr = this.expr();
            falseExpr = this.exprRest(falseExpr);
            ConditionExpr conditionalExpr = new ConditionExpr();
            conditionalExpr.testExpr = expr;
            conditionalExpr.trueExpr = trueExpr;
            conditionalExpr.falseExpr = falseExpr;
            expr = conditionalExpr;
        }
        return expr;
    }
}

