/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.shell.parser;

import com.kingdee.bos.kscript.dom.Function;
import com.kingdee.bos.workflow.shell.WfShellParserException;
import com.kingdee.bos.workflow.shell.ast.stmt.WfShellStmt;
import com.kingdee.bos.workflow.shell.parser.Lexer;
import com.kingdee.bos.workflow.shell.parser.Token;
import com.kingdee.bos.workflow.shell.parser.TokenList;
import com.kingdee.bos.workflow.shell.parser.WfShellStmtParser;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WfShellParser {
    public final List namespaces;
    public final Map classMap;
    private TokenList _tokenList;
    public List stmtList = new ArrayList();
    public Map functionDeclMap = new Hashtable();
    public Map classDeclMap = new Hashtable();

    public WfShellParser(String text) throws WfShellParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = new ArrayList();
        this.classMap = new Hashtable();
    }

    public WfShellParser(TokenList tokList) {
        this._tokenList = tokList;
        this.namespaces = new ArrayList();
        this.classMap = new Hashtable();
    }

    public WfShellParser(TokenList tokList, List namespaces, Map classMap) {
        this._tokenList = tokList;
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public WfShellParser(String text, List namespaces, Map classMap) throws WfShellParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public void parse() throws WfShellParserException {
        WfShellStmtParser stmtParser = new WfShellStmtParser(this._tokenList, this.namespaces, this.classMap);
        while (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
            if (this._tokenList.lookup(0).equals(Token.FunctionToken)) {
                this.parse_function();
                continue;
            }
            WfShellStmt stmt = stmtParser.stmt();
            if (stmt == null) continue;
            this.stmtList.add(stmt);
        }
    }

    public void parse_function() throws WfShellParserException {
        this._tokenList.match(Token.FunctionToken);
        Function func = new Function();
        func.name = this._tokenList.lookup((int)0).value;
        this._tokenList.match(1);
        this._tokenList.match(Token.OpenBraceToken);
        if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            String pramName = this._tokenList.lookup((int)0).value;
            func.paramList.add(pramName);
            this._tokenList.match(1);
            while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                this._tokenList.match();
                pramName = this._tokenList.lookup((int)0).value;
                func.paramList.add(pramName);
                this._tokenList.match(1);
            }
        }
        this._tokenList.match(Token.CloseBraceToken);
        this._tokenList.match(Token.OpenCurlyBraceToken);
        WfShellStmtParser stmtParser = new WfShellStmtParser(this._tokenList, this.namespaces, this.classMap);
        stmtParser.stmtList(func.stmtList, Token.CloseCurlyBraceToken);
        this._tokenList.match(Token.CloseCurlyBraceToken);
        this.functionDeclMap.put(func.name, func);
    }

    public String outputResult() {
        StringBuffer buff = new StringBuffer();
        this.outputResult(buff);
        return buff.toString();
    }

    public void outputResult(StringBuffer buff) {
        boolean flag = false;
        Iterator<Object> iter = this.functionDeclMap.values().iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n\n");
            }
            Function funDecl = (Function)iter.next();
            funDecl.output(buff, null);
        }
        if (flag) {
            buff.append("\n\n");
        }
        flag = false;
        iter = this.stmtList.iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n");
            }
            WfShellStmt stmt = (WfShellStmt)iter.next();
            stmt.output(buff, null);
            flag = true;
        }
    }
}

