/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.IRelevantDataValueConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.StringUtils;

public abstract class AbstractConvertor
implements IRelevantDataValueConvertor {
    protected RelevantData relevantData;

    protected abstract Object stringToObject(String var1) throws WfException;

    protected abstract String objectToString(Object var1) throws WfException;

    protected String arrayToString(Object[] value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        String result = "";
        int length = value.length;
        for (int i = 0; i <= length - 1; ++i) {
            if (result.trim().length() > 0) {
                result = result + ",";
            }
            Object object = value[i];
            result = result + this.objectToString(object);
        }
        return result;
    }

    protected Object[] stringToArray(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return new Object[this.relevantData.getDataType().getLength()];
        }
        String[] fieldValueStringArray = StringUtils.split((String)value, (String)",");
        int valueCount = fieldValueStringArray.length;
        int length = this.relevantData.getDataType().getLength();
        int recycleCount = length < valueCount ? length : valueCount;
        Object[] result = new Object[length];
        for (int i = 0; i <= recycleCount - 1; ++i) {
            Object fieldValueObject;
            String fieldValueString = fieldValueStringArray[i];
            result[i] = fieldValueObject = this.stringToObject(fieldValueString);
        }
        return result;
    }

    public AbstractConvertor(RelevantData value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.relevantData = value;
    }

    @Override
    public String valueToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        boolean isArray = this.relevantData.getDataType().isArray();
        if (isArray) {
            Object[] fieldValueObjectArray = (Object[])value;
            return this.arrayToString(fieldValueObjectArray);
        }
        return this.objectToString(value);
    }

    @Override
    public Object stringToValue() throws WfException {
        String fieldValueString = this.relevantData.getInnerValue();
        boolean isArray = this.relevantData.getDataType().isArray();
        if (isArray) {
            return this.stringToArray(fieldValueString);
        }
        return this.stringToObject(fieldValueString);
    }

    protected void objectToStringException(Object value) throws WfException {
        String msg = "";
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Current argument datatype is " + value.getClass().getName() + "!\n");
            buffer.append("The variable's detail is " + this.relevantData.toString());
            buffer.append(".");
            msg = buffer.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new WfException(msg);
    }
}

