/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.IBackgroundJobUpgrade;
import com.kingdee.bos.workflow.store.util.JobServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class BackgroundJobUpgrade
implements IBackgroundJobUpgrade,
IJobHandler {
    private static final long serialVersionUID = -8105293361884567989L;
    private Context ctx;

    public BackgroundJobUpgrade() {
    }

    public BackgroundJobUpgrade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void exec() throws BOSException {
        this.exec(2);
    }

    private void exec(int from) throws BOSException {
        if (from == 0) {
            this.upgradeJobDef(null);
            from = 1;
        }
        if (from == 1) {
            this.enableTrigger(null);
            from = 2;
        }
        if (from == 2) {
            this.prepareDumpJobProcInst("T_WFR_ProcInst", null);
            from = 3;
        }
        if (from == 3) {
            this.dumpJobProcInst("T_WFR_ProcInst", null);
            from = 4;
        }
        if (from == 4) {
            this.prepareDumpJobProcInst("T_WFR_ProcInstHst", null);
            from = 5;
        }
        if (from == 5) {
            this.dumpJobProcInst("T_WFR_ProcInstHst", null);
            from = 6;
        }
        if (from == 6) {
            this.finish();
        }
    }

    private void upgradeJobDef(Job job) throws BOSException {
        String sql = "select DISTINCT FPROCDEFID as id from t_wfR_procdef where fprocdeftype='BACKGROUNDJOB'";
        ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql);
        IEnactmentService wfSvc = EnactmentServiceFactory.createEnactService(this.ctx);
        IJobService jobSvc = JobServiceFactory.getLocalInstance((Context)this.ctx);
        String md52 = null;
        Throwable exception = null;
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            String defId = (String)((HashMap)list.get(i)).get("id");
            try {
                md52 = wfSvc.getProcessDefInfo(defId).getMd5HashValue();
                ProcessDef proc = wfSvc.getProcessDefByDefineHashValue(md52);
                JobDef def = JobServiceUtil.toJobDef(this.ctx, proc);
                Trigger trigger = JobServiceUtil.toTrigger(def, proc);
                sql = "SELECT 1 FROM T_JOB_DEF WHERE fjobdefid='" + def.getDefId() + "'";
                if (SQL.executeQuery((Context)this.ctx, (String)sql).size() == 0) {
                    jobSvc.createJobDef(def, trigger, false);
                } else {
                    ++count;
                }
                if (job == null) continue;
                job.setProgress("\u6b63\u5728\u5347\u7ea7\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\uff0c\u5df2\u5b8c\u6210 " + i + "/" + list.size());
                continue;
            }
            catch (Throwable t) {
                exception = t;
                JobLog msg = new JobLog(JobLog.Type.Error, "\u8f6c\u6362\u540e\u53f0\u4e8b\u52a1{" + defId + "|" + md52 + "}\u5931\u8d25\uff01", null, null, t);
                job.saveMessage(msg);
            }
        }
        if (exception != null) {
            throw new BOSException(exception);
        }
        if (job != null) {
            JobLog log = new JobLog(JobLog.Type.Info, "\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u5347\u7ea7\u6210\u529f\uff0c\u5171\u5347\u7ea7" + list.size() + "\u4e2a\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49, \u5176\u4e2d {" + count + "}\u4e2a\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u7531\u4e8e\u5df2\u7ecf\u5347\u7ea7\u8fc7\u88ab\u5ffd\u7565\uff01");
            job.saveMessage(log);
        }
    }

    private void enableTrigger(Job job) throws BOSException {
        String sql = "select KSQL_TABNAME from KSQL_USERTABLES WHERE KSQL_TABNAME='T_QTZ_BAK'";
        if (SQL.executeQuery((Context)this.ctx, (String)sql).size() == 0) {
            sql = "CREATE table T_QTZ_BAK(FID VARCHAR(300))";
            SQL.executeUpdate((Context)this.ctx, (String)sql);
            sql = "INSERT INTO T_QTZ_BAK select FTRIGGERNAME as id from t_qtz_triggers";
            SQL.executeUpdate((Context)this.ctx, (String)sql);
        }
        sql = "select fid as id from T_QTZ_BAK";
        ArrayList list = SQL.executeQuery((Context)this.ctx, (String)sql);
        IEnactmentService svc = EnactmentServiceFactory.createEnactService(this.ctx);
        int count = 0;
        int count2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            JobLog log;
            String defId = (String)((HashMap)list.get(i)).get("id");
            String jobDefId = defId.substring(0, 36) + "BGJOBDEF";
            sql = "UPDATE T_JOB_TRIGGER set fisvalid='Y' where fjobDefID='" + jobDefId + "'";
            if (SQL.executeUpdate((Context)this.ctx, (String)sql) > 0) {
                block11: {
                    ++count;
                    try {
                        svc.disableQuartsTigger(defId);
                    }
                    catch (Exception e) {
                        if (job == null) break block11;
                        log = new JobLog(JobLog.Type.Warn, "\u7981\u7528\u539f\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49{" + defId + "}\u7684Quarts\u89e6\u53d1\u5668\u5931\u8d25\uff01", null, null, (Throwable)e);
                        job.saveMessage(log);
                    }
                }
                sql = "DELETE FROM t_qtz_triggers WHERE FTRIGGERNAME='" + defId + "'";
                SQL.executeUpdate((Context)this.ctx, (String)sql);
            } else if (defId.endsWith("WFPRCDEF")) {
                block12: {
                    try {
                        svc.disableQuartsTigger(defId);
                        if (job != null) {
                            JobLog log2 = new JobLog(JobLog.Type.Warn, "{" + defId + "}\u5bf9\u5e94\u540e\u53f0\u4e8b\u52a1\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728, \u5176\u5bf9\u5e94\u7684Quarts\u89e6\u53d1\u5668\u5df2\u88ab\u5220\u9664\uff01");
                            job.saveMessage(log2);
                        }
                    }
                    catch (Exception e) {
                        if (job == null) break block12;
                        log = new JobLog(JobLog.Type.Warn, "\u5220\u9664\u4e0d\u5b58\u5728\u540e\u53f0\u4e8b\u52a1\u6d41\u7a0b\u5b9a\u4e49\u7684Quarts\u89e6\u53d1\u5668{" + defId + "}\u5931\u8d25\uff01");
                        job.saveMessage(log);
                    }
                }
                ++count2;
                sql = "DELETE FROM t_qtz_triggers WHERE FTRIGGERNAME='" + defId + "'";
                SQL.executeUpdate((Context)this.ctx, (String)sql);
            }
            if (job == null || i % 5 != 0) continue;
            job.setProgress("\u6b63\u5728\u542f\u7528\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\uff0c\u5df2\u5b8c\u6210 " + i + "/" + list.size());
        }
        if (job != null) {
            JobLog log = new JobLog(JobLog.Type.Info, "\u540e\u53f0\u4e8b\u52a1\u89e6\u53d1\u5668\u542f\u7528\u6210\u529f\uff0c\u5171\u542f\u7528 " + count + "\u4e2a\u540e\u53f0\u4e8b\u52a1\u89e6\u53d1\u5668, \u53e6\u5916\u6709{" + count2 + "}\u4e2a\u540e\u53f0\u4e8b\u52a1\u89e6\u53d1\u5668\u7531\u4e8e\u6ca1\u6709\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u800c\u88ab\u5ffd\u7565\uff01");
            job.saveMessage(log);
        }
    }

    private void prepareDumpJobProcInst(String table, Job job) throws BOSException {
        String sql = "select KSQL_TABNAME from KSQL_USERTABLES WHERE KSQL_TABNAME='T_JOB_UPGRADE'";
        if (SQL.executeQuery((Context)this.ctx, (String)sql).size() == 1) {
            sql = "drop table T_JOB_UPGRADE";
            SQL.executeUpdate((Context)this.ctx, (String)sql);
        }
        sql = "create table T_JOB_UPGRADE(fid varchar(44) not null, fflag char(1), constraint PK_JOB_UPGRADE primary key(fid))";
        SQL.executeUpdate((Context)this.ctx, (String)sql);
        sql = "insert into T_JOB_UPGRADE(fid,fflag) select FPROCINSTID,'Y' from " + table + "  where fprocdeftype='BACKGROUNDJOB'";
        int i = SQL.executeUpdate((Context)this.ctx, (String)sql);
        if (job != null) {
            JobLog log = new JobLog(JobLog.Type.Info, "\u8868{" + table + "}\u4e2d\u5171\u6709 " + i + " \u4e2a\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\u5f85\u8f6c\u50a8\u3002");
            job.saveMessage(log);
        }
    }

    private int dumpJobProcInst(String table, Job job) throws BOSException {
        ArrayList list;
        String msg;
        String sql = "UPDATE T_JOB_UPGRADE SET fflag='Y'";
        int total = SQL.executeUpdate((Context)this.ctx, (String)sql);
        if (total == 0) {
            return 0;
        }
        int count = 0;
        int count2 = 0;
        int count3 = 0;
        int count4 = 0;
        String string = msg = table.endsWith("Hst") ? "\u6b63\u5728\u8f6c\u6362\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\u5386\u53f2\u6570\u636e\uff0c\u5df2\u5b8c\u6210 " : "\u6b63\u5728\u8f6c\u6362\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\uff0c\u5df2\u5b8c\u6210 ";
        while ((list = SQL.executeQuery((Context)this.ctx, (String)(sql = "SELECT top 100 fid from T_JOB_UPGRADE WHERE FFLAG='Y'"))).size() != 0) {
            Date deadline = new Date(System.currentTimeMillis() - 10800000L);
            for (int i = 0; i < list.size(); ++i) {
                if (job != null) {
                    job.setProgress(msg + (count + count2 + 1) + "/" + total);
                }
                String procInstId = (String)((HashMap)list.get(i)).get("fid");
                sql = "select fprocinstid,fcode,fcreatedtime, fcomletetime,fstate,fprocdefid from " + table + " where fprocinstid='" + procInstId + "'";
                ArrayList tmp = SQL.executeQuery((Context)this.ctx, (String)sql);
                if (tmp.size() == 1) {
                    JobState jobState;
                    HashMap item = (HashMap)tmp.get(0);
                    String jobInstId = (String)item.get("fprocinstid");
                    String title = (String)item.get("fcode");
                    Date createdTime = (Date)item.get("fcreatedtime");
                    Date finishTime = (Date)item.get("fcomletetime");
                    String jobDefId = ((String)item.get("fprocdefid")).substring(0, 36) + "BGJOBDEF";
                    String state = item.get("fstate").toString();
                    if ("open.not_running.not_started".equals(state) || "open.running".equals(state) || "open.not_running".equals(state) || "open".equals(state)) {
                        if (deadline.before(createdTime)) {
                            sql = "update T_JOB_UPGRADE set FFLAG='N' where FID='" + jobInstId + "'";
                            SQL.executeUpdate((Context)this.ctx, (String)sql);
                            ++count2;
                            continue;
                        }
                        jobState = JobState.Missed;
                        ++count3;
                    } else {
                        jobState = "closed.completed".equals(state) ? JobState.Complete : ("closed.aborted".equals(state) ? JobState.Aborted : JobState.Failed);
                    }
                    sql = "insert into t_job_insthst( fjobinstid,ftitle, fcreatedtime, fscheduledtime, fstartedtime, ffinishtime, fstate, fstatechangedtime, fjobdefid)values(?,?,?,?,?,?,?,?,?)";
                    int[] types = new int[]{12, 12, 93, 93, 93, 93, 12, 93, 12};
                    Object[] values = new Object[]{jobInstId, title, createdTime, createdTime, createdTime, finishTime, jobState.toString(), finishTime, jobDefId};
                    String s = "select fjobinstid from t_job_insthst where fjobinstid='" + jobInstId + "'";
                    if (SQL.executeQuery((Context)this.ctx, (String)s).size() == 0) {
                        SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
                        s = "select fownerid from t_job_log where fownerid='" + jobInstId + "'";
                        if (SQL.executeQuery((Context)this.ctx, (String)s).size() == 0) {
                            sql = "insert into t_job_log(fid, fownerid, fcreatedtime, findex, fmsgtype, fdescription, fexception) select fid, fprocessinstid,ftime, 0,  case flogtype when 0 then 'Info' when 1 then 'Info' when 2 then 'Warn' else 'Error' end, '\u670d\u52a1\u5668: '||fserver, fextendeddescription from t_wfr_processinstlog where fprocessinstid='" + jobInstId + "'";
                            SQL.executeUpdate((Context)this.ctx, (String)sql);
                        }
                        ++count4;
                    }
                }
                sql = "delete from T_JOB_UPGRADE where fid='" + procInstId + "'";
                SQL.executeUpdate((Context)this.ctx, (String)sql);
                ++count;
            }
        }
        if (job != null) {
            JobLog log = new JobLog(JobLog.Type.Warn, "\u8868{" + table + "}\u4e2d\u6709" + count3 + "\u4e2a\u540e\u53f0\u4e8b\u52a1\u6d41\u7a0b\u5b9e\u4f8b\u7531\u4e8e\u521b\u5efa\u65f6\u95f4\u662f\u57283\u5c0f\u65f6\u524d\u4e14\u672a\u7ed3\u675f\uff0c\u5176\u72b6\u6001\u88ab\u8bbe\u7f6e\u4e3a\u201c\u9519\u8fc7\u201d\u3002");
            job.saveMessage(log);
            log = new JobLog(JobLog.Type.Info, "\u8868{" + table + "}\u6210\u529f\u8f6c\u50a8 " + count + " \u4e2a\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\uff0c\u5176\u4e2d\u65b0\u589e\u8f6c\u50a8" + count4 + "\u4e2a\u3002");
            job.saveMessage(log);
        }
        return count2;
    }

    private void finish() throws BOSException {
        String sql = "drop table T_JOB_UPGRADE";
        SQL.executeUpdate((Context)this.ctx, (String)sql);
    }

    public Object execute(Job job) throws Exception {
        JobLog log;
        int from;
        this.ctx = job.getContext();
        Integer x = (Integer)job.getParameters();
        if (x == null) {
            JobLog log2 = new JobLog(JobLog.Type.Info, "\u5f00\u59cb\u5347\u7ea7\u540e\u53f0\u4e8b\u52a1...");
            job.saveMessage(log2);
            x = new Integer(0);
            job.saveParameter((Object)x);
        }
        if ((from = x.intValue()) == 0) {
            log = new JobLog(JobLog.Type.Info, "\u5f00\u59cb\u5347\u7ea7\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49...");
            job.saveMessage(log);
            job.setProgress("\u5f00\u59cb\u5347\u7ea7\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49...");
            this.upgradeJobDef(job);
            from = 1;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 1) {
            job.setProgress("\u5f00\u59cb\u542f\u7528\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49...");
            this.enableTrigger(job);
            from = 2;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 2) {
            job.setProgress("\u6b63\u5728\u51c6\u5907\u8f6c\u50a8\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b...");
            this.prepareDumpJobProcInst("T_WFR_ProcInst", job);
            from = 3;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 3) {
            int b = this.dumpJobProcInst("T_WFR_ProcInst", job);
            if (b > 0) {
                job.setProgress("\u7531\u4e8e\u6709{" + b + "}\u4e2a\u540e\u53f0\u4e8b\u52a1\u7684\u6d41\u7a0b\u5b9e\u4f8b\u5904\u4e8e\u6267\u884c\u72b6\u6001\uff0c1\u5c0f\u65f6\u540e\u518d\u91cd\u8bd5...");
                return new Delay((Object)new Integer(from), 3600);
            }
            from = 4;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 4) {
            job.setProgress("\u6b63\u5728\u51c6\u5907\u8f6c\u50a8\u540e\u53f0\u4e8b\u52a1\u5b9e\u4f8b\u5386\u53f2\u6570\u636e...");
            this.prepareDumpJobProcInst("T_WFR_ProcInstHst", job);
            from = 5;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 5) {
            this.dumpJobProcInst("T_WFR_ProcInstHst", job);
            from = 6;
            job.saveParameter((Object)new Integer(from));
        }
        if (from == 6) {
            this.finish();
            log = new JobLog(JobLog.Type.Info, "\u540e\u53f0\u4e8b\u52a1\u5347\u7ea7\u6210\u529f.");
            job.saveMessage(log);
        }
        return "OK";
    }
}

