/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DateConvertor
extends AbstractConvertor {
    private static Logger logger = Logger.getLogger(DateConvertor.class);

    @Override
    public Object stringToObject(String value) throws WfException {
        Date date;
        if (RelevantDataType.isNULL(value)) {
            return new Date();
        }
        try {
            Long time = new Long(value);
            date = new Date(time);
        }
        catch (Throwable t) {
            SimpleDateFormat formatter = value.indexOf("-") >= 0 ? new SimpleDateFormat("yyyy-MM-dd") : (value.indexOf("\u5e74") >= 0 ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5") : (value.indexOf("/") >= 0 ? new SimpleDateFormat("yyyy/MM/dd") : (value.indexOf(",") >= 0 ? new SimpleDateFormat("MMMM dd, yyyy", Locale.US) : new SimpleDateFormat())));
            try {
                date = formatter.parse(value);
            }
            catch (ParseException ex) {
                logger.error((Object)"stringToObject error(transform)", (Throwable)ex);
                date = new Date();
            }
        }
        return date;
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof Date)) {
            this.objectToStringException(value);
        }
        Date fieldValue = (Date)value;
        long time = fieldValue.getTime();
        return String.valueOf(time);
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] dateArray = new Date[objectArray.length];
            System.arraycopy(objectArray, 0, dateArray, 0, objectArray.length);
            return dateArray;
        }
        return new Date[this.relevantData.getDataType().getLength()];
    }

    public DateConvertor(RelevantData value) {
        super(value);
    }
}

