/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.TypeConversionUtils;

public class FloatConvertor
extends AbstractConvertor {
    @Override
    protected Object stringToObject(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return new Float(0.0f);
        }
        return new Float(TypeConversionUtils.objToFloat((Object)value));
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof Float)) {
            this.objectToStringException(value);
        }
        Float fieldValue = (Float)value;
        return String.valueOf(fieldValue);
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] floatArray = new Float[objectArray.length];
            System.arraycopy(objectArray, 0, floatArray, 0, objectArray.length);
            return floatArray;
        }
        return new Float[this.relevantData.getDataType().getLength()];
    }

    public FloatConvertor(RelevantData value) {
        super(value);
    }
}

