/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.AbstractConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.util.TypeConversionUtils;

public class IntegerConvertor
extends AbstractConvertor {
    @Override
    protected Object stringToObject(String value) throws WfException {
        if (RelevantDataType.isNULL(value)) {
            return new Integer(0);
        }
        int returnValue = TypeConversionUtils.objToInt((Object)value);
        return new Integer(returnValue);
    }

    @Override
    protected String objectToString(Object value) throws WfException {
        if (value == null) {
            return "##NULL##";
        }
        if (!(value instanceof Integer)) {
            this.objectToStringException(value);
        }
        Integer fieldValue = (Integer)value;
        return String.valueOf(fieldValue);
    }

    @Override
    protected Object[] stringToArray(String value) throws WfException {
        Object[] objectArray = super.stringToArray(value);
        if (objectArray != null) {
            Object[] integerArray = new Integer[objectArray.length];
            System.arraycopy(objectArray, 0, integerArray, 0, objectArray.length);
            return integerArray;
        }
        return new Integer[this.relevantData.getDataType().getLength()];
    }

    public IntegerConvertor(RelevantData value) {
        super(value);
    }
}

