/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.application.WfSerializable;
import com.kingdee.bos.workflow.store.util.DefaultConvertor;
import com.kingdee.bos.workflow.store.util.IRelevantDataValueConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.UnknownObjectConvertor;
import com.kingdee.bos.workflow.store.util.WfSerializableConvertor;

public class ObjectConvertor
implements IRelevantDataValueConvertor {
    private RelevantData relevantData;

    private IRelevantDataValueConvertor createConvertor(Object value) {
        String minorType = this.relevantData.getDataType().getMinorType();
        if ("EXTERNALTYPE.OBJECT.WFSERIALIZABLE".equalsIgnoreCase(minorType)) {
            WfSerializableConvertor convertor = new WfSerializableConvertor(this.relevantData);
            return convertor;
        }
        if ("EXTERNALTYPE.OBJECT.UNKNOWNOBJECT".equalsIgnoreCase(minorType)) {
            UnknownObjectConvertor convertor = new UnknownObjectConvertor(this.relevantData);
            return convertor;
        }
        if (minorType == null || minorType.trim().length() == 0 || "EXTERNALTYPE.OBJECT".endsWith(minorType)) {
            if (value == null) {
                return new DefaultConvertor(this.relevantData);
            }
            if (value instanceof WfSerializable || value instanceof WfSerializable[]) {
                this.relevantData.getDataType().setMinorType("EXTERNALTYPE.OBJECT.WFSERIALIZABLE");
                WfSerializableConvertor convertor = new WfSerializableConvertor(this.relevantData);
                return convertor;
            }
            this.relevantData.getDataType().setMinorType("EXTERNALTYPE.OBJECT.UNKNOWNOBJECT");
            UnknownObjectConvertor convertor = new UnknownObjectConvertor(this.relevantData);
            return convertor;
        }
        throw new UnsupportedOperationException();
    }

    public ObjectConvertor(RelevantData dstRelevantData) {
        if (dstRelevantData == null) {
            throw new IllegalArgumentException();
        }
        this.relevantData = dstRelevantData;
    }

    @Override
    public String valueToString(Object value) throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(value);
        return convertor.valueToString(value);
    }

    @Override
    public Object stringToValue() throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(null);
        return convertor.stringToValue();
    }
}

