/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.store.util.BOIDConvertor;
import com.kingdee.bos.workflow.store.util.DefaultConvertor;
import com.kingdee.bos.workflow.store.util.IRelevantDataValueConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.StringConvertor;

public class PerformerConvertor
implements IRelevantDataValueConvertor {
    private RelevantData relevantData;

    private IRelevantDataValueConvertor createConvertor(Object value) {
        String minorType = this.relevantData.getDataType().getMinorType();
        if ("BOID".equalsIgnoreCase(minorType)) {
            BOIDConvertor convertor = new BOIDConvertor(this.relevantData);
            return convertor;
        }
        if ("STRING".equalsIgnoreCase(minorType)) {
            StringConvertor convertor = new StringConvertor(this.relevantData);
            return convertor;
        }
        if (minorType == null || minorType.trim().length() == 0) {
            if (value == null) {
                return new DefaultConvertor(this.relevantData);
            }
            if (value instanceof BOSUuid) {
                this.relevantData.getDataType().setMinorType("BOID");
                BOIDConvertor convertor = new BOIDConvertor(this.relevantData);
                return convertor;
            }
            if (value instanceof String) {
                this.relevantData.getDataType().setMinorType("STRING");
                StringConvertor convertor = new StringConvertor(this.relevantData);
                return convertor;
            }
        }
        throw new UnsupportedOperationException();
    }

    public PerformerConvertor(RelevantData dstRelevantData) {
        if (dstRelevantData == null) {
            throw new IllegalArgumentException();
        }
        this.relevantData = dstRelevantData;
    }

    @Override
    public String valueToString(Object value) throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(value);
        return convertor.valueToString(value);
    }

    @Override
    public Object stringToValue() throws WfException {
        IRelevantDataValueConvertor convertor = this.createConvertor(null);
        return convertor.stringToValue();
    }
}

