/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.store.util.RelevantDataType;
import com.kingdee.bos.workflow.store.util.RelevantDataValueConvertor;
import org.jdom2.Content;
import org.jdom2.Element;

public class RelevantData {
    private String ID = "";
    private String name = "";
    private RelevantDataType dataType = null;
    private String innerValue = null;

    public void initial(Element value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.ID = value.getAttributeValue("ID");
        this.name = value.getAttributeValue("Name");
        RelevantDataType relevantDataType = new RelevantDataType();
        relevantDataType.initial(value.getChild("DataType"));
        this.dataType = relevantDataType;
        this.innerValue = value.getChild("Value").getText();
    }

    public void initial(DataFieldDef dataFieldDef) {
        if (dataFieldDef == null) {
            throw new IllegalArgumentException();
        }
        this.ID = dataFieldDef.getID();
        this.name = dataFieldDef.getName();
        RelevantDataType relevantDataType = new RelevantDataType();
        relevantDataType.initial(dataFieldDef.getDataType(), dataFieldDef.getLength(), dataFieldDef.isArray());
        this.dataType = relevantDataType;
        this.innerValue = dataFieldDef.getInitValue();
    }

    public void initial(String datafieldName, Object value) throws WfException {
        this.ID = datafieldName;
        this.name = datafieldName;
        RelevantDataType relevantDataType = new RelevantDataType();
        relevantDataType.initial(value);
        this.dataType = relevantDataType;
        this.setValue(value);
    }

    public Element toElement() {
        Element dataFieldElement = new Element("DataField");
        dataFieldElement.setAttribute("ID", this.ID);
        dataFieldElement.setAttribute("Name", this.name);
        Element dataTypeElement = this.dataType.toElement();
        dataFieldElement.addContent((Content)dataTypeElement);
        Element valueElement = new Element("Value");
        valueElement.setText(this.innerValue);
        dataFieldElement.addContent((Content)valueElement);
        return dataFieldElement;
    }

    public String getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getInnerValue() {
        return this.innerValue;
    }

    public void setInnerValue(String value) {
        this.innerValue = value;
    }

    public Object getValue() throws WfException {
        RelevantDataValueConvertor convertor = new RelevantDataValueConvertor(this);
        if (this.dataType.getMajorType().equals("EXTERNALTYPE.OBJECT") && RelevantDataType.isNULL(this.innerValue)) {
            return null;
        }
        Object fieldValueObject = convertor.stringToValue();
        return fieldValueObject;
    }

    public void setValue(Object valueObj) throws WfException {
        String fieldValue;
        RelevantDataValueConvertor convertor = new RelevantDataValueConvertor(this);
        this.innerValue = fieldValue = convertor.valueToString(valueObj);
    }

    public RelevantDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(RelevantDataType type) {
        this.dataType = type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Id=" + this.ID);
        buffer.append(";Name=" + this.name);
        buffer.append(";Value=" + this.innerValue);
        buffer.append(";" + this.dataType.toString());
        return buffer.toString();
    }
}

