/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.store.util.BOIDConvertor;
import com.kingdee.bos.workflow.store.util.BooleanConvertor;
import com.kingdee.bos.workflow.store.util.DateConvertor;
import com.kingdee.bos.workflow.store.util.ExternalTypeConvertor;
import com.kingdee.bos.workflow.store.util.FloatConvertor;
import com.kingdee.bos.workflow.store.util.IRelevantDataValueConvertor;
import com.kingdee.bos.workflow.store.util.IntegerConvertor;
import com.kingdee.bos.workflow.store.util.ObjectConvertor;
import com.kingdee.bos.workflow.store.util.PKConvertor;
import com.kingdee.bos.workflow.store.util.PerformerConvertor;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.StringConvertor;

public class RelevantDataValueConvertorFactory {
    public static IRelevantDataValueConvertor getConvertor(RelevantData dstRelevantData) {
        if (dstRelevantData == null) {
            throw new IllegalArgumentException();
        }
        String majorDataType = dstRelevantData.getDataType().getMajorType();
        if ("BOOLEAN".equals(majorDataType)) {
            return new BooleanConvertor(dstRelevantData);
        }
        if ("INTEGER".equals(majorDataType)) {
            return new IntegerConvertor(dstRelevantData);
        }
        if ("FLOAT".equals(majorDataType)) {
            return new FloatConvertor(dstRelevantData);
        }
        if ("DATETIME".equals(majorDataType)) {
            return new DateConvertor(dstRelevantData);
        }
        if ("STRING".equals(majorDataType)) {
            return new StringConvertor(dstRelevantData);
        }
        if ("BOID".equals(majorDataType)) {
            return new BOIDConvertor(dstRelevantData);
        }
        if ("PK".equals(majorDataType)) {
            return new PKConvertor(dstRelevantData);
        }
        if ("PERFORMER".equals(majorDataType)) {
            return new PerformerConvertor(dstRelevantData);
        }
        if ("OBJECTVALUE".equals(majorDataType) || "APPROVERESULT".equals(majorDataType)) {
            return new ObjectConvertor(dstRelevantData);
        }
        if ("EXTERNALTYPE".equals(majorDataType)) {
            return new ExternalTypeConvertor(dstRelevantData);
        }
        throw new UnsupportedOperationException(majorDataType.toString());
    }
}

