/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.DataFieldCollection;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.exception.RelevantDatasInitialException;
import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.bos.workflow.store.util.RelevantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class RelevantDatas {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.store.util.RelevantDatas");
    private HashMap relevantDatas = new HashMap();

    public void initial(DataFieldCollection value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int size = value.size() - 1;
        for (int i = 0; i <= size; ++i) {
            DataFieldDef dataFieldDef = value.get(i);
            RelevantData relevantData = new RelevantData();
            relevantData.initial(dataFieldDef);
            this.relevantDatas.put(relevantData.getName(), relevantData);
        }
    }

    public void initial(String xml) throws RelevantDatasInitialException {
        Document doc = RelevantUtils.parseXML(xml);
        if (doc != null) {
            Element rootElement = doc.getRootElement();
            List dataFieldList = rootElement.getChildren("DataField");
            for (Element dataFieldElement : dataFieldList) {
                RelevantData relevantData = new RelevantData();
                relevantData.initial(dataFieldElement);
                this.relevantDatas.put(relevantData.getName(), relevantData);
            }
        }
    }

    public HashMap readValue() throws WfException {
        if (this.relevantDatas != null && this.relevantDatas.size() > 0) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (RelevantData relevantData : this.relevantDatas.values()) {
                Object fieldValue = relevantData.getValue();
                result.put(relevantData.getName(), fieldValue);
            }
            return result;
        }
        return new HashMap();
    }

    public void writeValue(Map value) throws WfException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = value.entrySet().iterator();
        ArrayList<String> bizObjKey = new ArrayList<String>();
        while (iterator.hasNext()) {
            Object relevantDataObj;
            String fn;
            Map.Entry entery = iterator.next();
            Object fieldName = entery.getKey();
            Object fieldValue = entery.getValue();
            if (fieldName instanceof String && (fn = (String)fieldName).startsWith("$")) {
                if (fn.indexOf(".bizId$") > 0) {
                    bizObjKey.add(fn.substring(1, fn.length() - 8));
                } else if (fn.indexOf(".approveId$") > 0) {
                    bizObjKey.add(fn.substring(1, fn.length() - 12));
                }
            }
            if ((relevantDataObj = this.relevantDatas.get(fieldName)) != null) {
                RelevantData relevantData = (RelevantData)relevantDataObj;
                relevantData.setValue(fieldValue);
                continue;
            }
            RelevantData newRelevantData = new RelevantData();
            newRelevantData.initial((String)fieldName, fieldValue);
            this.relevantDatas.put(fieldName, newRelevantData);
        }
        iterator = bizObjKey.iterator();
        while (iterator.hasNext()) {
            this.relevantDatas.remove(iterator.next());
        }
    }

    public Element toElement() {
        int size;
        Element dataFieldsElement = new Element("DataFields");
        if (this.relevantDatas != null && (size = this.relevantDatas.size()) > 0) {
            Collection dataFieldsCollection = this.relevantDatas.values();
            for (RelevantData relevantData : dataFieldsCollection) {
                dataFieldsElement.addContent((Content)relevantData.toElement());
            }
        }
        return dataFieldsElement;
    }

    public String toXML() {
        String rtn = "";
        long time = System.currentTimeMillis();
        Element rootElement = this.toElement();
        if (rootElement != null) {
            Document document = new Document(rootElement);
            XMLOutputter xml = new XMLOutputter();
            rtn = xml.outputString(document);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RelevantDatas.toXML cost: " + (System.currentTimeMillis() - time)));
        }
        return rtn;
    }

    public int size() {
        return this.relevantDatas.size();
    }
}

