/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.workflow.store.util.RelevantData;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;

public class RelevantUtils {
    protected static final Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.store.util.RelevantUtils");

    public static Object getArrayInitValue(RelevantData value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (!value.getDataType().isArray()) {
            throw new IllegalConversionException("No Array");
        }
        int length = value.getDataType().getLength() < 1 ? 1 : value.getDataType().getLength();
        String fieldValue = value.getInnerValue();
        String dataType = value.getDataType().getMajorType();
        Object[] fieldInitValue = null;
        String[] initString = null;
        if (dataType.equalsIgnoreCase("BOOLEAN")) {
            fieldInitValue = new Boolean[length];
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                initString = StringUtils.split((String)fieldValue, (String)",");
                for (int i = 0; i < initString.length; ++i) {
                    if (i > length) continue;
                    fieldInitValue[i] = TypeConversionUtils.objToBoolean((Object)initString[i]);
                }
            }
        } else if (dataType.equalsIgnoreCase("INTEGER")) {
            fieldInitValue = new Integer[length];
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                initString = StringUtils.split((String)fieldValue, (String)",");
                for (int i = 0; i < initString.length; ++i) {
                    if (i > length) continue;
                    fieldInitValue[i] = new Integer(initString[i]);
                }
            }
        } else if (dataType.equalsIgnoreCase("FLOAT")) {
            fieldInitValue = new Float[length];
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                initString = StringUtils.split((String)fieldValue, (String)",");
                for (int i = 0; i < initString.length; ++i) {
                    if (i > length) continue;
                    fieldInitValue[i] = new Float(TypeConversionUtils.objToFloat((Object)initString[i]));
                }
            }
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            fieldInitValue = new Date[length];
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                initString = StringUtils.split((String)fieldValue, (String)",");
                for (int i = 0; i < initString.length; ++i) {
                    if (i > length) continue;
                    fieldInitValue[i] = TypeConversionUtils.objToUtilDate((Object)initString[i]);
                }
            }
        } else if (dataType.equalsIgnoreCase("STRING") || dataType.equalsIgnoreCase("BOID") || dataType.equalsIgnoreCase("PERFORMER")) {
            fieldInitValue = new String[length];
            if (fieldValue != null && fieldValue.trim().length() > 0) {
                initString = StringUtils.split((String)fieldValue, (String)",");
                for (int i = 0; i < initString.length; ++i) {
                    if (i > length) continue;
                    fieldInitValue[i] = initString[i];
                }
            }
        } else if (dataType.equalsIgnoreCase("EXTERNALTYPE")) {
            fieldInitValue = new Object[length];
        } else {
            throw new IllegalConversionException("Unknown datatype : " + dataType);
        }
        return fieldInitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseXML(String xml) {
        if (xml == null) return null;
        if (xml.length() <= 0) {
            return null;
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes("utf-8"));
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = JDOMFactory.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
                if (inputStream.available() == 0) {
                    Document document = null;
                    return document;
                }
                Document document = builder.build((InputStream)inputStream);
                return document;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)("relevant error. \n" + xml), (Throwable)ex);
            return null;
        }
        catch (JDOMException ex) {
            log.error((Object)("relevant error. \n" + xml), (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            log.error((Object)("relevant error. \n" + xml), (Throwable)ex);
            return null;
        }
    }
}

