/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.store.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.ActInstHstInfo;
import com.kingdee.bos.workflow.metas.ActInstInfo;
import com.kingdee.bos.workflow.metas.AssignHstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.ProcInstHstInfo;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StoreUtils {
    public static ProcessInstInfo[] toProcessInstInfoArray(Object[] oa) {
        if (oa == null || oa.length == 0) {
            return new ProcessInstInfo[0];
        }
        int count = oa.length;
        ProcessInstInfo[] piia = new ProcessInstInfo[count];
        for (int i = 0; i <= count - 1; ++i) {
            Object obj = oa[i];
            if (obj instanceof ProcInstInfo) {
                ProcInstInfo pii = (ProcInstInfo)obj;
                piia[i] = new ProcessInstInfo(pii);
                continue;
            }
            if (obj instanceof ProcInstHstInfo) {
                ProcInstHstInfo pii_hst = (ProcInstHstInfo)obj;
                ProcInstInfo pii = new ProcInstInfo(pii_hst.getValues());
                ProcessInstInfo pii_ex = new ProcessInstInfo(pii);
                pii_ex.setHistory(true);
                piia[i] = pii_ex;
                continue;
            }
            if (obj instanceof ProcessInstInfo) {
                piia[i] = (ProcessInstInfo)obj;
                continue;
            }
            throw new IllegalArgumentException(obj.getClass().getName());
        }
        return piia;
    }

    public static ActivityInstInfo[] toActivityInstInfoArray(Object[] oa) {
        if (oa == null || oa.length == 0) {
            return new ActivityInstInfo[0];
        }
        int count = oa.length;
        ActivityInstInfo[] aiia = new ActivityInstInfo[count];
        for (int i = 0; i <= count - 1; ++i) {
            Object obj = oa[i];
            if (obj instanceof ActInstInfo) {
                ActivityInstInfo aiiex;
                ActInstInfo aii = (ActInstInfo)obj;
                aiia[i] = aiiex = new ActivityInstInfo(aii);
                continue;
            }
            if (obj instanceof ActInstHstInfo) {
                ActInstHstInfo aii_hst = (ActInstHstInfo)obj;
                ActInstInfo activityii = new ActInstInfo(aii_hst.getValues());
                ActivityInstInfo aii_ex = new ActivityInstInfo(activityii);
                aii_ex.setHistory(true);
                aiia[i] = aii_ex;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return aiia;
    }

    public static AssignmentInfo[] toAssignmentInfoArray(Object[] oa) {
        if (oa == null || oa.length == 0) {
            return new AssignmentInfo[0];
        }
        int count = oa.length;
        AssignmentInfo[] aia = new AssignmentInfo[count];
        for (int i = 0; i <= count - 1; ++i) {
            Object obj = oa[i];
            if (obj instanceof AssignInfo) {
                aia[i] = new AssignmentInfo((AssignInfo)obj);
                continue;
            }
            if (obj instanceof AssignHstInfo) {
                AssignHstInfo ahi = (AssignHstInfo)obj;
                AssignInfo ai = new AssignInfo(ahi.getValues());
                AssignmentInfo ai_ex = new AssignmentInfo(ai);
                ai_ex.setHistory(true);
                aia[i] = ai_ex;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return aia;
    }

    public static AssignmentInfo[] catAssignmentInfoArray(AssignmentInfo[] arrayFirst, AssignmentInfo[] arraySecond) {
        if (!(arrayFirst != null && arrayFirst.length != 0 || arraySecond != null && arraySecond.length != 0)) {
            return new AssignmentInfo[0];
        }
        if (arrayFirst == null || arrayFirst.length == 0) {
            return arraySecond;
        }
        if (arraySecond == null || arraySecond.length == 0) {
            return arrayFirst;
        }
        int lenthFirst = arrayFirst.length;
        int lenthSecond = arraySecond.length;
        AssignmentInfo[] result = new AssignmentInfo[lenthFirst + lenthSecond];
        System.arraycopy(arrayFirst, 0, result, 0, lenthFirst);
        System.arraycopy(arraySecond, 0, result, lenthFirst, lenthSecond);
        return result;
    }

    public static ProcessInstInfo[] catProcessInstInfoArray(ProcessInstInfo[] arrayFirst, ProcessInstInfo[] arraySecond) {
        if (!(arrayFirst != null && arrayFirst.length != 0 || arraySecond != null && arraySecond.length != 0)) {
            return new ProcessInstInfo[0];
        }
        if (arrayFirst == null || arrayFirst.length == 0) {
            return arraySecond;
        }
        if (arraySecond == null || arraySecond.length == 0) {
            return arrayFirst;
        }
        int lenthFirst = arrayFirst.length;
        int lenthSecond = arraySecond.length;
        ProcessInstInfo[] result = new ProcessInstInfo[lenthFirst + lenthSecond];
        System.arraycopy(arrayFirst, 0, result, 0, lenthFirst);
        System.arraycopy(arraySecond, 0, result, lenthFirst, lenthSecond);
        return result;
    }

    public static void setAsciiStream(PreparedStatement stmt, int index, String id) throws SQLException {
        if (id != null) {
            byte[] bytes = id.getBytes();
            SerializableByteArrayInputStream stream = new SerializableByteArrayInputStream(bytes);
            stmt.setAsciiStream(index, (InputStream)stream, bytes.length);
        } else {
            stmt.setNull(index, 12);
        }
    }

    public static String webUIName2URL(String pk) {
        String name;
        int i;
        if (pk == null || pk.length() == 0) {
            return null;
        }
        if (pk.indexOf("pureWFBillUrl") > 0) {
            return pk;
        }
        String PREFIX = "com.kingdee.eas";
        if (pk.startsWith("com.kingdee.eas")) {
            pk = pk.substring("com.kingdee.eas".length());
        }
        StringBuffer url = new StringBuffer();
        String[] ms = pk.split("\\.");
        if (ms.length > 2 && "web".equals(ms[ms.length - 2])) {
            for (i = 0; i < ms.length - 2; ++i) {
                url.append(ms[i]).append("/");
            }
        } else {
            for (i = 0; i < ms.length - 1; ++i) {
                url.append(ms[i]).append("/");
            }
        }
        name = (name = ms[ms.length - 1]).endsWith("Page") ? name.substring(0, 1).toLowerCase() + name.substring(1) + ".do?method=initalize" : name.substring(0, 1).toLowerCase() + name.substring(1) + ".jsf";
        url.append(name);
        return url.toString();
    }

    public static String getWebUI(String billId, Context ctx) {
        if (billId == null) {
            return null;
        }
        BOSUuid id = BOSUuid.read((String)billId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo billObject = loader.getEntity(id.getType());
        if (billObject == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        String webUI = billObject.getExtendedProperty("pureWFBillUrl");
        if (!StringUtils.isEmpty((String)webUI)) {
            webUI = webUI.indexOf("?") > 0 ? webUI + "&pureWFBillUrl=true" : webUI + "?pureWFBillUrl=true";
        }
        if (StringUtils.isEmpty((String)webUI)) {
            webUI = billObject.getExtendedProperty("webEditPage");
        }
        if (StringUtils.isEmpty((String)webUI)) {
            webUI = billObject.getExtendedProperty("webEditUI");
        }
        return webUI;
    }

    public static String getWebUIurl(String billId, Context ctx) {
        String webUI = StoreUtils.getWebUI(billId, ctx);
        return StoreUtils.webUIName2URL(webUI);
    }

    public static void main(String[] s) {
        StoreUtils.output().println(StoreUtils.webUIName2URL("com.kingdee.eas.hr.affair.web.HireBillSelfPage"));
        StoreUtils.output().println(StoreUtils.webUIName2URL("com.kingdee.eas.hr.affair.web.HireBillSelf"));
    }

    private static PrintStream output() {
        return System.out;
    }
}

